/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.MessageListener;
import com.limegroup.gnutella.MessageRouter;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.UDPService;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.PingRequest;
import com.limegroup.gnutella.util.Cancellable;
import com.limegroup.gnutella.util.IpPort;
import com.limegroup.gnutella.util.ProcessingQueue;
import com.sun.java.util.collections.Collection;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.Set;
import com.sun.java.util.collections.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UDPHostRanker {
    private static final Log LOG = LogFactory.getLog((Class)(class$com$limegroup$gnutella$UDPHostRanker == null ? (class$com$limegroup$gnutella$UDPHostRanker = UDPHostRanker.class$("com.limegroup.gnutella.UDPHostRanker")) : class$com$limegroup$gnutella$UDPHostRanker));
    private static final MessageRouter ROUTER = RouterService.getMessageRouter();
    private static final ProcessingQueue QUEUE = new ProcessingQueue("UDPHostRanker");
    public static int LISTEN_EXPIRE_TIME = 20000;
    private static final long SEND_INTERVAL = 500L;
    private static final int MAX_SENDS = 15;
    private static int _sentAmount;
    private static long _lastSentTime;
    private static final Set _recent;
    static /* synthetic */ Class class$com$limegroup$gnutella$UDPHostRanker;

    public static void rank(Collection collection) {
        UDPHostRanker.rank(collection, null, null, null);
    }

    public static void rank(Collection collection, Message message) {
        UDPHostRanker.rank(collection, null, null, message);
    }

    public static void rank(Collection collection, Cancellable cancellable) {
        UDPHostRanker.rank(collection, null, cancellable, null);
    }

    public static void rank(Collection collection, MessageListener messageListener) {
        UDPHostRanker.rank(collection, messageListener, null, null);
    }

    public static void rank(Collection collection, MessageListener messageListener, Cancellable cancellable) {
        UDPHostRanker.rank(collection, messageListener, cancellable, null);
    }

    public static void rank(Collection collection, MessageListener messageListener, Cancellable cancellable, Message message) {
        if (collection == null) {
            throw new NullPointerException("null hosts not allowed");
        }
        if (cancellable == null) {
            cancellable = new Cancellable(){

                public boolean isCancelled() {
                    return false;
                }
            };
        }
        QUEUE.add(new SenderBundle(collection, messageListener, cancellable, message));
    }

    private static boolean waitForListening(Cancellable cancellable) {
        int n;
        for (n = 0; !UDPService.instance().isListening() && n < 10 && !cancellable.isCancelled(); ++n) {
            try {
                Thread.sleep(600L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                ErrorService.error(interruptedException);
            }
        }
        return n < 10;
    }

    private static void send(SenderBundle senderBundle) {
        Object object;
        Collection collection = senderBundle.hosts;
        final MessageListener messageListener = senderBundle.listener;
        Cancellable cancellable = senderBundle.canceller;
        Message message = senderBundle.message;
        if (!UDPHostRanker.waitForListening(cancellable)) {
            return;
        }
        if (message == null) {
            message = PingRequest.createUDPPing();
        }
        final byte[] byArray = message.getGUID();
        if (messageListener != null) {
            ROUTER.registerMessageListener(byArray, messageListener);
        }
        Iterator iterator = collection.iterator();
        while (iterator.hasNext() && !cancellable.isCancelled()) {
            object = (IpPort)iterator.next();
            if (_recent.contains(object)) continue;
            _recent.add(object);
            long l = System.currentTimeMillis();
            if (l > _lastSentTime + 500L) {
                _sentAmount = 0;
            } else if (_sentAmount == 15) {
                try {
                    Thread.sleep(500L);
                    l = System.currentTimeMillis();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                _sentAmount = 0;
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Sending to " + object + ": " + message));
            }
            UDPService.instance().send(message, (IpPort)object);
            ++_sentAmount;
            _lastSentTime = l;
        }
        if (messageListener != null) {
            object = new Runnable(){

                public void run() {
                    ROUTER.unregisterMessageListener(byArray, messageListener);
                }
            };
            RouterService.schedule((Runnable)object, LISTEN_EXPIRE_TIME, 0L);
        }
    }

    static void resetData() {
        QUEUE.add(new Runnable(){

            public void run() {
                _recent.clear();
            }
        });
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        _recent = new TreeSet(IpPort.COMPARATOR);
    }

    private static class SenderBundle
    implements Runnable {
        private final Collection hosts;
        private final MessageListener listener;
        private final Cancellable canceller;
        private final Message message;

        public SenderBundle(Collection collection, MessageListener messageListener, Cancellable cancellable, Message message) {
            this.hosts = collection;
            this.listener = messageListener;
            this.canceller = cancellable;
            this.message = message;
        }

        public void run() {
            UDPHostRanker.send(this);
        }
    }
}

