/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.IncompleteFileDesc;
import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.URN;
import com.limegroup.gnutella.messages.QueryRequest;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.Comparators;
import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.HashSet;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.List;
import com.sun.java.util.collections.Map;
import com.sun.java.util.collections.Set;
import com.sun.java.util.collections.SortedMap;
import com.sun.java.util.collections.TreeMap;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;

public final class CreationTimeCache {
    private static final File CTIME_CACHE_FILE = new File(CommonUtils.getUserSettingsDir(), "createtimes.cache");
    private static CreationTimeCache instance = new CreationTimeCache();
    private final Map URN_TO_TIME_MAP = this.createMap();
    private final SortedMap TIME_TO_URNSET_MAP = new TreeMap(Comparators.inverseLongComparator());

    public static synchronized CreationTimeCache instance() {
        return instance;
    }

    private CreationTimeCache() {
        this.pruneTimes(false);
        this.constructURNMap();
    }

    public synchronized Long getCreationTime(URN uRN) {
        return (Long)this.URN_TO_TIME_MAP.get((Object)uRN);
    }

    public synchronized void removeTime(URN uRN) {
        this.removeURNFromURNSet(uRN, (Long)this.URN_TO_TIME_MAP.remove((Object)uRN));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void pruneTimes(boolean bl) {
        FileManager fileManager = RouterService.getFileManager();
        synchronized (fileManager) {
            CreationTimeCache creationTimeCache = this;
            synchronized (creationTimeCache) {
                Iterator iterator = this.URN_TO_TIME_MAP.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry entry = (Map.Entry)iterator.next();
                    URN uRN = (URN)entry.getKey();
                    Long l = (Long)entry.getValue();
                    FileDesc fileDesc = RouterService.getFileManager().getFileDescForUrn(uRN);
                    if (fileDesc != null && fileDesc.getFile() != null && fileDesc.getFile().exists()) continue;
                    iterator.remove();
                    if (!bl) continue;
                    this.removeURNFromURNSet(uRN, l);
                }
            }
        }
    }

    public synchronized void pruneTimes() {
        this.pruneTimes(true);
    }

    public synchronized void addTime(URN uRN, long l) throws IllegalArgumentException {
        if (uRN == null) {
            throw new IllegalArgumentException("Null URN.");
        }
        if (l <= 0L) {
            throw new IllegalArgumentException("Bad Time = " + l);
        }
        Long l2 = new Long(l);
        this.URN_TO_TIME_MAP.put((Object)uRN, (Object)l2);
    }

    public synchronized void commitTime(URN uRN) throws IllegalArgumentException {
        if (uRN == null) {
            throw new IllegalArgumentException("Null URN.");
        }
        Long l = (Long)this.URN_TO_TIME_MAP.get((Object)uRN);
        if (l == null) {
            throw new IllegalArgumentException("Never added URN via addTime()");
        }
        Set set = (Set)this.TIME_TO_URNSET_MAP.get((Object)l);
        if (set == null) {
            set = new HashSet();
            this.TIME_TO_URNSET_MAP.put((Object)l, (Object)set);
        }
        set.add((Object)uRN);
    }

    public synchronized List getFiles(int n) throws IllegalArgumentException {
        return this.getFiles(null, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getFiles(QueryRequest queryRequest, int n) throws IllegalArgumentException {
        FileManager fileManager = RouterService.getFileManager();
        synchronized (fileManager) {
            CreationTimeCache creationTimeCache = this;
            synchronized (creationTimeCache) {
                Object object;
                Iterator iterator;
                if (n < 1) {
                    throw new IllegalArgumentException("bad max = " + n);
                }
                ArrayList arrayList = new ArrayList();
                Iterator iterator2 = this.TIME_TO_URNSET_MAP.entrySet().iterator();
                MediaType.Aggregator aggregator = queryRequest == null ? null : MediaType.getAggregator(queryRequest);
                ArrayList arrayList2 = null;
                while (iterator2.hasNext() && arrayList.size() < n) {
                    iterator = (Map.Entry)iterator2.next();
                    object = (Set)iterator.getValue();
                    Iterator iterator3 = object.iterator();
                    while (arrayList.size() < n && iterator3.hasNext()) {
                        URN uRN = (URN)iterator3.next();
                        FileDesc fileDesc = RouterService.getFileManager().getFileDescForUrn(uRN);
                        if (fileDesc == null || fileDesc instanceof IncompleteFileDesc) {
                            if (arrayList2 == null) {
                                arrayList2 = new ArrayList();
                            }
                            arrayList2.add((Object)uRN);
                            continue;
                        }
                        if (aggregator == null) {
                            arrayList.add((Object)uRN);
                            continue;
                        }
                        if (!aggregator.allow(fileDesc.getName())) continue;
                        arrayList.add((Object)uRN);
                    }
                }
                if (arrayList2 != null) {
                    iterator = arrayList2.iterator();
                    while (iterator.hasNext()) {
                        object = (URN)iterator.next();
                        this.removeTime((URN)object);
                    }
                }
                return arrayList;
            }
        }
    }

    public synchronized List getFiles() {
        return this.getFiles(Integer.MAX_VALUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void persistCache() {
        ObjectOutputStream objectOutputStream = null;
        try {
            objectOutputStream = new ObjectOutputStream(new FileOutputStream(CTIME_CACHE_FILE));
            objectOutputStream.writeObject(this.URN_TO_TIME_MAP);
        }
        catch (IOException iOException) {
            ErrorService.error(iOException);
        }
        finally {
            try {
                if (objectOutputStream != null) {
                    objectOutputStream.close();
                }
            }
            catch (IOException iOException) {}
        }
    }

    private synchronized void removeURNFromURNSet(URN uRN, Long l) {
        block2: {
            block1: {
                if (l == null) break block1;
                Set set = (Set)this.TIME_TO_URNSET_MAP.get((Object)l);
                if (set == null || !set.remove((Object)uRN) || set.size() >= 1) break block2;
                this.TIME_TO_URNSET_MAP.remove((Object)l);
                break block2;
            }
            Iterator iterator = this.TIME_TO_URNSET_MAP.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = (Map.Entry)iterator.next();
                Set set = (Set)entry.getValue();
                if (!set.contains((Object)uRN)) continue;
                set.remove((Object)uRN);
                if (set.size() >= 1) break;
                iterator.remove();
                break;
            }
        }
    }

    private void constructURNMap() {
        Set set = this.URN_TO_TIME_MAP.entrySet();
        Iterator iterator = set.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            Long l = (Long)entry.getValue();
            URN uRN = (URN)entry.getKey();
            if (RouterService.getFileManager().getFileDescForUrn(uRN) instanceof IncompleteFileDesc) continue;
            Set set2 = (Set)this.TIME_TO_URNSET_MAP.get((Object)l);
            if (set2 == null) {
                set2 = new HashSet();
                this.TIME_TO_URNSET_MAP.put((Object)l, (Object)set2);
            }
            set2.add((Object)uRN);
        }
    }

    /*
     * Exception decompiling
     */
    private Map createMap() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 4 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

