/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.ByteReader;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.handshaking.BadHandshakeException;
import com.limegroup.gnutella.handshaking.HandshakeResponder;
import com.limegroup.gnutella.handshaking.HandshakeResponse;
import com.limegroup.gnutella.handshaking.NoGnutellaOkException;
import com.limegroup.gnutella.messages.BadPacketException;
import com.limegroup.gnutella.messages.Message;
import com.limegroup.gnutella.messages.vendor.CapabilitiesVM;
import com.limegroup.gnutella.messages.vendor.MessagesSupportedVendorMessage;
import com.limegroup.gnutella.messages.vendor.StatisticVendorMessage;
import com.limegroup.gnutella.messages.vendor.VendorMessage;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.settings.StringSetting;
import com.limegroup.gnutella.statistics.BandwidthStat;
import com.limegroup.gnutella.statistics.CompressionStat;
import com.limegroup.gnutella.statistics.ConnectionStat;
import com.limegroup.gnutella.statistics.HandshakingStat;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.CompressingOutputStream;
import com.limegroup.gnutella.util.IpPort;
import com.limegroup.gnutella.util.NetworkUtils;
import com.limegroup.gnutella.util.Sockets;
import com.limegroup.gnutella.util.UncompressingInputStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Connection
implements IpPort {
    private static final Log LOG = LogFactory.getLog((Class)(class$com$limegroup$gnutella$Connection == null ? (class$com$limegroup$gnutella$Connection = Connection.class$("com.limegroup.gnutella.Connection")) : class$com$limegroup$gnutella$Connection));
    private final Object PING_LOCK = new Object();
    private final Object PONG_LOCK = new Object();
    private final String _host;
    private int _port;
    private Socket _socket;
    private InputStream _in;
    private OutputStream _out;
    private final boolean OUTGOING;
    private Inflater _inflater;
    private Deflater _deflater;
    private volatile long _bytesSent;
    private volatile long _bytesReceived;
    private volatile long _compressedBytesSent;
    private volatile long _compressedBytesReceived;
    protected MessagesSupportedVendorMessage _messagesSupported = null;
    protected CapabilitiesVM _capabilities = null;
    protected volatile boolean _closed = false;
    private final Properties HEADERS_READ = new Properties();
    private HandshakeResponse _headers = HandshakeResponse.createEmptyResponse();
    private HandshakeResponse _headersWritten = HandshakeResponse.createEmptyResponse();
    private final Properties REQUEST_HEADERS;
    protected HandshakeResponder RESPONSE_HEADERS;
    private final Properties HEADERS_WRITTEN = new Properties();
    private String GNUTELLA_CONNECT_06 = "GNUTELLA CONNECT/0.6";
    public static final String GNUTELLA_OK_06 = "GNUTELLA/0.6 200 OK";
    public static final String GNUTELLA_06 = "GNUTELLA/0.6";
    public static final String _200_OK = " 200 OK";
    public static final String GNUTELLA_06_200 = "GNUTELLA/0.6 200";
    public static final String CONNECT = "CONNECT/";
    public static final String CRLF = "\r\n";
    public static final int USER_INPUT_WAIT_TIME = 120000;
    public static final int MAX_HANDSHAKE_ATTEMPTS = 5;
    private long _connectionTime = Long.MAX_VALUE;
    private byte _softMax;
    private volatile long _nextPingTime = Long.MIN_VALUE;
    private volatile long _nextPongTime = Long.MIN_VALUE;
    protected static final IOException CONNECTION_CLOSED = new IOException("connection closed");
    private byte[] HEADER_BUF = new byte[23];
    static /* synthetic */ Class class$com$limegroup$gnutella$Connection;

    public Connection(String string, int n, Properties properties, HandshakeResponder handshakeResponder) {
        if (string == null) {
            throw new NullPointerException("null host");
        }
        if (!NetworkUtils.isValidPort(n)) {
            throw new IllegalArgumentException("illegal port: " + n);
        }
        if (properties == null) {
            throw new NullPointerException("null request headers");
        }
        if (handshakeResponder == null) {
            throw new NullPointerException("null response headers");
        }
        this._host = string;
        this._port = n;
        this.OUTGOING = true;
        this.REQUEST_HEADERS = properties;
        this.RESPONSE_HEADERS = handshakeResponder;
        if (!CommonUtils.isJava118()) {
            ConnectionStat.OUTGOING_CONNECTION_ATTEMPTS.incrementStat();
        }
    }

    public Connection(Socket socket, HandshakeResponder handshakeResponder) {
        if (socket == null) {
            throw new NullPointerException("null socket");
        }
        if (handshakeResponder == null) {
            throw new NullPointerException("null response headers");
        }
        this._host = socket.getInetAddress().getHostAddress();
        this._port = socket.getPort();
        this._socket = socket;
        this.OUTGOING = false;
        this.RESPONSE_HEADERS = handshakeResponder;
        this.REQUEST_HEADERS = null;
        if (!CommonUtils.isJava118()) {
            ConnectionStat.INCOMING_CONNECTION_ATTEMPTS.incrementStat();
        }
    }

    protected void postInit() {
        try {
            if (this._headers.supportsVendorMessages()) {
                this.send(MessagesSupportedVendorMessage.instance());
                this.send(CapabilitiesVM.instance());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void handleVendorMessage(VendorMessage vendorMessage) {
        if (vendorMessage instanceof MessagesSupportedVendorMessage) {
            this._messagesSupported = (MessagesSupportedVendorMessage)vendorMessage;
        }
        if (vendorMessage instanceof CapabilitiesVM) {
            this._capabilities = (CapabilitiesVM)vendorMessage;
        }
    }

    public void initialize() throws IOException, NoGnutellaOkException, BadHandshakeException {
        this.initialize(0);
    }

    public void initialize(int n) throws IOException, NoGnutellaOkException, BadHandshakeException {
        if (this.isOutgoing()) {
            this._socket = Sockets.connect(this._host, this._port, n);
        }
        if (this._closed) {
            this._socket.close();
            throw CONNECTION_CLOSED;
        }
        InetAddress inetAddress = this._socket.getLocalAddress();
        if (ConnectionSettings.LOCAL_IS_PRIVATE.getValue() && this._socket.getInetAddress().equals(inetAddress) && this._port == ConnectionSettings.PORT.getValue()) {
            throw new IOException("Connection to self");
        }
        RouterService.getAcceptor().setAddress(inetAddress);
        try {
            this._in = this.getInputStream();
            this._out = this.getOutputStream();
            if (this._in == null) {
                throw new IOException("null input stream");
            }
            if (this._out == null) {
                throw new IOException("null output stream");
            }
        }
        catch (Exception exception) {
            this.close();
            throw new IOException("could not establish connection");
        }
        try {
            if (this.isOutgoing()) {
                this.initializeOutgoing();
            } else {
                this.initializeIncoming();
            }
            this._headers = HandshakeResponse.createResponse(this.HEADERS_READ);
            this._headersWritten = HandshakeResponse.createResponse(this.HEADERS_WRITTEN);
            this._connectionTime = System.currentTimeMillis();
            this._softMax = ConnectionSettings.SOFT_MAX.getValue();
            if (this.isGoodUltrapeer() || this.isGoodLeaf()) {
                this._softMax = (byte)(this._softMax + 1);
            }
            if (this.isWriteDeflated()) {
                this._deflater = new Deflater();
                this._out = new CompressingOutputStream(this._out, this._deflater);
            }
            if (this.isReadDeflated()) {
                this._inflater = new Inflater();
                this._in = new UncompressingInputStream(this._in, this._inflater);
            }
            this.RESPONSE_HEADERS = null;
        }
        catch (NoGnutellaOkException noGnutellaOkException) {
            this.close();
            throw noGnutellaOkException;
        }
        catch (IOException iOException) {
            this.close();
            throw new BadHandshakeException(iOException);
        }
    }

    public boolean isInitialized() {
        return this._socket != null;
    }

    private void initializeOutgoing() throws IOException {
        this.writeLine(this.GNUTELLA_CONNECT_06 + CRLF);
        this.sendHeaders(this.REQUEST_HEADERS);
        this.concludeOutgoingHandshake();
    }

    private void concludeOutgoingHandshake() throws IOException {
        for (int i = 0; i < 5; ++i) {
            String string = this.readLine();
            Assert.that(string != null, "null connectLine");
            if (!string.startsWith(GNUTELLA_06)) {
                if (CommonUtils.recordStats()) {
                    HandshakingStat.OUTGOING_BAD_CONNECT.incrementStat();
                }
                throw new IOException("Bad connect string");
            }
            this.readHeaders();
            HandshakeResponse handshakeResponse = HandshakeResponse.createRemoteResponse(string.substring(GNUTELLA_06.length()).trim(), this.HEADERS_READ);
            Assert.that(handshakeResponse != null, "null theirResponse");
            int n = handshakeResponse.getStatusCode();
            if (n != 200 && n != 401) {
                if (n == 503) {
                    if (CommonUtils.recordStats()) {
                        if (handshakeResponse.isLimeWire()) {
                            if (handshakeResponse.isUltrapeer()) {
                                HandshakingStat.OUTGOING_LIMEWIRE_ULTRAPEER_REJECT.incrementStat();
                            } else {
                                HandshakingStat.OUTGOING_LIMEWIRE_LEAF_REJECT.incrementStat();
                            }
                        } else if (handshakeResponse.isUltrapeer()) {
                            HandshakingStat.OUTGOING_OTHER_ULTRAPEER_REJECT.incrementStat();
                        } else {
                            HandshakingStat.OUTGOING_OTHER_LEAF_REJECT.incrementStat();
                        }
                    }
                    throw NoGnutellaOkException.SERVER_REJECT;
                }
                if (CommonUtils.recordStats()) {
                    HandshakingStat.OUTGOING_SERVER_UNKNOWN.incrementStat();
                }
                throw NoGnutellaOkException.createServerUnknown(n);
            }
            Assert.that(this.RESPONSE_HEADERS != null, "null RESPONSE_HEADERS");
            HandshakeResponse handshakeResponse2 = this.RESPONSE_HEADERS.respond(handshakeResponse, true);
            Assert.that(handshakeResponse2 != null, "null ourResponse");
            this.writeLine("GNUTELLA/0.6 " + handshakeResponse2.getStatusLine() + CRLF);
            this.sendHeaders(handshakeResponse2.props());
            n = handshakeResponse2.getStatusCode();
            if (n == 200) {
                if (!"OK".equals(handshakeResponse2.getStatusMessage())) continue;
                if (CommonUtils.recordStats()) {
                    HandshakingStat.SUCCESSFUL_OUTGOING.incrementStat();
                }
                return;
            }
            if (n == 503) {
                if (CommonUtils.recordStats()) {
                    HandshakingStat.OUTGOING_CLIENT_REJECT.incrementStat();
                }
                throw NoGnutellaOkException.CLIENT_REJECT;
            }
            if (n == 577) {
                throw NoGnutellaOkException.CLIENT_REJECT_LOCALE;
            }
            if (CommonUtils.recordStats()) {
                HandshakingStat.OUTGOING_CLIENT_UNKNOWN.incrementStat();
            }
            throw NoGnutellaOkException.createClientUnknown(n);
        }
        throw NoGnutellaOkException.UNRESOLVED_SERVER;
    }

    private void initializeIncoming() throws IOException {
        String string = this.readLine();
        if (!Connection.notLessThan06(string)) {
            throw new IOException("Unexpected connect string: " + string);
        }
        this.readHeaders();
        this.concludeIncomingHandshake();
    }

    private void concludeIncomingHandshake() throws IOException {
        for (int i = 0; i < 5; ++i) {
            String string;
            boolean bl = this._headers.isCrawler();
            HandshakeResponse handshakeResponse = this.RESPONSE_HEADERS.respond(this._headers, false);
            this.writeLine("GNUTELLA/0.6 " + handshakeResponse.getStatusLine() + CRLF);
            this.sendHeaders(handshakeResponse.props());
            int n = handshakeResponse.getStatusCode();
            if (n != 200 && n != 401) {
                if (n == 503) {
                    if (CommonUtils.recordStats()) {
                        HandshakingStat.INCOMING_CLIENT_REJECT.incrementStat();
                    }
                    throw NoGnutellaOkException.CLIENT_REJECT;
                }
                if (CommonUtils.recordStats()) {
                    HandshakingStat.INCOMING_CLIENT_UNKNOWN.incrementStat();
                }
                throw NoGnutellaOkException.createClientUnknown(n);
            }
            if (handshakeResponse.getStatusCode() == 401) {
                string = this.readLine(120000);
                this.readHeaders(120000);
                this._headers = HandshakeResponse.createResponse(this.HEADERS_READ);
            } else {
                string = this.readLine();
                this.readHeaders();
            }
            if (!string.startsWith(GNUTELLA_06)) {
                if (CommonUtils.recordStats()) {
                    HandshakingStat.INCOMING_BAD_CONNECT.incrementStat();
                }
                throw new IOException("Bad connect string");
            }
            HandshakeResponse handshakeResponse2 = HandshakeResponse.createRemoteResponse(string.substring(GNUTELLA_06.length()).trim(), this.HEADERS_READ);
            n = handshakeResponse.getStatusCode();
            if (n == 200) {
                if (handshakeResponse2.getStatusCode() == 200) {
                    if (bl) {
                        if (CommonUtils.recordStats()) {
                            HandshakingStat.CRAWLER_CONNECTION.incrementStat();
                        }
                        throw new IOException("connection from crawler -- disconnect");
                    }
                    if (CommonUtils.recordStats()) {
                        HandshakingStat.SUCCESSFUL_INCOMING.incrementStat();
                    }
                    return;
                }
            } else {
                Assert.that(n == 401, "Response code: " + n);
                if (handshakeResponse2.getStatusCode() == 200) continue;
            }
            if (CommonUtils.recordStats()) {
                HandshakingStat.INCOMING_SERVER_UNKNOWN.incrementStat();
            }
            throw NoGnutellaOkException.createServerUnknown(handshakeResponse2.getStatusCode());
        }
        if (CommonUtils.recordStats()) {
            HandshakingStat.INCOMING_NO_CONCLUSION.incrementStat();
        }
        throw NoGnutellaOkException.UNRESOLVED_CLIENT;
    }

    private static boolean notLessThan06(String string) {
        int n = string.indexOf(CONNECT);
        if (n < 0) {
            return false;
        }
        try {
            Float f = new Float(string.substring(n + CONNECT.length()));
            float f2 = f.floatValue();
            return f2 >= 0.6f;
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
    }

    private void sendHeaders(Properties properties) throws IOException {
        if (properties != null) {
            Enumeration<?> enumeration = properties.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                String string2 = properties.getProperty(string);
                if ("Remote-IP".equals(string)) {
                    string2 = this.getInetAddress().getHostAddress();
                }
                if (string2 == null) {
                    string2 = "";
                }
                this.writeLine(string + ": " + string2 + CRLF);
                ((Hashtable)this.HEADERS_WRITTEN).put(string, string2);
            }
        }
        this.writeLine(CRLF);
    }

    private void readHeaders() throws IOException {
        this.readHeaders(8000);
        this._headers = HandshakeResponse.createResponse(this.HEADERS_READ);
    }

    private void readHeaders(int n) throws IOException {
        while (true) {
            String string;
            if ((string = this.readLine(n)) == null) {
                throw new IOException("unexpected end of file");
            }
            if (string.equals("")) {
                return;
            }
            int n2 = string.indexOf(58);
            if (n2 < 0) continue;
            String string2 = string.substring(0, n2);
            String string3 = string.substring(n2 + 1).trim();
            if ("Remote-IP".equals(string2)) {
                this.changeAddress(string3);
            }
            ((Hashtable)this.HEADERS_READ).put(string2, string3);
        }
    }

    private void changeAddress(String string) {
        InetAddress inetAddress = null;
        try {
            inetAddress = InetAddress.getByName(string);
        }
        catch (UnknownHostException unknownHostException) {
            return;
        }
        if (!NetworkUtils.isValidAddress(inetAddress) || NetworkUtils.isPrivateAddress(inetAddress)) {
            return;
        }
        if (ConnectionSettings.FORCE_IP_ADDRESS.getValue()) {
            StringSetting stringSetting = ConnectionSettings.FORCED_IP_ADDRESS_STRING;
            if (!string.equals(stringSetting.getValue())) {
                stringSetting.setValue(string);
                RouterService.addressChanged();
            }
        } else if (!NetworkUtils.isValidAddress(RouterService.getAddress())) {
            RouterService.getAcceptor().setAddress(inetAddress);
        }
        RouterService.getAcceptor().setExternalAddress(inetAddress);
    }

    private void writeLine(String string) throws IOException {
        if (string == null || string.equals("")) {
            throw new NullPointerException("null or empty string: " + string);
        }
        byte[] byArray = string.getBytes();
        if (!CommonUtils.isJava118()) {
            BandwidthStat.GNUTELLA_HEADER_UPSTREAM_BANDWIDTH.addData(byArray.length);
        }
        this._out.write(byArray);
        this._out.flush();
    }

    private String readLine() throws IOException {
        return this.readLine(8000);
    }

    private String readLine(int n) throws IOException {
        int n2 = this._socket.getSoTimeout();
        try {
            this._socket.setSoTimeout(n);
            String string = new ByteReader(this._in).readLine();
            if (string == null) {
                throw new IOException("read null line");
            }
            if (!CommonUtils.isJava118()) {
                BandwidthStat.GNUTELLA_HEADER_DOWNSTREAM_BANDWIDTH.addData(string.length());
            }
            String string2 = string;
            return string2;
        }
        catch (NullPointerException nullPointerException) {
            throw CONNECTION_CLOSED;
        }
        finally {
            this._socket.setSoTimeout(n2);
        }
    }

    protected OutputStream getOutputStream() throws IOException {
        return new BufferedOutputStream(this._socket.getOutputStream());
    }

    protected InputStream getInputStream() throws IOException {
        return new BufferedInputStream(this._socket.getInputStream());
    }

    public boolean isOutgoing() {
        return this.OUTGOING;
    }

    protected Message receive() throws IOException, BadPacketException {
        if (this._closed) {
            throw CONNECTION_CLOSED;
        }
        Message message = null;
        while (message == null) {
            message = this.readAndUpdateStatistics();
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Message receive(int n) throws IOException, BadPacketException, InterruptedIOException {
        if (this._closed) {
            throw CONNECTION_CLOSED;
        }
        int n2 = this._socket.getSoTimeout();
        this._socket.setSoTimeout(n);
        try {
            Message message = this.readAndUpdateStatistics();
            if (message == null) {
                throw new InterruptedIOException("null message read");
            }
            Message message2 = message;
            return message2;
        }
        finally {
            this._socket.setSoTimeout(n2);
        }
    }

    private Message readAndUpdateStatistics() throws IOException, BadPacketException {
        int n = 0;
        int n2 = 0;
        Message message = null;
        try {
            if (this.isReadDeflated()) {
                n = this._inflater.getTotalIn();
                n2 = this._inflater.getTotalOut();
            }
            message = Message.read(this._in, this.HEADER_BUF, 1, this._softMax);
            if (LOG.isTraceEnabled()) {
                LOG.trace((Object)("Connection (" + this.toString() + ") read message: " + message));
            }
            if (this.isReadDeflated()) {
                this._compressedBytesReceived = this._inflater.getTotalIn();
                this._bytesReceived = this._inflater.getTotalOut();
                if (!CommonUtils.isJava118()) {
                    CompressionStat.GNUTELLA_UNCOMPRESSED_DOWNSTREAM.addData(this._inflater.getTotalOut() - n2);
                    CompressionStat.GNUTELLA_COMPRESSED_DOWNSTREAM.addData(this._inflater.getTotalIn() - n);
                }
            } else if (message != null) {
                this._bytesReceived += (long)message.getTotalLength();
            }
        }
        catch (NullPointerException nullPointerException) {
            LOG.warn((Object)"Caught NPE in readAndUpdateStatistics, throwing IO.");
            throw CONNECTION_CLOSED;
        }
        return message;
    }

    public void send(Message message) throws IOException {
        if (LOG.isTraceEnabled()) {
            LOG.trace((Object)("Connection (" + this.toString() + ") is sending message: " + message));
        }
        long l = 0L;
        long l2 = 0L;
        try {
            if (this.isWriteDeflated()) {
                l2 = this._deflater.getTotalIn();
                l = this._deflater.getTotalOut();
            }
            message.write(this._out);
            this.updateWriteStatistics(message, l2, l);
        }
        catch (NullPointerException nullPointerException) {
            throw CONNECTION_CLOSED;
        }
    }

    public void flush() throws IOException {
        long l = 0L;
        long l2 = 0L;
        try {
            if (this.isWriteDeflated()) {
                l2 = this._deflater.getTotalIn();
                l = this._deflater.getTotalOut();
            }
            this._out.flush();
            this.updateWriteStatistics(null, l2, l);
        }
        catch (NullPointerException nullPointerException) {
            throw CONNECTION_CLOSED;
        }
    }

    private void updateWriteStatistics(Message message, long l, long l2) {
        if (message != null) {
            this._bytesSent += (long)message.getTotalLength();
        }
        if (this.isWriteDeflated()) {
            this._compressedBytesSent = this._deflater.getTotalOut();
            if (!CommonUtils.isJava118()) {
                CompressionStat.GNUTELLA_UNCOMPRESSED_UPSTREAM.addData((int)((long)this._deflater.getTotalIn() - l));
                CompressionStat.GNUTELLA_COMPRESSED_UPSTREAM.addData((int)((long)this._deflater.getTotalOut() - l2));
            }
        }
    }

    public long getBytesSent() {
        if (this.isWriteDeflated()) {
            return this._compressedBytesSent;
        }
        return this._bytesSent;
    }

    public long getUncompressedBytesSent() {
        return this._bytesSent;
    }

    public long getBytesReceived() {
        if (this.isReadDeflated()) {
            return this._compressedBytesReceived;
        }
        return this._bytesReceived;
    }

    public long getUncompressedBytesReceived() {
        return this._bytesReceived;
    }

    public float getSentSavedFromCompression() {
        if (!this.isWriteDeflated() || this._bytesSent == 0L) {
            return 0.0f;
        }
        return 1.0f - (float)this._compressedBytesSent / (float)this._bytesSent;
    }

    public float getReadSavedFromCompression() {
        if (!this.isReadDeflated() || this._bytesReceived == 0L) {
            return 0.0f;
        }
        return 1.0f - (float)this._compressedBytesReceived / (float)this._bytesReceived;
    }

    public String getAddress() {
        return this._host;
    }

    public int getPort() {
        return this._port;
    }

    void setListeningPort(int n) {
        if (!NetworkUtils.isValidPort(n)) {
            throw new IllegalArgumentException("invalid port: " + n);
        }
        this._port = n;
    }

    public InetAddress getInetAddress() throws IllegalStateException {
        if (this._socket == null) {
            throw new IllegalStateException("Not initialized");
        }
        return this._socket.getInetAddress();
    }

    public Socket getSocket() throws IllegalStateException {
        if (this._socket == null) {
            throw new IllegalStateException("Not initialized");
        }
        return this._socket;
    }

    public boolean isConnectBackCapable() throws IllegalStateException {
        byte[] byArray = this.getInetAddress().getAddress();
        byte[] byArray2 = this._socket.getLocalAddress().getAddress();
        return !NetworkUtils.isCloseIP(byArray2, byArray);
    }

    public long getConnectionTime() {
        return this._connectionTime;
    }

    public byte getSoftMax() {
        return this._softMax;
    }

    public boolean isStable() {
        return this.isStable(System.currentTimeMillis());
    }

    public boolean isStable(long l) {
        return (l - this.getConnectionTime()) / 1000L > 5L;
    }

    public int supportsVendorMessage(byte[] byArray, int n) {
        if (this._messagesSupported != null) {
            return this._messagesSupported.supportsMessage(byArray, n);
        }
        return -1;
    }

    public int remoteHostSupportsUDPConnectBack() {
        if (this._messagesSupported != null) {
            return this._messagesSupported.supportsUDPConnectBack();
        }
        return -1;
    }

    public int remoteHostSupportsTCPConnectBack() {
        if (this._messagesSupported != null) {
            return this._messagesSupported.supportsTCPConnectBack();
        }
        return -1;
    }

    public int remoteHostSupportsUDPRedirect() {
        if (this._messagesSupported != null) {
            return this._messagesSupported.supportsUDPConnectBackRedirect();
        }
        return -1;
    }

    public int remoteHostSupportsTCPRedirect() {
        if (this._messagesSupported != null) {
            return this._messagesSupported.supportsTCPConnectBackRedirect();
        }
        return -1;
    }

    public int remoteHostSupportsUDPCrawling() {
        if (this._messagesSupported != null) {
            return this._messagesSupported.supportsUDPCrawling();
        }
        return -1;
    }

    public int remoteHostSupportsHopsFlow() {
        if (this._messagesSupported != null) {
            return this._messagesSupported.supportsHopsFlow();
        }
        return -1;
    }

    public int remoteHostSupportsPushProxy() {
        if (this._messagesSupported != null && this.isClientSupernodeConnection()) {
            return this._messagesSupported.supportsPushProxy();
        }
        return -1;
    }

    public int remoteHostSupportsLeafGuidance() {
        if (this._messagesSupported != null) {
            return this._messagesSupported.supportsLeafGuidance();
        }
        return -1;
    }

    public int getRemoteHostCapabilitySelector() {
        if (this._capabilities != null) {
            return this._capabilities.supportsCapabilityQueries();
        }
        return -1;
    }

    public boolean remoteHostSupportsWhatIsNew() {
        if (this._capabilities != null) {
            return this._capabilities.supportsWhatIsNew();
        }
        return false;
    }

    protected boolean isLocal() {
        return NetworkUtils.isLocalAddress(this._socket.getInetAddress());
    }

    public String getPropertyWritten(String string) {
        return this.HEADERS_WRITTEN.getProperty(string);
    }

    public boolean isOpen() {
        return !this._closed;
    }

    public void close() {
        if (this._closed) {
            return;
        }
        this._closed = true;
        if (this._socket != null) {
            try {
                this._socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this._deflater != null) {
            this._deflater.end();
        }
        if (this._inflater != null) {
            this._inflater.end();
        }
        if (this._in != null) {
            try {
                this._in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this._out != null) {
            try {
                this._out.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public String getUserAgent() {
        return this._headers.getUserAgent();
    }

    public boolean isLimeWire() {
        return this._headers.isLimeWire();
    }

    public boolean isOldLimeWire() {
        return this._headers.isOldLimeWire();
    }

    public boolean isWriteDeflated() {
        return this._headersWritten.isDeflateEnabled();
    }

    public boolean isReadDeflated() {
        return this._headers.isDeflateEnabled();
    }

    public boolean isGoodUltrapeer() {
        return this._headers.isGoodUltrapeer();
    }

    public boolean isGoodLeaf() {
        return this._headers.isGoodLeaf();
    }

    public boolean supportsPongCaching() {
        return this._headers.supportsPongCaching();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean allowNewPings() {
        Object object = this.PING_LOCK;
        synchronized (object) {
            long l = System.currentTimeMillis();
            if (!this.isStable(l)) {
                return false;
            }
            if (l < this._nextPingTime) {
                return false;
            }
            this._nextPingTime = System.currentTimeMillis() + 2500L;
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean allowNewPongs() {
        Object object = this.PONG_LOCK;
        synchronized (object) {
            long l = System.currentTimeMillis();
            if (!this.isStable(l)) {
                return false;
            }
            if (l < this._nextPongTime) {
                return false;
            }
            int n = l - this.getConnectionTime() < 10000L ? 300 : 12000;
            this._nextPongTime = l + (long)n;
            return true;
        }
    }

    public int getNumIntraUltrapeerConnections() {
        return this._headers.getNumIntraUltrapeerConnections();
    }

    public boolean isHighDegreeConnection() {
        return this._headers.isHighDegreeConnection();
    }

    public boolean isUltrapeerQueryRoutingConnection() {
        return this._headers.isUltrapeerQueryRoutingConnection();
    }

    public boolean supportsProbeQueries() {
        return this._headers.supportsProbeQueries();
    }

    public String getDomainsAuthenticated() {
        return this._headers.getDomainsAuthenticated();
    }

    public boolean receivedHeaders() {
        return this._headers != null;
    }

    public HandshakeResponse headers() {
        return this._headers;
    }

    public boolean isLeafConnection() {
        return this._headers.isLeaf();
    }

    public boolean isSupernodeConnection() {
        return this._headers.isUltrapeer();
    }

    public boolean isClientSupernodeConnection() {
        if (!this.isSupernodeConnection()) {
            return false;
        }
        String string = this.getPropertyWritten("X-Ultrapeer");
        if (string == null) {
            return false;
        }
        return Boolean.valueOf(string) == false;
    }

    public boolean isSupernodeSupernodeConnection() {
        if (!this.isSupernodeConnection()) {
            return false;
        }
        String string = this.getPropertyWritten("X-Ultrapeer");
        if (string == null) {
            return false;
        }
        return Boolean.valueOf(string);
    }

    public boolean isGUESSCapable() {
        return this._headers.isGUESSCapable();
    }

    public boolean isGUESSUltrapeer() {
        return this._headers.isGUESSUltrapeer();
    }

    public boolean isTempConnection() {
        return this._headers.isTempConnection();
    }

    public boolean isSupernodeClientConnection() {
        if (!this.isLeafConnection()) {
            return false;
        }
        String string = this.getPropertyWritten("X-Ultrapeer");
        if (string == null) {
            return false;
        }
        if (!Boolean.valueOf(string).booleanValue()) {
            return false;
        }
        return this.isQueryRoutingEnabled();
    }

    public boolean supportsGGEP() {
        return this._headers.supportsGGEP();
    }

    public void handleStatisticVM(StatisticVendorMessage statisticVendorMessage) throws IOException {
        this.send(statisticVendorMessage);
    }

    boolean isQueryRoutingEnabled() {
        return this._headers.isQueryRoutingEnabled();
    }

    public String toString() {
        return "CONNECTION: host=" + this._host + " port=" + this._port;
    }

    public String getLocalePref() {
        return this._headers.getLocalePref();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

