/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella;

import com.limegroup.gnutella.ConnectionManager;
import com.limegroup.gnutella.DownloadManager;
import com.limegroup.gnutella.ErrorService;
import com.limegroup.gnutella.MessageService;
import com.limegroup.gnutella.MulticastService;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.UDPService;
import com.limegroup.gnutella.UploadManager;
import com.limegroup.gnutella.filters.IPFilter;
import com.limegroup.gnutella.http.HTTPRequestMethod;
import com.limegroup.gnutella.settings.ConnectionSettings;
import com.limegroup.gnutella.settings.SettingsHandler;
import com.limegroup.gnutella.statistics.HTTPStat;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.util.IOUtils;
import com.limegroup.gnutella.util.ManagedThread;
import com.limegroup.gnutella.util.NetworkUtils;
import com.limegroup.gnutella.util.Random12;
import com.sun.java.util.collections.Arrays;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.MulticastSocket;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Acceptor
implements Runnable {
    private static final Log LOG = LogFactory.getLog((Class)(class$com$limegroup$gnutella$Acceptor == null ? (class$com$limegroup$gnutella$Acceptor = Acceptor.class$("com.limegroup.gnutella.Acceptor")) : class$com$limegroup$gnutella$Acceptor));
    static long INCOMING_EXPIRE_TIME = 540000000L;
    static long WAIT_TIME_AFTER_REQUESTS = 30000L;
    static long TIME_BETWEEN_VALIDATES = 2400000L;
    private volatile ServerSocket _socket = null;
    private volatile int _port = 6346;
    private final Object SOCKET_LOCK = new Object();
    private static byte[] _address = new byte[4];
    private static byte[] _externalAddress = new byte[4];
    private volatile boolean _acceptedIncoming = false;
    private volatile long _lastIncomingTime = 0L;
    private volatile long _lastConnectBackTime = System.currentTimeMillis();
    private static final boolean RECORD_STATS = !CommonUtils.isJava118();
    static /* synthetic */ Class class$com$limegroup$gnutella$Acceptor;

    void resetLastConnectBackTime() {
        this._lastConnectBackTime = System.currentTimeMillis() - INCOMING_EXPIRE_TIME;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAddress(InetAddress inetAddress) {
        byte[] byArray = inetAddress.getAddress();
        if (!NetworkUtils.isValidAddress(byArray)) {
            return;
        }
        if (byArray[0] == 127 && ConnectionSettings.LOCAL_IS_PRIVATE.getValue()) {
            return;
        }
        boolean bl = false;
        Class clazz = class$com$limegroup$gnutella$Acceptor == null ? (class$com$limegroup$gnutella$Acceptor = Acceptor.class$("com.limegroup.gnutella.Acceptor")) : class$com$limegroup$gnutella$Acceptor;
        synchronized (clazz) {
            if (!Arrays.equals((byte[])_address, (byte[])byArray)) {
                _address = byArray;
                bl = true;
            }
        }
        if (bl) {
            RouterService.addressChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setExternalAddress(InetAddress inetAddress) {
        byte[] byArray = inetAddress.getAddress();
        if (byArray[0] == 127 && ConnectionSettings.LOCAL_IS_PRIVATE.getValue()) {
            return;
        }
        Class clazz = class$com$limegroup$gnutella$Acceptor == null ? (class$com$limegroup$gnutella$Acceptor = Acceptor.class$("com.limegroup.gnutella.Acceptor")) : class$com$limegroup$gnutella$Acceptor;
        synchronized (clazz) {
            _externalAddress = byArray;
        }
    }

    public void start() {
        MulticastService.instance().start();
        UDPService.instance().start();
        ManagedThread managedThread = new ManagedThread(this, "Acceptor");
        managedThread.setDaemon(true);
        managedThread.start();
        RouterService.schedule(new IncomingValidator(), TIME_BETWEEN_VALIDATES, TIME_BETWEEN_VALIDATES);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAddressExternal() {
        if (!ConnectionSettings.LOCAL_IS_PRIVATE.getValue()) {
            return true;
        }
        Class clazz = class$com$limegroup$gnutella$Acceptor == null ? (class$com$limegroup$gnutella$Acceptor = Acceptor.class$("com.limegroup.gnutella.Acceptor")) : class$com$limegroup$gnutella$Acceptor;
        synchronized (clazz) {
            return Arrays.equals((byte[])this.getAddress(true), (byte[])_externalAddress);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getExternalAddress() {
        Class clazz = class$com$limegroup$gnutella$Acceptor == null ? (class$com$limegroup$gnutella$Acceptor = Acceptor.class$("com.limegroup.gnutella.Acceptor")) : class$com$limegroup$gnutella$Acceptor;
        synchronized (clazz) {
            return _externalAddress;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getAddress(boolean bl) {
        Object object;
        if (bl && ConnectionSettings.FORCE_IP_ADDRESS.getValue()) {
            object = ConnectionSettings.FORCED_IP_ADDRESS_STRING.getValue();
            try {
                InetAddress inetAddress = InetAddress.getByName((String)object);
                return inetAddress.getAddress();
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
        }
        object = class$com$limegroup$gnutella$Acceptor == null ? (class$com$limegroup$gnutella$Acceptor = Acceptor.class$("com.limegroup.gnutella.Acceptor")) : class$com$limegroup$gnutella$Acceptor;
        synchronized (object) {
            return _address;
        }
    }

    public int getPort(boolean bl) {
        if (bl && ConnectionSettings.FORCE_IP_ADDRESS.getValue()) {
            return ConnectionSettings.FORCED_PORT.getValue();
        }
        return this._port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setListeningPort(int n) throws IOException {
        Object object;
        LOG.trace((Object)"Acceptor.setListeningPort(): entered.");
        if (this._socket != null && this._port == n) {
            return;
        }
        if (n == 0) {
            LOG.trace((Object)"Acceptor.setListeningPort(): shutting off service.");
            if (this._socket != null) {
                try {
                    this._socket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            Object object2 = this.SOCKET_LOCK;
            synchronized (object2) {
                this._socket = null;
                this._port = 0;
                this.SOCKET_LOCK.notify();
            }
            UDPService.instance().setListeningSocket(null);
            MulticastService.instance().setListeningSocket(null);
            LOG.trace((Object)"Acceptor.setListeningPort(): service OFF.");
            return;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Acceptor.setListeningPort(): changing port to " + n));
        }
        DatagramSocket datagramSocket = UDPService.instance().newListeningSocket(n);
        LOG.trace((Object)"Acceptor.setListeningPort(): UDP Service is ready.");
        MulticastSocket multicastSocket = null;
        try {
            object = InetAddress.getByName(ConnectionSettings.MULTICAST_ADDRESS.getValue());
            multicastSocket = MulticastService.instance().newListeningSocket(ConnectionSettings.MULTICAST_PORT.getValue(), (InetAddress)object);
            LOG.trace((Object)"Acceptor.setListeningPort(): Multicast Service is ready.");
        }
        catch (IOException iOException) {
            multicastSocket = null;
            LOG.debug((Object)"Acceptor.setListeningPort(): Unable to start multicast service.", (Throwable)iOException);
        }
        object = null;
        try {
            object = new ServerSocket(n);
        }
        catch (IOException iOException) {
            datagramSocket.close();
            throw iOException;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            datagramSocket.close();
            throw new IOException("could not create a listening socket");
        }
        if (this._socket != null) {
            try {
                this._socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        Object object3 = this.SOCKET_LOCK;
        synchronized (object3) {
            this._socket = object;
            this._port = n;
            this.SOCKET_LOCK.notify();
        }
        LOG.trace((Object)"Acceptor.setListeningPort(): I am ready.");
        UDPService.instance().setListeningSocket(datagramSocket);
        if (multicastSocket != null) {
            MulticastService.instance().setListeningSocket(multicastSocket);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Acceptor.setListeningPort(): listening UDP/TCP on " + this._port));
        }
    }

    public boolean acceptedIncoming() {
        return this._acceptedIncoming;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Serializable serializable;
        IOException iOException;
        int n;
        block32: {
            int n2 = ConnectionSettings.PORT.getValue();
            try {
                this.setAddress(InetAddress.getLocalHost());
            }
            catch (UnknownHostException unknownHostException) {
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
            n = n2;
            iOException = null;
            try {
                this.setListeningPort(n2);
                this._port = n2;
            }
            catch (IOException iOException2) {
                iOException = iOException2;
                int n3 = 20;
                serializable = null;
                for (int i = 0; i < n3; ++i) {
                    if (i < 10) {
                        n2 = i + 6346;
                    } else {
                        if (serializable == null) {
                            serializable = new Random12();
                        }
                        n2 = serializable.nextInt(50000);
                        n2 += 2000;
                    }
                    if (n2 == ConnectionSettings.MULTICAST_PORT.getValue()) {
                        ++n3;
                        continue;
                    }
                    try {
                        this.setListeningPort(n2);
                        this._port = n2;
                        break;
                    }
                    catch (IOException iOException3) {
                        iOException = iOException3;
                    }
                }
                if (this._socket != null) break block32;
                MessageService.showError("ERROR_NO_PORTS_AVAILABLE");
            }
        }
        iOException = null;
        if (this._port != n) {
            ConnectionSettings.PORT.setValue(this._port);
            SettingsHandler.save();
            RouterService.addressChanged();
        }
        while (true) {
            try {
                while (true) {
                    Socket socket = null;
                    Object object = this.SOCKET_LOCK;
                    synchronized (object) {
                        if (this._socket != null) {
                            try {
                                socket = this._socket.accept();
                            }
                            catch (IOException iOException4) {
                                continue;
                            }
                        }
                        try {
                            this.SOCKET_LOCK.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        continue;
                    }
                    object = socket.getInetAddress();
                    if (this.isBannedIP(((InetAddress)object).getHostAddress())) {
                        if (RECORD_STATS) {
                            HTTPStat.BANNED_REQUESTS.incrementStat();
                        }
                        socket.close();
                        continue;
                    }
                    serializable = socket.getLocalAddress();
                    this.setAddress((InetAddress)serializable);
                    if (this.isOutsideConnection((InetAddress)object)) {
                        Class clazz = class$com$limegroup$gnutella$Acceptor == null ? Acceptor.class$("com.limegroup.gnutella.Acceptor") : class$com$limegroup$gnutella$Acceptor;
                        synchronized (clazz) {
                            this._acceptedIncoming = true;
                            ConnectionSettings.EVER_ACCEPTED_INCOMING.setValue(this._acceptedIncoming);
                            this._lastIncomingTime = System.currentTimeMillis();
                        }
                    }
                    ConnectionDispatchRunner connectionDispatchRunner = new ConnectionDispatchRunner(socket);
                    ManagedThread managedThread = new ManagedThread(connectionDispatchRunner, "ConnectionDispatchRunner");
                    managedThread.setDaemon(true);
                    managedThread.start();
                }
            }
            catch (SecurityException securityException) {
                ErrorService.error(securityException);
                continue;
            }
            catch (Throwable throwable) {
                ErrorService.error(throwable);
                continue;
            }
            break;
        }
    }

    private boolean isOutsideConnection(InetAddress inetAddress) {
        if (!ConnectionSettings.LOCAL_IS_PRIVATE.getValue()) {
            return true;
        }
        String string = inetAddress.getHostAddress();
        byte[] byArray = inetAddress.getAddress();
        return !RouterService.getConnectionManager().isConnectedTo(string) && !NetworkUtils.isCloseIP(byArray, this.getAddress(false)) && !NetworkUtils.isLocalAddress(inetAddress);
    }

    public boolean isBannedIP(String string) {
        return !IPFilter.instance().allow(string);
    }

    public boolean isBannedIP(byte[] byArray) {
        return !IPFilter.instance().allow(byArray);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class IncomingValidator
    implements Runnable {
        public void run() {
            final long l = System.currentTimeMillis();
            ConnectionManager connectionManager = RouterService.getConnectionManager();
            if ((Acceptor.this._acceptedIncoming && l - Acceptor.this._lastIncomingTime > INCOMING_EXPIRE_TIME || !Acceptor.this._acceptedIncoming && l - Acceptor.this._lastConnectBackTime > INCOMING_EXPIRE_TIME) && connectionManager.sendTCPConnectBackRequests()) {
                Acceptor.this._lastConnectBackTime = System.currentTimeMillis();
                Runnable runnable = new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run() {
                        Class clazz = class$com$limegroup$gnutella$Acceptor == null ? (class$com$limegroup$gnutella$Acceptor = Acceptor.class$("com.limegroup.gnutella.Acceptor")) : class$com$limegroup$gnutella$Acceptor;
                        synchronized (clazz) {
                            if (Acceptor.this._lastIncomingTime < l) {
                                Acceptor.this._acceptedIncoming = false;
                            }
                        }
                    }
                };
                RouterService.schedule(runnable, WAIT_TIME_AFTER_REQUESTS, 0L);
            }
        }
    }

    private static class ConnectionDispatchRunner
    implements Runnable {
        private final Socket _socket;

        public ConnectionDispatchRunner(Socket socket) {
            this._socket = socket;
        }

        public void run() {
            block22: {
                ConnectionManager connectionManager = RouterService.getConnectionManager();
                UploadManager uploadManager = RouterService.getUploadManager();
                DownloadManager downloadManager = RouterService.getDownloadManager();
                try {
                    InputStream inputStream = null;
                    try {
                        inputStream = this._socket.getInputStream();
                    }
                    catch (IOException iOException) {
                        if (RECORD_STATS) {
                            HTTPStat.CLOSED_REQUESTS.incrementStat();
                        }
                        throw new IOException(iOException.getMessage());
                    }
                    catch (NullPointerException nullPointerException) {
                        throw new IOException(((Throwable)nullPointerException).getMessage());
                    }
                    this._socket.setSoTimeout(8000);
                    String string = IOUtils.readWord(inputStream, 8);
                    this._socket.setSoTimeout(0);
                    if (!string.equals("MAGNET")) {
                        InetAddress inetAddress = this._socket.getInetAddress();
                        byte[] byArray = inetAddress.getAddress();
                        if (ConnectionSettings.LOCAL_IS_PRIVATE.getValue() && byArray[0] == 127) {
                            this._socket.close();
                            return;
                        }
                    }
                    boolean bl = ConnectionSettings.CONNECT_STRING.isDefault();
                    if (string.equals("GNUTELLA")) {
                        if (RECORD_STATS) {
                            HTTPStat.GNUTELLA_REQUESTS.incrementStat();
                        }
                        connectionManager.acceptConnection(this._socket);
                        break block22;
                    }
                    if (bl && string.equals("LIMEWIRE")) {
                        if (RECORD_STATS) {
                            HTTPStat.GNUTELLA_LIMEWIRE_REQUESTS.incrementStat();
                        }
                        connectionManager.acceptConnection(this._socket);
                        break block22;
                    }
                    if (string.equals("GET")) {
                        if (RECORD_STATS) {
                            HTTPStat.GET_REQUESTS.incrementStat();
                        }
                        uploadManager.acceptUpload(HTTPRequestMethod.GET, this._socket, false);
                        break block22;
                    }
                    if (string.equals("HEAD")) {
                        if (RECORD_STATS) {
                            HTTPStat.HEAD_REQUESTS.incrementStat();
                        }
                        uploadManager.acceptUpload(HTTPRequestMethod.HEAD, this._socket, false);
                        break block22;
                    }
                    if (string.equals("GIV")) {
                        if (RECORD_STATS) {
                            HTTPStat.GIV_REQUESTS.incrementStat();
                        }
                        downloadManager.acceptDownload(this._socket);
                        break block22;
                    }
                    if (RECORD_STATS) {
                        HTTPStat.UNKNOWN_REQUESTS.incrementStat();
                    }
                    throw new IOException("UNKOWN PROTOCOL: " + string);
                }
                catch (IOException iOException) {
                    try {
                        this._socket.close();
                    }
                    catch (IOException iOException2) {}
                }
                catch (Throwable throwable) {
                    ErrorService.error(throwable);
                }
            }
        }
    }
}

