/*
 * Decompiled with CFR 0.152.
 */
package org.logi.crypto.protocols;

import java.math.BigInteger;
import org.logi.crypto.Crypto;
import org.logi.crypto.keys.DHKey;
import org.logi.crypto.keys.Key;
import org.logi.crypto.keys.KeyException;

public class DHKeyEx
extends Crypto {
    int modSize;
    String keyType;
    protected BigInteger m;
    protected BigInteger g;
    protected BigInteger myPrivate;
    protected BigInteger myPublic;
    protected BigInteger hisPublic;
    protected boolean keyDecided = false;
    protected Key sessionKey;

    public Key sessionKey() {
        return this.keyDecided ? this.sessionKey : null;
    }

    public boolean completed() {
        return this.keyDecided;
    }

    public int maxMessageSize() {
        return 65536;
    }

    protected DHKeyEx(DHKey dHKey, String string) throws KeyException {
        if (!dHKey.isPrivate()) {
            throw new KeyException("Expecting a private key.");
        }
        this.m = dHKey.getM();
        this.g = dHKey.getG();
        this.myPrivate = dHKey.getKey();
        this.myPublic = this.g.modPow(this.myPrivate, this.m);
        this.modSize = this.m.bitLength();
        this.keyType = string;
    }

    protected DHKeyEx(int n, String string) {
        this.m = DHKey.getModulus(n);
        this.g = DHKey.getGenerator(this.m);
        this.modSize = this.m.bitLength();
        do {
            this.myPrivate = new BigInteger(this.modSize, random);
        } while (this.myPrivate.compareTo(this.m) > 0);
        this.myPublic = this.g.modPow(this.myPrivate, this.m);
        this.keyType = string;
    }
}

