/*
 * Decompiled with CFR 0.152.
 */
package org.logi.crypto.keys;

import java.io.IOException;
import java.io.StreamTokenizer;
import java.io.StringReader;
import java.math.BigInteger;
import org.logi.crypto.Crypto;
import org.logi.crypto.InvalidCDSException;
import org.logi.crypto.hash.Fingerprint;
import org.logi.crypto.hash.HashState;
import org.logi.crypto.keys.CipherKey;
import org.logi.crypto.keys.K;
import org.logi.crypto.keys.Key;
import org.logi.crypto.keys.KeyException;
import org.logi.crypto.keys.KeyPair;
import org.logi.crypto.keys.RSAKeyChin;
import org.logi.crypto.keys.SignatureKey;
import org.logi.crypto.sign.Signature;

public class RSAKey
extends K
implements CipherKey,
SignatureKey {
    protected static final BigInteger R = BigInteger.valueOf(65537L);
    protected BigInteger r;
    protected BigInteger n;
    protected boolean pri;
    protected Fingerprint matchPrint = null;

    public static RSAKey parseCDS(String string) throws InvalidCDSException {
        RSAKey rSAKey = null;
        try {
            Object object;
            StreamTokenizer streamTokenizer = new StreamTokenizer(new StringReader(string));
            streamTokenizer.ordinaryChars(48, 57);
            streamTokenizer.wordChars(48, 57);
            if (streamTokenizer.nextToken() != -3) {
                throw new InvalidCDSException("Hexadecimal string expected as first argument to RSAKey()");
            }
            BigInteger bigInteger = new BigInteger(streamTokenizer.sval, 16);
            if (streamTokenizer.nextToken() != 44) {
                throw new InvalidCDSException(", expected after " + bigInteger.toString(16));
            }
            if (streamTokenizer.nextToken() != -3) {
                throw new InvalidCDSException("Hexadecimal string expected as second argument to RSAKey()");
            }
            BigInteger bigInteger2 = new BigInteger(streamTokenizer.sval, 16);
            if (streamTokenizer.nextToken() != 44) {
                throw new InvalidCDSException(", expected after " + bigInteger2.toString(16));
            }
            if (streamTokenizer.nextToken() != -3) {
                throw new InvalidCDSException("modulus factor, \"pub\" or \"pri\" expected as third argument to RSAKey()");
            }
            if (streamTokenizer.sval.equals("pri")) {
                rSAKey = new RSAKey(bigInteger, bigInteger2, true);
            } else if (streamTokenizer.sval.equals("pub")) {
                rSAKey = new RSAKey(bigInteger, bigInteger2, false);
            } else {
                try {
                    object = new BigInteger(streamTokenizer.sval, 16);
                    rSAKey = new RSAKeyChin(bigInteger, bigInteger2, (BigInteger)object, true);
                }
                catch (Exception exception) {
                    throw new InvalidCDSException(exception.getMessage());
                }
            }
            object = streamTokenizer.sval;
            if (streamTokenizer.nextToken() != -1) {
                System.out.println(streamTokenizer.ttype);
                throw new InvalidCDSException("no more parameters expected in RSAKey after " + (String)object);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return rSAKey;
    }

    public static BigInteger findPrime(BigInteger bigInteger) {
        BigInteger bigInteger2 = bigInteger;
        if (!bigInteger.testBit(0)) {
            bigInteger2 = bigInteger2.subtract(ONE);
        }
        while (!bigInteger2.isProbablePrime(primeCertainty)) {
            bigInteger2 = bigInteger2.subtract(TWO);
        }
        return bigInteger2;
    }

    public static KeyPair createKeys(int n) {
        Object object;
        if (n < 256) {
            n = 256;
        }
        BigInteger bigInteger = null;
        BigInteger bigInteger2 = null;
        BigInteger bigInteger3 = null;
        BigInteger bigInteger4 = null;
        while (bigInteger4 == null) {
            try {
                bigInteger = new BigInteger(n / 2, primeCertainty, random);
                bigInteger2 = new BigInteger(n / 2, primeCertainty, random);
                object = bigInteger.subtract(ONE).multiply(bigInteger2.subtract(ONE));
                bigInteger3 = R.modInverse((BigInteger)object);
                bigInteger4 = bigInteger.multiply(bigInteger2);
            }
            catch (ArithmeticException arithmeticException) {
                bigInteger4 = null;
            }
        }
        object = new RSAKey(R, bigInteger4, false);
        RSAKey rSAKey = null;
        try {
            rSAKey = new RSAKeyChin(bigInteger3, bigInteger4, bigInteger, true);
        }
        catch (KeyException keyException) {
            keyException.printStackTrace();
            rSAKey = new RSAKey(bigInteger3, bigInteger4, true);
        }
        return new KeyPair((Key)object, rSAKey);
    }

    public static KeyPair createKeys(String string, String string2, String string3, int n) throws InvalidCDSException {
        if (n < 256) {
            n = 256;
        }
        byte[] byArray = Fingerprint.create(string2, string3).getBytes();
        BigInteger bigInteger = new BigInteger(1, byArray);
        bigInteger = bigInteger.shiftLeft(n / 2 - bigInteger.bitLength());
        bigInteger = RSAKey.findPrime(bigInteger);
        byArray = Fingerprint.create(string + ":" + string2, string3).getBytes();
        BigInteger bigInteger2 = new BigInteger(1, byArray);
        bigInteger2 = bigInteger2.shiftLeft(n / 2 - bigInteger2.bitLength());
        bigInteger2 = RSAKey.findPrime(bigInteger2);
        BigInteger bigInteger3 = bigInteger.subtract(ONE).multiply(bigInteger2.subtract(ONE));
        BigInteger bigInteger4 = R.modInverse(bigInteger3);
        BigInteger bigInteger5 = bigInteger.multiply(bigInteger2);
        RSAKey rSAKey = new RSAKey(R, bigInteger5, false);
        RSAKey rSAKey2 = null;
        try {
            rSAKey2 = new RSAKeyChin(bigInteger4, bigInteger5, bigInteger, true);
        }
        catch (KeyException keyException) {
            keyException.printStackTrace();
            rSAKey2 = new RSAKey(bigInteger4, bigInteger5, true);
        }
        return new KeyPair(rSAKey, rSAKey2);
    }

    public static KeyPair createKeys(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) throws KeyException {
        RSAKey rSAKey = new RSAKey(bigInteger, bigInteger3, false);
        RSAKey rSAKey2 = new RSAKey(bigInteger2, bigInteger3, true);
        return new KeyPair(rSAKey, rSAKey2);
    }

    public int getSize() {
        return this.n.bitLength();
    }

    public String getAlgorithm() {
        return "RSA";
    }

    public BigInteger getExponent() {
        return this.r;
    }

    public BigInteger getModulus() {
        return this.n;
    }

    protected Fingerprint calcFingerprint(boolean bl, String string) throws InvalidCDSException {
        HashState hashState = HashState.create(string);
        hashState.update(this.n.toByteArray());
        if (bl == this.pri) {
            hashState.update("pub");
        } else {
            hashState.update("pri");
        }
        return hashState.calculate();
    }

    public boolean isPrivate() {
        return this.pri;
    }

    public String toString() {
        return "RSAKey(" + this.r.toString(16) + "," + this.n.toString(16) + "," + (this.pri ? "pri" : "pub") + ")";
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object instanceof RSAKey || object instanceof RSAKeyChin) {
            RSAKey rSAKey = (RSAKey)object;
            return this.r.equals(rSAKey.r) && this.n.equals(rSAKey.n) && this.pri == rSAKey.pri;
        }
        return false;
    }

    public final boolean matches(Key key) {
        if (key.getClass() != this.getClass()) {
            return false;
        }
        RSAKey rSAKey = (RSAKey)key;
        return this.n.equals(rSAKey.n);
    }

    public int plainBlockSize() {
        return (this.n.bitLength() - 1) / 8;
    }

    public int cipherBlockSize() {
        return this.plainBlockSize() + 1;
    }

    public void encrypt(byte[] byArray, int n, byte[] byArray2, int n2) {
        int n3 = this.plainBlockSize();
        byte[] byArray3 = new byte[n3];
        System.arraycopy(byArray, n, byArray3, 0, n3);
        BigInteger bigInteger = new BigInteger(1, byArray3);
        BigInteger bigInteger2 = bigInteger.modPow(this.r, this.n);
        byte[] byArray4 = bigInteger2.toByteArray();
        if (byArray4.length >= n3 + 1) {
            System.arraycopy(byArray4, byArray4.length - (n3 + 1), byArray2, n2, n3 + 1);
        } else {
            System.arraycopy(byArray4, 0, byArray2, n2 + (n3 + 1) - byArray4.length, byArray4.length);
            int n4 = n3 - byArray4.length;
            while (n4 >= 0) {
                byArray2[n2 + n4] = 0;
                --n4;
            }
        }
    }

    public void decrypt(byte[] byArray, int n, byte[] byArray2, int n2) {
        int n3 = this.plainBlockSize();
        byte[] byArray3 = new byte[n3 + 1];
        System.arraycopy(byArray, n, byArray3, 0, n3 + 1);
        BigInteger bigInteger = new BigInteger(1, byArray3);
        BigInteger bigInteger2 = bigInteger.modPow(this.r, this.n);
        byte[] byArray4 = bigInteger2.toByteArray();
        if (byArray4.length >= n3) {
            System.arraycopy(byArray4, byArray4.length - n3, byArray2, n2, n3);
        } else {
            System.arraycopy(byArray4, 0, byArray2, n2 + n3 - byArray4.length, byArray4.length);
            int n4 = n3 - byArray4.length - 1;
            while (n4 >= 0) {
                byArray2[n2 + n4] = 0;
                --n4;
            }
        }
    }

    public int signBlockSize() {
        return this.plainBlockSize();
    }

    public int signatureSize() {
        return this.cipherBlockSize();
    }

    public Signature sign(Fingerprint fingerprint) throws KeyException {
        if (!this.pri) {
            throw new KeyException("Signatures can only be generated with private RSA keys.");
        }
        byte[] byArray = fingerprint.getBytes();
        byte[] byArray2 = new byte[this.plainBlockSize()];
        byte[] byArray3 = new byte[this.cipherBlockSize()];
        if (byArray2.length < byArray.length) {
            throw new KeyException("This key is to short to sign this hash.");
        }
        System.arraycopy(byArray, 0, byArray2, byArray2.length - byArray.length, byArray.length);
        int n = byArray2.length - byArray.length - 1;
        int n2 = n % 8;
        n = n / 8 * 8;
        Crypto.writeBytes(random.nextLong(), byArray2, n, n2);
        n -= 8;
        while (n >= 0) {
            Crypto.writeBytes(random.nextLong(), byArray2, n, 8);
            n -= 8;
        }
        this.encrypt(byArray2, 0, byArray3, 0);
        return new Signature(byArray3, fingerprint.getName(), this.matchFingerprint());
    }

    public boolean verify(Signature signature, Fingerprint fingerprint) throws KeyException {
        if (this.pri) {
            throw new KeyException("Signatures can only be verified with public RSA keys.");
        }
        byte[] byArray = signature.getBytes();
        byte[] byArray2 = new byte[this.cipherBlockSize()];
        byte[] byArray3 = new byte[this.plainBlockSize()];
        System.arraycopy(byArray, 0, byArray2, byArray2.length - byArray.length, byArray.length);
        this.decrypt(byArray2, 0, byArray3, 0);
        byte[] byArray4 = fingerprint.getBytes();
        return Crypto.equalSub(byArray3, byArray3.length - byArray4.length, byArray4, 0, byArray4.length);
    }

    public RSAKey(BigInteger bigInteger, BigInteger bigInteger2, boolean bl) {
        this.pri = bl;
        this.r = bigInteger;
        this.n = bigInteger2;
    }
}

