/*
 * Decompiled with CFR 0.152.
 */
package org.logi.crypto.keys;

import org.logi.crypto.InvalidCDSException;
import org.logi.crypto.keys.CipherKey;
import org.logi.crypto.keys.SymmetricKey;

public final class CaesarKey
extends SymmetricKey
implements CipherKey {
    private byte shift;

    public static CaesarKey parseCDS(String string) throws InvalidCDSException {
        int n = 0;
        while (n < string.length() && Character.isWhitespace(string.charAt(n))) {
            ++n;
        }
        if (n == string.length()) {
            throw new InvalidCDSException("Empty argument in CaesarKey(String)");
        }
        int n2 = string.length() - 1;
        while (n2 >= 0 && Character.isWhitespace(string.charAt(n2))) {
            --n2;
        }
        if (n2 == n && string.charAt(n) == '?') {
            return new CaesarKey();
        }
        return new CaesarKey((byte)Integer.parseInt(string.substring(n, n2 + 1)));
    }

    public int getSize() {
        return 1;
    }

    public final int plainBlockSize() {
        return 1;
    }

    public final int cipherBlockSize() {
        return 1;
    }

    public String getAlgorithm() {
        return "Caesar";
    }

    public final boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        return this.shift == ((CaesarKey)object).shift;
    }

    public String toString() {
        if (this.shift < 0) {
            return "CaesarKey(" + (256 + this.shift) + ")";
        }
        return "CaesarKey(" + this.shift + ")";
    }

    public final void encrypt(byte[] byArray, int n, byte[] byArray2, int n2) {
        byArray2[n2] = (byte)(byArray[n] + this.shift);
    }

    public final void decrypt(byte[] byArray, int n, byte[] byArray2, int n2) {
        byArray2[n2] = (byte)(byArray[n] - this.shift);
    }

    public CaesarKey(byte by) {
        this.shift = by;
    }

    public CaesarKey() {
        this.shift = (byte)random.nextInt();
    }
}

