/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.jdic.browser;

import java.io.File;
import java.io.IOException;
import org.jdesktop.jdic.browser.BrowserEngineManager;
import org.jdesktop.jdic.browser.IBrowserEngine;
import org.jdesktop.jdic.browser.internal.WebBrowserUtil;
import org.jdesktop.jdic.init.InitUtility;
import org.jdesktop.jdic.init.JdicInitException;
import org.jdesktop.jdic.init.JdicManager;

public class MozillaEngine
implements IBrowserEngine {
    private static final String BROWSER_NAME = BrowserEngineManager.MOZILLA;
    private static final String MOZILLA_FIVE_HOME = "MOZILLA_FIVE_HOME";
    private static final String BIN_WIN_MOZILLA = "MozEmbed.exe";
    private static final String BIN_LINUX_GTK1 = "mozembed-linux-gtk1.2";
    private static final String BIN_linux_GTK2 = "mozembed-linux-gtk2";
    private static final String BIN_FREEBSD_GTK1 = "mozembed-freebsd-gtk1.2";
    private static final String BIN_FREEBSD_GTK2 = "mozembed-freebsd-gtk2";
    private static final String BIN_SOLARIS_GTK1 = "mozembed-solaris-gtk1.2";
    private static final String BIN_SOLARIS_GTK2 = "mozembed-solaris-gtk2";
    private static boolean isEngineAvailable = true;
    private static boolean initialized = false;
    private static final String libPathEnv = WebBrowserUtil.LIB_PATH_ENV;
    private String envXPComPath;
    private String browserBinName;
    private String runningPath;
    private String xpcomPathSetByUser;

    public void initialize() throws JdicInitException {
        if (!initialized) {
            this.preapareEnvVariables();
            this.setToEnv();
            this.grantXToBinFile(this.envXPComPath);
            initialized = true;
        }
    }

    public String getBrowserName() {
        return BROWSER_NAME;
    }

    public boolean isEngineAvailable() {
        return isEngineAvailable;
    }

    public boolean isDefaultBrowser(String string) {
        if (string == null) {
            return false;
        }
        return string.toLowerCase().indexOf(BROWSER_NAME.toLowerCase()) >= 0;
    }

    protected void preapareEnvVariables() throws JdicInitException {
        this.runningPath = JdicManager.getManager().getBinaryPath();
        if (this.getXPComPath(this.xpcomPathSetByUser)) {
            WebBrowserUtil.trace("Got xpcom from user set");
            return;
        }
        if (this.getXPComPath(InitUtility.getEnv(MOZILLA_FIVE_HOME))) {
            WebBrowserUtil.trace("Got xpcom from MOZILLA_FIVE_HOME");
            return;
        }
        String string = WebBrowserUtil.getDefaultBrowserPath();
        if (!this.isDefaultBrowser(string)) {
            WebBrowserUtil.error("Mozilla isn't default browser but set as active one, you must set its path(folder contains xpcom lib) through setEnginePath() or env MOZILLA_FIVE_HOME.");
            throw new JdicInitException("Mozilla isn't default browser but set as active one, you must set its path(folder contains xpcom lib) through setEnginePath() or env MOZILLA_FIVE_HOME.");
        }
        if (this.getXPComPath(string)) {
            WebBrowserUtil.trace("Got xpcom from registry(win)/path(unix)");
            return;
        }
        if (WebBrowserUtil.IS_OS_WINDOWS && this.getXPComPath(WebBrowserUtil.getMozillaGreHome())) {
            WebBrowserUtil.trace("Got xpcom from GREHome" + WebBrowserUtil.getMozillaGreHome());
            return;
        }
        isEngineAvailable = false;
        WebBrowserUtil.error("Can't find xpcom.dll/libxpcom.so!You must set its path(folder contains xpcom lib) through setEnginePath() or env MOZILLA_FIVE_HOME.");
        throw new JdicInitException("Can't find xpcom.dll/libxpcom.so!You must set its path(folder contains xpcom lib) through setEnginePath() or env MOZILLA_FIVE_HOME.");
    }

    private boolean getXPComPath(String string) throws JdicInitException {
        if (string == null) {
            return false;
        }
        String string2 = string.replaceAll("\"", "");
        String string3 = null;
        File file = new File(string2);
        try {
            string3 = file.isDirectory() ? file.getCanonicalPath() : file.getCanonicalFile().getParent();
        }
        catch (IOException iOException) {
            WebBrowserUtil.trace(iOException.toString());
            WebBrowserUtil.error("Path \"" + string2 + "\" is invalide.");
            throw new JdicInitException(iOException.getMessage());
        }
        if (this.isXPComPathValid(string3)) {
            this.envXPComPath = string3;
            return true;
        }
        return false;
    }

    private boolean isXPComPathValid(String string) throws JdicInitException {
        String string2 = null;
        string2 = WebBrowserUtil.IS_OS_WINDOWS ? "xpcom.dll" : "libxpcom.so";
        String string3 = string + File.separator + string2;
        return new File(string3).exists();
    }

    private void grantXToBinFile(String string) throws JdicInitException {
        if (WebBrowserUtil.IS_OS_WINDOWS) {
            this.browserBinName = BIN_WIN_MOZILLA;
            return;
        }
        if (WebBrowserUtil.IS_OS_LINUX || WebBrowserUtil.IS_OS_SUNOS || WebBrowserUtil.IS_OS_FREEBSD) {
            this.caculateUnixBinaryName(string);
            return;
        }
        WebBrowserUtil.trace("Not suppored OS now!");
        isEngineAvailable = false;
        throw new JdicInitException("Un supported OS!");
    }

    private void caculateUnixBinaryName(String string) throws JdicInitException {
        String string2 = WebBrowserUtil.OS_NAME;
        String string3 = null;
        String string4 = string + File.separator + "components" + File.separator + "libwidget_gtk2.so";
        File file = new File(string4);
        if (!file.exists()) {
            if (WebBrowserUtil.IS_OS_LINUX) {
                string3 = BIN_LINUX_GTK1;
            } else if (WebBrowserUtil.IS_OS_SUNOS) {
                string3 = BIN_SOLARIS_GTK1;
            } else if (WebBrowserUtil.IS_OS_FREEBSD) {
                string3 = BIN_FREEBSD_GTK1;
            }
        } else if (WebBrowserUtil.IS_OS_LINUX) {
            string3 = BIN_linux_GTK2;
        } else if (WebBrowserUtil.IS_OS_SUNOS) {
            string3 = BIN_SOLARIS_GTK2;
        } else if (WebBrowserUtil.IS_OS_FREEBSD) {
            string3 = BIN_FREEBSD_GTK2;
        }
        if (string3 != null) {
            this.browserBinName = string3;
            this.grantXToBin(string3);
        } else {
            WebBrowserUtil.trace("Failed to grant executable privilege to bin file for your OS. You'd better grant all JDIC bin files with executable privilege manually. ");
        }
    }

    private void setToEnv() throws JdicInitException {
        InitUtility.preAppendEnv(libPathEnv, this.runningPath);
        InitUtility.preAppendEnv(libPathEnv, this.envXPComPath);
        InitUtility.setEnv(MOZILLA_FIVE_HOME, this.envXPComPath);
    }

    private boolean grantXToBin(String string) throws JdicInitException {
        try {
            WebBrowserUtil.trace("will grant a+x to " + this.runningPath + File.separator + string);
            Runtime.getRuntime().exec("chmod a+x " + this.runningPath + File.separator + string);
            WebBrowserUtil.trace("grant ok");
            return true;
        }
        catch (IOException iOException) {
            WebBrowserUtil.error(iOException.getMessage());
            iOException.printStackTrace();
            throw new JdicInitException(iOException.getMessage());
        }
    }

    public String getEmbeddedBinaryName() {
        return this.browserBinName;
    }

    public void setEnginePath(String string) {
        this.xpcomPathSetByUser = string;
    }

    public String getCharsetName() {
        return "UTF-8";
    }

    public String getFileProtocolURLPrefix() {
        return "";
    }

    public boolean isInitialized() {
        return initialized;
    }
}

