/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.jdic.browser;

import java.io.File;
import org.jdesktop.jdic.browser.BrowserEngineManager;
import org.jdesktop.jdic.browser.IBrowserEngine;
import org.jdesktop.jdic.browser.internal.WebBrowserUtil;
import org.jdesktop.jdic.init.InitUtility;
import org.jdesktop.jdic.init.JdicInitException;
import org.jdesktop.jdic.init.JdicManager;

public class InternetExplorerEngine
implements IBrowserEngine {
    private static final String NSPR4_DLL = "nspr4.dll";
    private static final String IELIB = "ielib";
    private static final String IEXPLORE = "iexplore";
    private static final String BROWSER_NAME = BrowserEngineManager.IE;
    private static String browserBinary = "IeEmbed.exe";
    private static boolean isEngineAvailable = true;
    private static boolean initialized = false;
    private static final String libPathEnv = WebBrowserUtil.LIB_PATH_ENV;
    private String nspr4dllPath = null;
    private String browserFullPath = "";

    public String getBrowserName() {
        return BROWSER_NAME;
    }

    public boolean isEngineAvailable() {
        isEngineAvailable = WebBrowserUtil.IS_OS_WINDOWS;
        return isEngineAvailable;
    }

    public boolean isDefaultBrowser(String string) {
        if (string == null) {
            return false;
        }
        return string.toLowerCase().indexOf(IEXPLORE.toLowerCase()) >= 0;
    }

    protected boolean prepareVariables() {
        return true;
    }

    private boolean setNspr4dllPath(String string) {
        String string2 = string + NSPR4_DLL;
        File file = new File(string2);
        if (file != null && file.exists()) {
            this.nspr4dllPath = string;
            WebBrowserUtil.trace("nspr4.dll is set under " + string);
            return true;
        }
        WebBrowserUtil.error("nspr4.dll doesn't exist under " + string);
        return false;
    }

    protected void setEnv() {
        if (this.nspr4dllPath == null) {
            String string = JdicManager.getManager().getBinaryPath() + File.separator + IELIB;
            InitUtility.preAppendEnv(libPathEnv, string);
            WebBrowserUtil.trace("nspr4.dll under " + string + " is set to PATH");
        } else {
            InitUtility.preAppendEnv(libPathEnv, this.nspr4dllPath);
            WebBrowserUtil.trace("nspr4.dll under " + this.nspr4dllPath + " is set to PATH");
        }
    }

    public String getBrowserBinary() {
        return browserBinary;
    }

    protected String getNspr4dllPath() {
        return this.nspr4dllPath;
    }

    public void initialize() throws JdicInitException {
        if (!initialized) {
            this.prepareVariables();
            this.setEnv();
            initialized = true;
            WebBrowserUtil.trace("Engine initialize once!");
        }
    }

    public String getEmbeddedBinaryName() {
        return browserBinary;
    }

    public void setEnginePath(String string) {
        this.browserFullPath = string;
    }

    public String getCharsetName() {
        return System.getProperty("file.encoding");
    }

    public String getFileProtocolURLPrefix() {
        return "file:/";
    }

    public boolean isInitialized() {
        return initialized;
    }
}

