/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.httpclient.methods;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.httpclient.ChunkedOutputStream;
import org.apache.commons.httpclient.ContentLengthInputStream;
import org.apache.commons.httpclient.HttpConnection;
import org.apache.commons.httpclient.HttpConstants;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpState;
import org.apache.commons.httpclient.methods.ExpectContinueMethod;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class EntityEnclosingMethod
extends ExpectContinueMethod {
    public static final int CONTENT_LENGTH_AUTO = -2;
    public static final int CONTENT_LENGTH_CHUNKED = -1;
    private static final Log LOG = LogFactory.getLog((Class)(class$org$apache$commons$httpclient$methods$EntityEnclosingMethod == null ? (class$org$apache$commons$httpclient$methods$EntityEnclosingMethod = EntityEnclosingMethod.class$("org.apache.commons.httpclient.methods.EntityEnclosingMethod")) : class$org$apache$commons$httpclient$methods$EntityEnclosingMethod));
    private byte[] buffer = null;
    private InputStream requestStream = null;
    private String requestString = null;
    private byte[] contentCache = null;
    private int repeatCount = 0;
    private int requestContentLength = -2;
    static /* synthetic */ Class class$org$apache$commons$httpclient$methods$EntityEnclosingMethod;

    public EntityEnclosingMethod() {
        this.setFollowRedirects(false);
    }

    public EntityEnclosingMethod(String uri) {
        super(uri);
        this.setFollowRedirects(false);
    }

    protected boolean hasRequestContent() {
        LOG.trace((Object)"enter EntityEnclosingMethod.hasRequestContent()");
        return this.buffer != null || this.requestStream != null || this.requestString != null;
    }

    protected void clearRequestBody() {
        LOG.trace((Object)"enter EntityEnclosingMethod.clearRequestBody()");
        this.requestStream = null;
        this.requestString = null;
        this.buffer = null;
        this.contentCache = null;
    }

    protected byte[] generateRequestBody() {
        LOG.trace((Object)"enter EntityEnclosingMethod.renerateRequestBody()");
        if (this.requestStream != null) {
            this.bufferContent();
        }
        if (this.buffer != null) {
            return this.buffer;
        }
        if (this.requestString != null) {
            return HttpConstants.getContentBytes(this.requestString, this.getRequestCharSet());
        }
        return null;
    }

    public boolean getFollowRedirects() {
        return false;
    }

    public void setFollowRedirects(boolean followRedirects) {
        if (followRedirects) {
            // empty if block
        }
        super.setFollowRedirects(false);
    }

    public void setRequestContentLength(int length) {
        LOG.trace((Object)"enter EntityEnclosingMethod.setRequestContentLength(int)");
        this.requestContentLength = length;
    }

    protected int getRequestContentLength() {
        LOG.trace((Object)"enter EntityEnclosingMethod.getRequestContentLength()");
        if (!this.hasRequestContent()) {
            return 0;
        }
        if (this.requestContentLength != -2) {
            return this.requestContentLength;
        }
        if (this.contentCache == null) {
            this.contentCache = this.generateRequestBody();
        }
        return this.contentCache == null ? 0 : this.contentCache.length;
    }

    protected void addContentLengthRequestHeader(HttpState state, HttpConnection conn) throws IOException, HttpException {
        LOG.trace((Object)"enter HttpMethodBase.addContentLengthRequestHeader(HttpState, HttpConnection)");
        if (this.getRequestHeader("content-length") == null && this.getRequestHeader("Transfer-Encoding") == null) {
            int len = this.getRequestContentLength();
            if (len >= 0) {
                this.addRequestHeader("Content-Length", String.valueOf(len));
            } else if (len == -1 && this.isHttp11()) {
                this.addRequestHeader("Transfer-Encoding", "chunked");
            }
        }
    }

    public void setRequestBody(InputStream body) {
        LOG.trace((Object)"enter EntityEnclosingMethod.setRequestBody(InputStream)");
        this.clearRequestBody();
        this.requestStream = body;
    }

    public InputStream getRequestBody() {
        LOG.trace((Object)"enter EntityEnclosingMethod.getRequestBody()");
        byte[] content = this.generateRequestBody();
        if (content != null) {
            return new ByteArrayInputStream(content);
        }
        return new ByteArrayInputStream(new byte[0]);
    }

    public void setRequestBody(String body) {
        LOG.trace((Object)"enter EntityEnclosingMethod.setRequestBody(String)");
        this.clearRequestBody();
        this.requestString = body;
    }

    public String getRequestBodyAsString() throws IOException {
        LOG.trace((Object)"enter EntityEnclosingMethod.getRequestBodyAsString()");
        byte[] content = this.generateRequestBody();
        if (content != null) {
            return HttpConstants.getContentString(content, this.getRequestCharSet());
        }
        return null;
    }

    protected boolean writeRequestBody(HttpState state, HttpConnection conn) throws IOException, HttpException {
        LOG.trace((Object)"enter EntityEnclosingMethod.writeRequestBody(HttpState, HttpConnection)");
        if (!this.hasRequestContent()) {
            LOG.debug((Object)"Request body has not been specified");
            return true;
        }
        int contentLength = this.getRequestContentLength();
        if (contentLength == -1 && !this.isHttp11()) {
            throw new HttpException("Chunked transfer encoding not allowed for HTTP/1.0");
        }
        InputStream instream = null;
        if (this.requestStream != null) {
            LOG.debug((Object)"Using unbuffered request body");
            instream = this.requestStream;
        } else {
            if (this.contentCache == null) {
                this.contentCache = this.generateRequestBody();
            }
            if (this.contentCache != null) {
                LOG.debug((Object)"Using buffered request body");
                instream = new ByteArrayInputStream(this.contentCache);
            }
        }
        if (instream == null) {
            LOG.debug((Object)"Request body is empty");
            return true;
        }
        if (this.repeatCount > 0 && this.contentCache == null) {
            throw new HttpException("Unbuffered entity enclosing request can not be repeated.");
        }
        ++this.repeatCount;
        OutputStream outstream = conn.getRequestOutputStream();
        if (contentLength == -1) {
            outstream = new ChunkedOutputStream(outstream);
        }
        if (contentLength >= 0) {
            instream = new ContentLengthInputStream(instream, contentLength);
        }
        byte[] tmp = new byte[4096];
        int total = 0;
        int i = 0;
        while ((i = instream.read(tmp)) >= 0) {
            outstream.write(tmp, 0, i);
            total += i;
        }
        if (outstream instanceof ChunkedOutputStream) {
            ((ChunkedOutputStream)outstream).writeClosingChunk();
        }
        if (contentLength > 0 && total < contentLength) {
            throw new IOException("Unexpected end of input stream after " + total + " bytes (expected " + contentLength + " bytes)");
        }
        LOG.debug((Object)"Request body sent");
        return true;
    }

    public void recycle() {
        LOG.trace((Object)"enter EntityEnclosingMethod.recycle()");
        this.clearRequestBody();
        this.requestContentLength = -2;
        this.repeatCount = 0;
        super.recycle();
    }

    private void bufferContent() {
        LOG.trace((Object)"enter EntityEnclosingMethod.bufferContent()");
        if (this.buffer != null) {
            return;
        }
        if (this.requestStream != null) {
            try {
                ByteArrayOutputStream tmp = new ByteArrayOutputStream();
                byte[] data = new byte[4096];
                int l = 0;
                while ((l = this.requestStream.read(data)) >= 0) {
                    tmp.write(data, 0, l);
                }
                this.buffer = tmp.toByteArray();
                this.requestStream = null;
            }
            catch (IOException e) {
                LOG.error((Object)e.getMessage(), (Throwable)e);
                this.buffer = null;
                this.requestStream = null;
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

