/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GlyphMetrics;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.graphics.TextStyle;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Compatibility;
import org.eclipse.swt.internal.carbon.ATSFontMetrics;
import org.eclipse.swt.internal.carbon.ATSTrapezoid;
import org.eclipse.swt.internal.carbon.ATSUCaret;
import org.eclipse.swt.internal.carbon.ATSUTab;
import org.eclipse.swt.internal.carbon.ATSUUnhighlightData;
import org.eclipse.swt.internal.carbon.CGRect;
import org.eclipse.swt.internal.carbon.OS;
import org.eclipse.swt.internal.carbon.RGBColor;
import org.eclipse.swt.internal.carbon.Rect;

public final class TextLayout
extends Resource {
    Font font;
    String text;
    int textPtr;
    StyleItem[] styles;
    int layout;
    int spacing;
    int ascent;
    int descent;
    int indent;
    int indentStyle;
    int[] tabs;
    int[] segments;
    int tabsPtr;
    int[] breaks;
    int[] hardBreaks;
    int[] lineX;
    int[] lineWidth;
    int[] lineHeight;
    int[] lineAscent;
    static final int TAB_COUNT = 32;
    static final char ZWS = '\u200b';

    public TextLayout(Device device) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        this.device = device;
        int[] buffer = new int[1];
        OS.ATSUCreateTextLayout(buffer);
        if (buffer[0] == 0) {
            SWT.error(2);
        }
        this.layout = buffer[0];
        this.setLayoutControl(3, 0, 1);
        int lineOptions = 0x1000020;
        this.setLayoutControl(7, lineOptions, 4);
        OS.ATSUSetHighlightingMethod(this.layout, 1, new ATSUUnhighlightData());
        this.descent = -1;
        this.ascent = -1;
        this.text = "";
        this.styles = new StyleItem[2];
        this.styles[0] = new StyleItem();
        this.styles[1] = new StyleItem();
    }

    void checkLayout() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
    }

    void computeRuns() {
        char c;
        if (this.breaks != null) {
            return;
        }
        int textLength = this.text.length();
        char[] chars = new char[textLength + 1];
        this.text.getChars(0, textLength, chars, 1);
        chars[0] = 8203;
        int breakCount = 1;
        int i = 0;
        while (i < chars.length) {
            c = chars[i];
            if (c == '\n' || c == '\r') {
                ++breakCount;
            }
            ++i;
        }
        this.hardBreaks = new int[breakCount];
        breakCount = 0;
        i = 0;
        while (i < chars.length) {
            c = chars[i];
            if (c == '\n' || c == '\r') {
                chars[i] = 8203;
                this.hardBreaks[breakCount++] = i;
            }
            ++i;
        }
        this.hardBreaks[breakCount] = this.translateOffset(textLength);
        int newTextPtr = OS.NewPtr(chars.length * 2);
        OS.memmove(newTextPtr, chars, chars.length * 2);
        OS.ATSUSetTextPointerLocation(this.layout, newTextPtr, 0, chars.length, chars.length);
        OS.ATSUSetTransientFontMatching(this.layout, true);
        if (this.textPtr != 0) {
            OS.DisposePtr(this.textPtr);
        }
        this.textPtr = newTextPtr;
        int[] buffer = new int[1];
        int i2 = 0;
        while (i2 < this.styles.length - 1) {
            StyleItem run = this.styles[i2];
            run.createStyle(this.font);
            int start = textLength != 0 ? this.translateOffset(run.start) : 0;
            int runLength = this.translateOffset(this.styles[i2 + 1].start) - start;
            OS.ATSUSetRunStyle(this.layout, run.atsuStyle, start, runLength);
            ++i2;
        }
        int ptr = OS.NewPtr(12);
        int[] nArray = new int[3];
        nArray[0] = OS.Long2Fix(this.indent);
        buffer = nArray;
        OS.memmove(ptr, buffer, 12);
        int[] tags = new int[]{266, 284, 285};
        int[] sizes = new int[]{4, 4, 4};
        int[] values = new int[]{ptr, ptr + 4, ptr + 8};
        OS.ATSUCreateStyle(buffer);
        this.indentStyle = buffer[0];
        OS.ATSUSetAttributes(this.indentStyle, tags.length, tags, sizes, values);
        OS.DisposePtr(ptr);
        OS.ATSUSetRunStyle(this.layout, this.indentStyle, 0, 1);
        int i3 = 0;
        while (i3 < this.hardBreaks.length - 1) {
            int offset = this.hardBreaks[i3];
            OS.ATSUSetRunStyle(this.layout, this.indentStyle, offset, 1);
            ++i3;
        }
        OS.ATSUGetLayoutControl(this.layout, 1, 4, buffer, null);
        int wrapWidth = buffer[0];
        int i4 = 0;
        int start = 0;
        while (i4 < this.hardBreaks.length) {
            int hardBreak = this.hardBreaks[i4];
            buffer[0] = 0;
            if (wrapWidth != 0) {
                OS.ATSUBatchBreakLines(this.layout, start, hardBreak - start, wrapWidth, buffer);
            }
            OS.ATSUSetSoftLineBreak(this.layout, hardBreak);
            start = hardBreak;
            ++i4;
        }
        OS.ATSUGetSoftLineBreaks(this.layout, 0, -1, 0, null, buffer);
        int count = buffer[0];
        this.breaks = new int[count];
        OS.ATSUGetSoftLineBreaks(this.layout, 0, -1, count, this.breaks, null);
        int lineCount = this.breaks.length;
        this.lineX = new int[lineCount];
        this.lineWidth = new int[lineCount];
        this.lineHeight = new int[lineCount];
        this.lineAscent = new int[lineCount];
        ATSTrapezoid trapezoid = new ATSTrapezoid();
        int i5 = 0;
        int start2 = 0;
        while (i5 < lineCount) {
            if (this.ascent != -1) {
                ptr = OS.NewPtr(4);
                buffer[0] = Integer.MAX_VALUE;
                OS.memmove(ptr, buffer, 4);
                tags = new int[]{8};
                sizes = new int[]{4};
                values = new int[]{ptr};
                OS.ATSUSetLineControls(this.layout, start2, tags.length, tags, sizes, values);
                OS.ATSUGetLineControl(this.layout, start2, 8, 4, buffer, null);
                buffer[0] = OS.Long2Fix(Math.max(this.ascent, OS.Fix2Long(buffer[0])));
                OS.memmove(ptr, buffer, 4);
                OS.ATSUSetLineControls(this.layout, start2, tags.length, tags, sizes, values);
                OS.DisposePtr(ptr);
            }
            if (this.descent != -1) {
                ptr = OS.NewPtr(4);
                buffer[0] = Integer.MAX_VALUE;
                OS.memmove(ptr, buffer, 4);
                tags = new int[]{9};
                sizes = new int[]{4};
                values = new int[]{ptr};
                OS.ATSUSetLineControls(this.layout, start2, tags.length, tags, sizes, values);
                OS.ATSUGetLineControl(this.layout, start2, 9, 4, buffer, null);
                buffer[0] = OS.Long2Fix(Math.max(this.descent, OS.Fix2Long(buffer[0])));
                OS.memmove(ptr, buffer, 4);
                OS.ATSUSetLineControls(this.layout, start2, tags.length, tags, sizes, values);
                OS.DisposePtr(ptr);
            }
            int lineBreak = this.breaks[i5];
            int lineLength = lineBreak - start2;
            OS.ATSUGetGlyphBounds(this.layout, 0, 0, start2, lineLength, (short)1, 1, trapezoid, null);
            this.lineX[i5] = OS.Fix2Long(trapezoid.lowerLeft_x);
            this.lineAscent[i5] = -OS.Fix2Long(trapezoid.upperRight_y);
            if (lineLength != 0) {
                this.lineWidth[i5] = OS.Fix2Long(trapezoid.lowerRight_x) - OS.Fix2Long(trapezoid.lowerLeft_x);
            }
            this.lineHeight[i5] = OS.Fix2Long(trapezoid.lowerRight_y) + this.lineAscent[i5] + this.spacing;
            start2 = lineBreak;
            ++i5;
        }
    }

    public void dispose() {
        if (this.layout == 0) {
            return;
        }
        this.freeRuns();
        this.font = null;
        this.text = null;
        this.styles = null;
        if (this.layout != 0) {
            OS.ATSUDisposeTextLayout(this.layout);
        }
        this.layout = 0;
        if (this.textPtr != 0) {
            OS.DisposePtr(this.textPtr);
        }
        this.textPtr = 0;
        if (this.tabsPtr != 0) {
            OS.DisposePtr(this.tabsPtr);
        }
        this.tabsPtr = 0;
        if (this.indentStyle != 0) {
            OS.ATSUDisposeStyle(this.indentStyle);
        }
        this.indentStyle = 0;
        this.device = null;
    }

    public void draw(GC gc, int x, int y) {
        this.draw(gc, x, y, -1, -1, null, null);
    }

    public void draw(GC gc, int x, int y, int selectionStart, int selectionEnd, Color selectionForeground, Color selectionBackground) {
        this.draw(gc, x, y, selectionStart, selectionEnd, selectionForeground, selectionBackground, 0);
    }

    public void draw(GC gc, int x, int y, int selectionStart, int selectionEnd, Color selectionForeground, Color selectionBackground, int flags) {
        int start;
        int length;
        this.checkLayout();
        this.computeRuns();
        if (gc == null) {
            SWT.error(4);
        }
        if (gc.isDisposed()) {
            SWT.error(5);
        }
        if (selectionForeground != null && selectionForeground.isDisposed()) {
            SWT.error(5);
        }
        if (selectionBackground != null && selectionBackground.isDisposed()) {
            SWT.error(5);
        }
        if ((length = this.translateOffset(this.text.length())) == 0 && flags == 0) {
            return;
        }
        gc.checkGC(256);
        if (gc.data.updateClip) {
            gc.setCGClipping();
        }
        OS.CGContextSaveGState(gc.handle);
        this.setLayoutControl(Short.MAX_VALUE, gc.handle, 4);
        boolean hasSelection = selectionStart <= selectionEnd && selectionStart != -1 && selectionEnd != -1;
        boolean restoreColor = false;
        if (hasSelection || (flags & 0x100000) != 0) {
            if (selectionBackground != null) {
                restoreColor = true;
                int color = OS.CGColorCreate(this.device.colorspace, selectionBackground.handle);
                this.setLayoutControl(17, color, 4);
                OS.CGColorRelease(color);
            } else {
                selectionBackground = this.device.getSystemColor(25);
            }
        }
        int rgn = 0;
        CGRect rect = null;
        Callback callback = null;
        int j = 0;
        while (j < this.styles.length) {
            StyleItem run = this.styles[j];
            TextStyle style = run.style;
            if (style != null && style.background != null) {
                start = this.translateOffset(run.start);
                int end = j + 1 < this.styles.length ? this.translateOffset(this.styles[j + 1].start - 1) : length;
                int i = 0;
                int lineStart = 0;
                int lineY = 0;
                while (i < this.breaks.length) {
                    int lineBreak = this.breaks[i];
                    int lineEnd = lineBreak - 1;
                    if (start <= lineEnd && end >= lineStart) {
                        int highStart = Math.max(lineStart, start);
                        int highEnd = Math.min(lineEnd, end);
                        int highLen = highEnd - highStart + 1;
                        if (highLen > 0) {
                            if (rgn == 0) {
                                rgn = OS.NewRgn();
                            }
                            OS.ATSUGetTextHighlight(this.layout, OS.Long2Fix(x), OS.Long2Fix(y + lineY + this.lineAscent[i]), highStart, highLen, rgn);
                            OS.CGContextSaveGState(gc.handle);
                            if (callback == null && (callback = new Callback(this, "regionToRects", 4)).getAddress() == 0) {
                                SWT.error(3);
                            }
                            OS.QDRegionToRects(rgn, 5, callback.getAddress(), gc.handle);
                            if (rect == null) {
                                rect = new CGRect();
                            }
                            OS.CGContextGetPathBoundingBox(gc.handle, rect);
                            OS.CGContextEOClip(gc.handle);
                            OS.CGContextSetFillColorSpace(gc.handle, this.device.colorspace);
                            OS.CGContextSetFillColor(gc.handle, style.background.handle);
                            OS.CGContextFillRect(gc.handle, rect);
                            OS.CGContextRestoreGState(gc.handle);
                        }
                    }
                    if (lineEnd > end) break;
                    lineY += this.lineHeight[i];
                    lineStart = lineBreak;
                    ++i;
                }
            }
            ++j;
        }
        if (callback != null) {
            callback.dispose();
        }
        if (rgn != 0) {
            OS.DisposeRgn(rgn);
        }
        selectionStart = this.translateOffset(selectionStart);
        selectionEnd = this.translateOffset(selectionEnd);
        OS.CGContextScaleCTM(gc.handle, 1.0f, -1.0f);
        int drawX = OS.Long2Fix(x);
        int drawY = y;
        int i = 0;
        start = 0;
        while (i < this.breaks.length) {
            int lineBreak = this.breaks[i];
            int lineLength = lineBreak - start;
            if (lineLength > 0) {
                int fixYDraw = OS.Long2Fix(-(drawY + this.lineAscent[i]));
                OS.ATSUDrawText(this.layout, start, lineLength, drawX, fixYDraw);
                int end = start + lineLength - 1;
                if (flags != 0 && (hasSelection || (flags & 0x100000) != 0)) {
                    boolean extent = false;
                    if (i == this.breaks.length - 1 && (flags & 0x100000) != 0) {
                        extent = true;
                    } else {
                        boolean hardBreak = false;
                        int j2 = 0;
                        while (j2 < this.hardBreaks.length) {
                            if (end + 1 == this.hardBreaks[j2]) {
                                hardBreak = true;
                                break;
                            }
                            ++j2;
                        }
                        if (hardBreak) {
                            if (selectionStart <= end + 1 && end + 1 <= selectionEnd) {
                                extent = true;
                            }
                        } else if (selectionStart <= end + 1 && end + 1 < selectionEnd && (flags & 0x10000) != 0) {
                            extent = true;
                        }
                    }
                    if (extent) {
                        if (rect == null) {
                            rect = new CGRect();
                        }
                        rect.x = x + this.lineWidth[i];
                        rect.y = drawY;
                        rect.width = (flags & 0x10000) != 0 ? Integer.MAX_VALUE : this.lineHeight[i] / 3;
                        rect.height = this.lineHeight[i];
                        OS.CGContextSaveGState(gc.handle);
                        OS.CGContextTranslateCTM(gc.handle, 0.0f, -(this.lineHeight[i] + 2 * drawY));
                        OS.CGContextSetFillColorSpace(gc.handle, this.device.colorspace);
                        OS.CGContextSetFillColor(gc.handle, selectionBackground.handle);
                        OS.CGContextFillRect(gc.handle, rect);
                        OS.CGContextRestoreGState(gc.handle);
                    }
                }
                if (hasSelection && selectionStart <= end && start <= selectionEnd) {
                    int selStart = Math.max(selectionStart, start);
                    int selEnd = Math.min(selectionEnd, end);
                    OS.ATSUHighlightText(this.layout, drawX, fixYDraw, selStart, selEnd - selStart + 1);
                }
            }
            drawY += this.lineHeight[i];
            start = lineBreak;
            ++i;
        }
        if (restoreColor) {
            this.setLayoutControl(17, 0, 4);
        }
        OS.CGContextRestoreGState(gc.handle);
    }

    void freeRuns() {
        if (this.breaks == null) {
            return;
        }
        int i = 0;
        while (i < this.styles.length) {
            StyleItem run = this.styles[i];
            run.freeStyle();
            ++i;
        }
        if (this.indentStyle != 0) {
            OS.ATSUDisposeStyle(this.indentStyle);
        }
        this.indentStyle = 0;
        this.lineAscent = null;
        this.lineHeight = null;
        this.lineWidth = null;
        this.lineX = null;
        this.breaks = null;
    }

    public int getAlignment() {
        this.checkLayout();
        int[] buffer = new int[1];
        OS.ATSUGetLayoutControl(this.layout, 5, 4, buffer, null);
        switch (buffer[0]) {
            case 0x20000000: {
                return 0x1000000;
            }
            case 0x40000000: {
                return 131072;
            }
        }
        return 16384;
    }

    public int getAscent() {
        this.checkLayout();
        return this.ascent;
    }

    public Rectangle getBounds() {
        this.checkLayout();
        this.computeRuns();
        int width = 0;
        int height = 0;
        int length = this.text.length();
        if (length == 0) {
            Font font = this.font != null ? this.font : this.device.getSystemFont();
            ATSFontMetrics metrics = new ATSFontMetrics();
            OS.ATSFontGetVerticalMetrics(font.handle, 0, metrics);
            OS.ATSFontGetHorizontalMetrics(font.handle, 0, metrics);
            int ascent = (int)(0.5f + metrics.ascent * font.size);
            int descent = (int)(0.5f + (-metrics.descent + metrics.leading) * font.size);
            ascent = Math.max(ascent, this.ascent);
            descent = Math.max(descent, this.descent);
            height = ascent + descent;
        } else {
            int i = 0;
            while (i < this.breaks.length) {
                width = Math.max(width, this.lineWidth[i]);
                height += this.lineHeight[i];
                ++i;
            }
        }
        int[] buffer = new int[1];
        OS.ATSUGetLayoutControl(this.layout, 1, 4, buffer, null);
        int wrapWidth = OS.Fix2Long(buffer[0]);
        if (wrapWidth != 0) {
            width = Math.max(width, wrapWidth);
        }
        return new Rectangle(0, 0, width, height);
    }

    public Rectangle getBounds(int start, int end) {
        this.checkLayout();
        this.computeRuns();
        int length = this.text.length();
        if (length == 0) {
            return new Rectangle(0, 0, 0, 0);
        }
        if (start > end) {
            return new Rectangle(0, 0, 0, 0);
        }
        start = Math.min(Math.max(0, start), length - 1);
        end = Math.min(Math.max(0, end), length - 1);
        start = this.translateOffset(start);
        end = this.translateOffset(end);
        int i = 0;
        while (i < this.hardBreaks.length) {
            if (start == this.hardBreaks[i] && start > 0) {
                --start;
            }
            if (end == this.hardBreaks[i] && end > 0) {
                --end;
            }
            ++i;
        }
        int rgn = OS.NewRgn();
        Rect rect = new Rect();
        Rect rect1 = new Rect();
        int i2 = 0;
        int lineStart = 0;
        int lineY = 0;
        while (i2 < this.breaks.length) {
            int lineBreak = this.breaks[i2];
            int lineEnd = lineBreak - 1;
            if (start <= lineEnd && end >= lineStart) {
                int highStart = Math.max(lineStart, start);
                int highEnd = Math.min(lineEnd, end);
                int highLen = highEnd - highStart + 1;
                if (highLen > 0) {
                    OS.ATSUGetTextHighlight(this.layout, 0, OS.Long2Fix(lineY + this.lineAscent[i2]), highStart, highLen, rgn);
                    OS.GetRegionBounds(rgn, rect1);
                    OS.UnionRect(rect, rect1, rect);
                }
            }
            if (lineEnd > end) break;
            lineY += this.lineHeight[i2];
            lineStart = lineBreak;
            ++i2;
        }
        OS.DisposeRgn(rgn);
        return new Rectangle(rect.left, rect.top, rect.right - rect.left, rect.bottom - rect.top);
    }

    public int getDescent() {
        this.checkLayout();
        return this.descent;
    }

    public Font getFont() {
        this.checkLayout();
        return this.font;
    }

    public int getIndent() {
        this.checkLayout();
        return this.indent;
    }

    public boolean getJustify() {
        this.checkLayout();
        int[] buffer = new int[1];
        OS.ATSUGetLayoutControl(this.layout, 4, 4, buffer, null);
        return buffer[0] == 0x40000000;
    }

    public int getLevel(int offset) {
        this.checkLayout();
        this.computeRuns();
        int length = this.text.length();
        if (offset < 0 || offset > length) {
            SWT.error(6);
        }
        offset = this.translateOffset(offset);
        int level = 0;
        return level;
    }

    public int[] getLineOffsets() {
        this.checkLayout();
        this.computeRuns();
        int[] offsets = new int[this.breaks.length + 1];
        int i = 1;
        while (i < offsets.length) {
            offsets[i] = this.untranslateOffset(this.breaks[i - 1]);
            ++i;
        }
        return offsets;
    }

    public int getLineIndex(int offset) {
        this.checkLayout();
        this.computeRuns();
        int length = this.text.length();
        if (offset < 0 || offset > length) {
            SWT.error(5);
        }
        offset = this.translateOffset(offset);
        int i = 0;
        while (i < this.breaks.length - 1) {
            int lineBreak = this.breaks[i];
            if (lineBreak > offset) {
                return i;
            }
            ++i;
        }
        return this.breaks.length - 1;
    }

    public Rectangle getLineBounds(int lineIndex) {
        this.checkLayout();
        this.computeRuns();
        int lineCount = this.breaks.length;
        if (lineIndex < 0 || lineIndex >= lineCount) {
            SWT.error(6);
        }
        int lineY = 0;
        int i = 0;
        while (i < lineIndex) {
            lineY += this.lineHeight[i];
            ++i;
        }
        int lineX = this.lineX[lineIndex];
        int lineWidth = this.lineWidth[lineIndex];
        int lineHeight = this.lineHeight[lineIndex] - this.spacing;
        return new Rectangle(lineX, lineY, lineWidth, lineHeight);
    }

    public int getLineCount() {
        this.checkLayout();
        this.computeRuns();
        return this.breaks.length;
    }

    public FontMetrics getLineMetrics(int lineIndex) {
        int length;
        this.checkLayout();
        this.computeRuns();
        int lineCount = this.breaks.length;
        if (lineIndex < 0 || lineIndex >= lineCount) {
            SWT.error(6);
        }
        if ((length = this.text.length()) == 0) {
            Font font = this.font != null ? this.font : this.device.getSystemFont();
            ATSFontMetrics metrics = new ATSFontMetrics();
            OS.ATSFontGetVerticalMetrics(font.handle, 0, metrics);
            OS.ATSFontGetHorizontalMetrics(font.handle, 0, metrics);
            int ascent = (int)(0.5f + metrics.ascent * font.size);
            int descent = (int)(0.5f + (-metrics.descent + metrics.leading) * font.size);
            ascent = Math.max(ascent, this.ascent);
            descent = Math.max(descent, this.descent);
            return FontMetrics.carbon_new(ascent, descent, 0, 0, ascent + descent);
        }
        int start = lineIndex == 0 ? 0 : this.breaks[lineIndex - 1];
        int lineLength = this.breaks[lineIndex] - start;
        int[] ascent = new int[1];
        int[] descent = new int[1];
        OS.ATSUGetUnjustifiedBounds(this.layout, start, lineLength, null, null, ascent, descent);
        int height = OS.Fix2Long(ascent[0]) + OS.Fix2Long(descent[0]);
        return FontMetrics.carbon_new(OS.Fix2Long(ascent[0]), OS.Fix2Long(descent[0]), 0, 0, height);
    }

    public Point getLocation(int offset, boolean trailing) {
        this.checkLayout();
        this.computeRuns();
        int length = this.text.length();
        if (offset < 0 || offset > length) {
            SWT.error(6);
        }
        if (length == 0) {
            return new Point(0, 0);
        }
        offset = this.translateOffset(offset);
        int i = 0;
        while (i < this.hardBreaks.length) {
            if (offset == this.hardBreaks[i]) {
                trailing = true;
                if (offset <= 0) break;
                --offset;
                break;
            }
            ++i;
        }
        int lineY = 0;
        int i2 = 0;
        while (i2 < this.breaks.length - 1) {
            int lineBreak = this.breaks[i2];
            if (lineBreak > offset) break;
            lineY += this.lineHeight[i2];
            ++i2;
        }
        if (trailing) {
            ++offset;
        }
        ATSUCaret caret = new ATSUCaret();
        OS.ATSUOffsetToPosition(this.layout, offset, !trailing, caret, null, null);
        return new Point(Math.min(OS.Fix2Long(caret.fX), OS.Fix2Long(caret.fDeltaX)), lineY);
    }

    public int getNextOffset(int offset, int movement) {
        return this._getOffset(offset, movement, true);
    }

    int _getOffset(int offset, int movement, boolean forward) {
        int[] newOffset;
        block14: {
            int type;
            block13: {
                this.checkLayout();
                this.computeRuns();
                int length = this.text.length();
                if (offset < 0 || offset > length) {
                    SWT.error(6);
                }
                if (length == 0) {
                    return 0;
                }
                offset = this.translateOffset(offset);
                newOffset = new int[1];
                type = 0;
                switch (movement) {
                    case 2: {
                        type = 3;
                        break;
                    }
                    case 4: {
                        type = 2;
                    }
                }
                if (!forward) break block13;
                OS.ATSUNextCursorPosition(this.layout, offset, type, newOffset);
                offset = newOffset[0];
                newOffset[0] = this.untranslateOffset(newOffset[0]);
                if (movement == 4 || movement == 8) {
                    while (newOffset[0] < length && (Compatibility.isLetterOrDigit(this.text.charAt(newOffset[0])) || !Compatibility.isLetterOrDigit(this.text.charAt(newOffset[0] - 1)))) {
                        OS.ATSUNextCursorPosition(this.layout, offset, type, newOffset);
                        offset = newOffset[0];
                        newOffset[0] = this.untranslateOffset(newOffset[0]);
                    }
                }
                if (movement != 16) break block14;
                while (newOffset[0] < length && (!Compatibility.isLetterOrDigit(this.text.charAt(newOffset[0])) || Compatibility.isLetterOrDigit(this.text.charAt(newOffset[0] - 1)))) {
                    OS.ATSUNextCursorPosition(this.layout, offset, type, newOffset);
                    offset = newOffset[0];
                    newOffset[0] = this.untranslateOffset(newOffset[0]);
                }
                break block14;
            }
            OS.ATSUPreviousCursorPosition(this.layout, offset, type, newOffset);
            offset = newOffset[0];
            newOffset[0] = this.untranslateOffset(newOffset[0]);
            if (movement == 4 || movement == 16) {
                while (newOffset[0] > 0 && (!Compatibility.isLetterOrDigit(this.text.charAt(newOffset[0])) || Compatibility.isLetterOrDigit(this.text.charAt(newOffset[0] - 1)))) {
                    OS.ATSUPreviousCursorPosition(this.layout, offset, type, newOffset);
                    offset = newOffset[0];
                    newOffset[0] = this.untranslateOffset(newOffset[0]);
                }
            }
            if (movement == 8) {
                while (newOffset[0] > 0 && (Compatibility.isLetterOrDigit(this.text.charAt(newOffset[0])) || !Compatibility.isLetterOrDigit(this.text.charAt(newOffset[0] - 1)))) {
                    OS.ATSUPreviousCursorPosition(this.layout, offset, type, newOffset);
                    offset = newOffset[0];
                    newOffset[0] = this.untranslateOffset(newOffset[0]);
                }
            }
        }
        return newOffset[0];
    }

    public int getOffset(Point point, int[] trailing) {
        this.checkLayout();
        this.computeRuns();
        if (point == null) {
            SWT.error(4);
        }
        return this.getOffset(point.x, point.y, trailing);
    }

    public int getOffset(int x, int y, int[] trailing) {
        int length;
        this.checkLayout();
        this.computeRuns();
        if (trailing != null && trailing.length < 1) {
            SWT.error(5);
        }
        if ((length = this.text.length()) == 0) {
            return 0;
        }
        int lineY = 0;
        int start = 0;
        int lineIndex = 0;
        while (lineIndex < this.breaks.length - 1) {
            int lineBreak = this.breaks[lineIndex];
            int height = this.lineHeight[lineIndex];
            if (lineY + height > y) break;
            lineY += height;
            start = lineBreak;
            ++lineIndex;
        }
        int[] offset = new int[]{start};
        boolean[] leading = new boolean[1];
        OS.ATSUPositionToOffset(this.layout, OS.Long2Fix(x), OS.Long2Fix(y - lineY), offset, leading, null);
        if (trailing != null) {
            int n = trailing[0] = leading[0] ? 0 : 1;
        }
        if (!leading[0]) {
            offset[0] = offset[0] - 1;
        }
        int i = 0;
        while (i < this.hardBreaks.length) {
            if (offset[0] == this.hardBreaks[i]) {
                offset[0] = offset[0] + 1;
                break;
            }
            ++i;
        }
        return Math.min(this.untranslateOffset(offset[0]), length - 1);
    }

    public int getOrientation() {
        this.checkLayout();
        int[] lineDir = new int[1];
        OS.ATSUGetLayoutControl(this.layout, 3, 1, lineDir, null);
        return lineDir[0] == 1 ? 0x4000000 : 0x2000000;
    }

    public int getPreviousOffset(int index, int movement) {
        return this._getOffset(index, movement, false);
    }

    public int[] getRanges() {
        this.checkLayout();
        int[] result = new int[this.styles.length * 2];
        int count = 0;
        int i = 0;
        while (i < this.styles.length - 1) {
            if (this.styles[i].style != null) {
                result[count++] = this.styles[i].start;
                result[count++] = this.styles[i + 1].start - 1;
            }
            ++i;
        }
        if (count != result.length) {
            int[] newResult = new int[count];
            System.arraycopy(result, 0, newResult, 0, count);
            result = newResult;
        }
        return result;
    }

    public int[] getSegments() {
        this.checkLayout();
        return this.segments;
    }

    public int getSpacing() {
        this.checkLayout();
        return this.spacing;
    }

    public TextStyle getStyle(int offset) {
        this.checkLayout();
        int length = this.text.length();
        if (offset < 0 || offset >= length) {
            SWT.error(6);
        }
        int i = 1;
        while (i < this.styles.length) {
            StyleItem item = this.styles[i];
            if (item.start > offset) {
                return this.styles[i - 1].style;
            }
            ++i;
        }
        return null;
    }

    public TextStyle[] getStyles() {
        this.checkLayout();
        TextStyle[] result = new TextStyle[this.styles.length];
        int count = 0;
        int i = 0;
        while (i < this.styles.length) {
            if (this.styles[i].style != null) {
                result[count++] = this.styles[i].style;
            }
            ++i;
        }
        if (count != result.length) {
            TextStyle[] newResult = new TextStyle[count];
            System.arraycopy(result, 0, newResult, 0, count);
            result = newResult;
        }
        return result;
    }

    public int[] getTabs() {
        this.checkLayout();
        return this.tabs;
    }

    public String getText() {
        this.checkLayout();
        return this.text;
    }

    public int getWidth() {
        this.checkLayout();
        int[] buffer = new int[1];
        OS.ATSUGetLayoutControl(this.layout, 1, 4, buffer, null);
        int wrapWidth = OS.Fix2Long(buffer[0]);
        return wrapWidth == 0 ? -1 : wrapWidth;
    }

    public boolean isDisposed() {
        return this.layout == 0;
    }

    int regionToRects(int message, int rgn, int r, int context) {
        if (message == 2) {
            Rect rect = new Rect();
            OS.memmove(rect, r, 8);
            OS.CGContextMoveToPoint(context, rect.left, rect.top);
            OS.CGContextAddLineToPoint(context, rect.right, rect.top);
            OS.CGContextAddLineToPoint(context, rect.right, rect.bottom);
            OS.CGContextAddLineToPoint(context, rect.left, rect.bottom);
            OS.CGContextClosePath(context);
        }
        return 0;
    }

    public void setAlignment(int alignment) {
        this.checkLayout();
        int mask = 16924672;
        if ((alignment &= mask) == 0) {
            return;
        }
        if (alignment == this.getAlignment()) {
            return;
        }
        this.freeRuns();
        if ((alignment & 0x4000) != 0) {
            alignment = 16384;
        }
        if ((alignment & 0x20000) != 0) {
            alignment = 131072;
        }
        int align = 0;
        switch (alignment) {
            case 0x1000000: {
                align = 0x20000000;
                break;
            }
            case 131072: {
                align = 0x40000000;
            }
        }
        this.setLayoutControl(5, align, 4);
    }

    public void setAscent(int ascent) {
        this.checkLayout();
        if (ascent < -1) {
            SWT.error(5);
        }
        if (this.ascent == ascent) {
            return;
        }
        this.freeRuns();
        this.ascent = ascent;
    }

    public void setDescent(int descent) {
        this.checkLayout();
        if (descent < -1) {
            SWT.error(5);
        }
        if (this.descent == descent) {
            return;
        }
        this.freeRuns();
        this.descent = descent;
    }

    void setLayoutControl(int tag, int value, int size) {
        Object[] buffer;
        int ptr1 = OS.NewPtr(size);
        if (size == 1) {
            buffer = new byte[]{(byte)value};
            OS.memmove(ptr1, buffer, size);
        } else {
            buffer = new int[1];
            buffer[0] = value;
            OS.memmove(ptr1, (int[])buffer, size);
        }
        int[] tags = new int[]{tag};
        int[] sizes = new int[]{size};
        int[] values = new int[]{ptr1};
        OS.ATSUSetLayoutControls(this.layout, tags.length, tags, sizes, values);
        OS.DisposePtr(ptr1);
    }

    public void setFont(Font font) {
        this.checkLayout();
        if (font != null && font.isDisposed()) {
            SWT.error(5);
        }
        if (this.font == font) {
            return;
        }
        if (font != null && font.equals(this.font)) {
            return;
        }
        this.freeRuns();
        this.font = font;
    }

    public void setIndent(int indent) {
        this.checkLayout();
        if (indent < 0) {
            return;
        }
        if (this.indent == indent) {
            return;
        }
        this.freeRuns();
        this.indent = indent;
    }

    public void setJustify(boolean justify) {
        this.checkLayout();
        if (justify == this.getJustify()) {
            return;
        }
        this.freeRuns();
        this.setLayoutControl(4, justify ? 0x40000000 : 0, 4);
    }

    public void setOrientation(int orientation) {
        this.checkLayout();
        int mask = 0x6000000;
        if ((orientation &= mask) == 0) {
            return;
        }
        if ((orientation & 0x2000000) != 0) {
            orientation = 0x2000000;
        }
        if (orientation == this.getOrientation()) {
            return;
        }
        this.freeRuns();
        int lineDir = 0;
        if (orientation == 0x4000000) {
            lineDir = 1;
        }
        this.setLayoutControl(3, lineDir, 1);
    }

    public void setSegments(int[] segments) {
        this.checkLayout();
        if (this.segments == null && segments == null) {
            return;
        }
        if (this.segments != null && segments != null && this.segments.length == segments.length) {
            int i = 0;
            while (i < segments.length) {
                if (this.segments[i] != segments[i]) break;
                ++i;
            }
            if (i == segments.length) {
                return;
            }
        }
        this.freeRuns();
        this.segments = segments;
    }

    public void setSpacing(int spacing) {
        this.checkLayout();
        if (spacing < 0) {
            SWT.error(5);
        }
        if (this.spacing == spacing) {
            return;
        }
        this.freeRuns();
        this.spacing = spacing;
    }

    public void setStyle(TextStyle style, int start, int end) {
        int modifyStart;
        this.checkLayout();
        int length = this.text.length();
        if (length == 0) {
            return;
        }
        if (start > end) {
            return;
        }
        start = Math.min(Math.max(0, start), length - 1);
        end = Math.min(Math.max(0, end), length - 1);
        int low = -1;
        int high = this.styles.length;
        while (high - low > 1) {
            int index = (high + low) / 2;
            if (this.styles[index + 1].start > start) {
                high = index;
                continue;
            }
            low = index;
        }
        if (high >= 0 && high < this.styles.length) {
            StyleItem item = this.styles[high];
            if (item.start == start && this.styles[high + 1].start - 1 == end && (style == null ? item.style == null : style.equals(item.style))) {
                return;
            }
        }
        this.freeRuns();
        int modifyEnd = modifyStart = high;
        while (modifyEnd < this.styles.length) {
            if (this.styles[modifyEnd + 1].start > end) break;
            ++modifyEnd;
        }
        if (modifyStart == modifyEnd) {
            int styleStart = this.styles[modifyStart].start;
            int styleEnd = this.styles[modifyEnd + 1].start - 1;
            if (styleStart == start && styleEnd == end) {
                this.styles[modifyStart].style = style;
                return;
            }
            if (styleStart != start && styleEnd != end) {
                StyleItem[] newStyles = new StyleItem[this.styles.length + 2];
                System.arraycopy(this.styles, 0, newStyles, 0, modifyStart + 1);
                StyleItem item = new StyleItem();
                item.start = start;
                item.style = style;
                newStyles[modifyStart + 1] = item;
                item = new StyleItem();
                item.start = end + 1;
                item.style = this.styles[modifyStart].style;
                newStyles[modifyStart + 2] = item;
                System.arraycopy(this.styles, modifyEnd + 1, newStyles, modifyEnd + 3, this.styles.length - modifyEnd - 1);
                this.styles = newStyles;
                return;
            }
        }
        if (start == this.styles[modifyStart].start) {
            --modifyStart;
        }
        if (end == this.styles[modifyEnd + 1].start - 1) {
            ++modifyEnd;
        }
        int newLength = this.styles.length + 1 - (modifyEnd - modifyStart - 1);
        StyleItem[] newStyles = new StyleItem[newLength];
        System.arraycopy(this.styles, 0, newStyles, 0, modifyStart + 1);
        StyleItem item = new StyleItem();
        item.start = start;
        item.style = style;
        newStyles[modifyStart + 1] = item;
        this.styles[modifyEnd].start = end + 1;
        System.arraycopy(this.styles, modifyEnd, newStyles, modifyStart + 2, this.styles.length - modifyEnd);
        this.styles = newStyles;
    }

    public void setTabs(int[] tabs) {
        this.checkLayout();
        if (this.tabs == null && tabs == null) {
            return;
        }
        if (this.tabs != null && tabs != null && this.tabs.length == tabs.length) {
            int i = 0;
            while (i < tabs.length) {
                if (this.tabs[i] != tabs[i]) break;
                ++i;
            }
            if (i == tabs.length) {
                return;
            }
        }
        this.freeRuns();
        this.tabs = tabs;
        if (this.tabsPtr != 0) {
            OS.DisposePtr(this.tabsPtr);
        }
        this.tabsPtr = 0;
        if (tabs == null) {
            OS.ATSUSetTabArray(this.layout, 0, 0);
        } else {
            int width;
            ATSUTab tab = new ATSUTab();
            tab.tabPosition = OS.Long2Fix(0);
            int length = Math.max(32, tabs.length);
            int ptr = this.tabsPtr = OS.NewPtr(6 * length);
            int i = 0;
            int offset = ptr;
            while (i < tabs.length) {
                tab.tabType = 0;
                tab.tabPosition = OS.Long2Fix(tabs[i]);
                OS.memmove(offset, tab, 6);
                ++i;
                offset += 6;
            }
            int n = width = i - 2 >= 0 ? tabs[i - 1] - tabs[i - 2] : tabs[i - 1];
            if (width > 0) {
                while (i < length) {
                    tab.tabType = 0;
                    tab.tabPosition += OS.Long2Fix(width);
                    OS.memmove(offset, tab, 6);
                    ++i;
                    offset += 6;
                }
            }
            OS.ATSUSetTabArray(this.layout, ptr, i);
        }
    }

    public void setText(String text) {
        this.checkLayout();
        if (text == null) {
            SWT.error(4);
        }
        if (text.equals(this.text)) {
            return;
        }
        this.freeRuns();
        this.text = text;
        this.styles = new StyleItem[2];
        this.styles[0] = new StyleItem();
        this.styles[1] = new StyleItem();
        this.styles[this.styles.length - 1].start = text.length();
    }

    public void setWidth(int width) {
        this.checkLayout();
        if (width < -1 || width == 0) {
            SWT.error(5);
        }
        if (width == this.getWidth()) {
            return;
        }
        this.freeRuns();
        this.setLayoutControl(1, OS.Long2Fix(Math.max(0, width)), 4);
    }

    public String toString() {
        if (this.isDisposed()) {
            return "TextLayout {*DISPOSED*}";
        }
        return "TextLayout {" + this.layout + "}";
    }

    int translateOffset(int offset) {
        return offset + 1;
    }

    int untranslateOffset(int offset) {
        return Math.max(0, offset - 1);
    }

    static class StyleItem {
        TextStyle style;
        int start;
        int atsuStyle;

        StyleItem() {
        }

        void createStyle(Font defaultFont) {
            int ptr;
            if (this.atsuStyle != 0) {
                return;
            }
            int[] buffer = new int[1];
            OS.ATSUCreateStyle(buffer);
            this.atsuStyle = buffer[0];
            if (this.atsuStyle == 0) {
                SWT.error(2);
            }
            int length = 0;
            int ptrLength = 0;
            int index = 0;
            Font font = null;
            Color foreground = null;
            if (this.style != null) {
                font = this.style.font;
                foreground = this.style.foreground;
                if (this.style.underline) {
                    ++length;
                    ++ptrLength;
                }
                if (this.style.strikeout) {
                    ++length;
                    ++ptrLength;
                }
                if (this.style.metrics != null) {
                    length += 3;
                    ptrLength += 12;
                }
                if (this.style.rise != 0) {
                    ++length;
                    ptrLength += 4;
                }
            }
            if (font == null) {
                font = defaultFont;
            }
            boolean synthesize = false;
            if (font != null) {
                length += 2;
                ptrLength += 8;
                boolean bl = synthesize = font.style != 0;
                if (synthesize) {
                    length += 2;
                    ptrLength += 2;
                }
            }
            if (foreground != null) {
                ++length;
                ptrLength += 6;
            }
            byte[] buffer1 = new byte[1];
            int[] tags = new int[length];
            int[] sizes = new int[length];
            int[] values = new int[length];
            int ptr1 = ptr = OS.NewPtr(ptrLength);
            if (font != null) {
                buffer[0] = font.handle;
                tags[index] = 261;
                sizes[index] = 4;
                values[index] = ptr1;
                OS.memmove(values[index], buffer, sizes[index]);
                ptr1 += sizes[index];
                buffer[0] = OS.X2Fix(font.size);
                tags[++index] = 262;
                sizes[index] = 4;
                values[index] = ptr1;
                OS.memmove(values[index], buffer, sizes[index]);
                ptr1 += sizes[index];
                ++index;
                if (synthesize) {
                    buffer1[0] = (font.style & 2) != 0 ? (byte)1 : 0;
                    tags[index] = 257;
                    sizes[index] = 1;
                    values[index] = ptr1;
                    OS.memmove(values[index], buffer1, sizes[index]);
                    ptr1 += sizes[index];
                    buffer1[0] = (font.style & 1) != 0 ? (byte)1 : 0;
                    tags[++index] = 256;
                    sizes[index] = 1;
                    values[index] = ptr1;
                    OS.memmove(values[index], buffer1, sizes[index]);
                    ptr1 += sizes[index];
                    ++index;
                }
            }
            if (this.style != null && this.style.underline) {
                buffer1[0] = 1;
                tags[index] = 258;
                sizes[index] = 1;
                values[index] = ptr1;
                OS.memmove(values[index], buffer1, sizes[index]);
                ptr1 += sizes[index];
                ++index;
            }
            if (this.style != null && this.style.strikeout) {
                buffer1[0] = 1;
                tags[index] = 292;
                sizes[index] = 1;
                values[index] = ptr1;
                OS.memmove(values[index], buffer1, sizes[index]);
                ptr1 += sizes[index];
                ++index;
            }
            if (this.style != null && this.style.metrics != null) {
                GlyphMetrics metrics = this.style.metrics;
                buffer[0] = OS.Long2Fix(metrics.ascent);
                tags[index] = 284;
                sizes[index] = 4;
                values[index] = ptr1;
                OS.memmove(values[index], buffer, sizes[index]);
                ptr1 += sizes[index];
                buffer[0] = OS.Long2Fix(metrics.descent);
                tags[++index] = 285;
                sizes[index] = 4;
                values[index] = ptr1;
                OS.memmove(values[index], buffer, sizes[index]);
                ptr1 += sizes[index];
                buffer[0] = OS.Long2Fix(metrics.width);
                tags[++index] = 266;
                sizes[index] = 4;
                values[index] = ptr1;
                OS.memmove(values[index], buffer, sizes[index]);
                ptr1 += sizes[index];
                ++index;
            }
            if (this.style != null && this.style.rise != 0) {
                buffer[0] = OS.Long2Fix(this.style.rise);
                tags[index] = 269;
                sizes[index] = 4;
                values[index] = ptr1;
                OS.memmove(values[index], buffer, sizes[index]);
                ptr1 += sizes[index];
                ++index;
            }
            if (foreground != null) {
                RGBColor rgb = new RGBColor();
                float[] color = foreground.handle;
                rgb.red = (short)(color[0] * 65535.0f);
                rgb.green = (short)(color[1] * 65535.0f);
                rgb.blue = (short)(color[2] * 65535.0f);
                tags[index] = 263;
                sizes[index] = 6;
                values[index] = ptr1;
                OS.memmove(values[index], rgb, sizes[index]);
                ptr1 += sizes[index];
                ++index;
            }
            OS.ATSUSetAttributes(this.atsuStyle, tags.length, tags, sizes, values);
            OS.DisposePtr(ptr);
        }

        void freeStyle() {
            if (this.atsuStyle == 0) {
                return;
            }
            OS.ATSUDisposeStyle(this.atsuStyle);
            this.atsuStyle = 0;
        }

        public String toString() {
            return "StyleItem {" + this.start + ", " + this.style + "}";
        }
    }
}

