/*
 * Decompiled with CFR 0.152.
 */
package com.onionnetworks.fec;

import com.onionnetworks.fec.FECCode;
import com.onionnetworks.fec.FECMath;
import com.onionnetworks.fec.PureCode;
import com.onionnetworks.util.Util;

public class Pure16Code
extends PureCode {
    protected static final FECMath fecMath = new FECMath(16);

    protected void encode(byte[][] src, int[] srcOff, byte[][] repair, int[] repairOff, int[] index, int packetLength) {
        if (packetLength % 2 != 0) {
            throw new IllegalArgumentException("For 16 bit codes, buffers must be 16 bit aligned.");
        }
        char[][] srcChars = new char[src.length][];
        int[] srcCharsOff = new int[src.length];
        int numChars = packetLength / 2;
        char[] repairChars = new char[numChars];
        int i = 0;
        while (i < srcChars.length) {
            srcChars[i] = new char[numChars];
            Util.arraycopy((byte[])src[i], (int)srcOff[i], (char[])srcChars[i], (int)0, (int)packetLength);
            srcCharsOff[i] = 0;
            ++i;
        }
        i = 0;
        while (i < repair.length) {
            if (index[i] < this.k) {
                System.arraycopy(src[index[i]], srcOff[index[i]], repair[i], repairOff[i], packetLength);
            } else {
                this.encode(srcChars, srcCharsOff, repairChars, 0, index[i], numChars);
                Util.arraycopy((char[])repairChars, (int)0, (byte[])repair[i], (int)repairOff[i], (int)packetLength);
            }
            ++i;
        }
    }

    protected void encode(char[][] src, int[] srcOff, char[] repair, int repairOff, int index, int numChars) {
        int pos = index * this.k;
        Util.bzero((char[])repair, (int)repairOff, (int)numChars);
        int i = 0;
        while (i < this.k) {
            fecMath.addMul(repair, repairOff, src[i], srcOff[i], this.encMatrix[pos + i], numChars);
            ++i;
        }
    }

    protected void decode(byte[][] pkts, int[] pktsOff, int[] index, int packetLength, boolean inOrder) {
        if (packetLength % 2 != 0) {
            throw new IllegalArgumentException("For 16 bit codes, buffers must be 16 bit aligned.");
        }
        if (!inOrder) {
            FECCode.shuffle(pkts, pktsOff, index, this.k);
        }
        char[][] pktsChars = new char[pkts.length][];
        int[] pktsCharsOff = new int[pkts.length];
        int numChars = packetLength / 2;
        int i = 0;
        while (i < pktsChars.length) {
            pktsChars[i] = new char[numChars];
            Util.arraycopy((byte[])pkts[i], (int)pktsOff[i], (char[])pktsChars[i], (int)0, (int)packetLength);
            pktsCharsOff[i] = 0;
            ++i;
        }
        char[][] result = this.decode(pktsChars, pktsCharsOff, index, numChars);
        int i2 = 0;
        while (i2 < result.length) {
            if (result[i2] != null) {
                Util.arraycopy((char[])result[i2], (int)0, (byte[])pkts[i2], (int)pktsOff[i2], (int)packetLength);
                index[i2] = i2;
            }
            ++i2;
        }
    }

    protected char[][] decode(char[][] pkts, int[] pktsOff, int[] index, int numChars) {
        char[] decMatrix = fecMath.createDecodeMatrix(this.encMatrix, index, this.k, this.n);
        char[][] tmpPkts = new char[this.k][];
        int row = 0;
        while (row < this.k) {
            if (index[row] >= this.k) {
                tmpPkts[row] = new char[numChars];
                int col = 0;
                while (col < this.k) {
                    fecMath.addMul(tmpPkts[row], 0, pkts[col], pktsOff[col], decMatrix[row * this.k + col], numChars);
                    ++col;
                }
            }
            ++row;
        }
        return tmpPkts;
    }

    public String toString() {
        return new String("Pure16Code[k=" + this.k + ",n=" + this.n + "]");
    }

    public Pure16Code(int k, int n) {
        super(k, n, fecMath.createEncodeMatrix(k, n));
    }
}

