/*
 * Decompiled with CFR 0.152.
 */
package de.kapsi.net.daap.nio;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.SocketChannel;

public class DaapLineReaderNIO {
    private static final char CR = '\r';
    private static final char LF = '\n';
    private SocketChannel channel;
    private StringBuffer lineBuf;
    private int capacity;
    private boolean complete;

    public DaapLineReaderNIO(SocketChannel channel) {
        this.channel = channel;
        this.lineBuf = new StringBuffer();
    }

    public boolean isComplete() {
        return this.complete;
    }

    public String read(ByteBuffer in) throws IOException {
        String line;
        this.complete = false;
        if (in.remaining() > 0 && (line = this.line(in)) != null) {
            if (line.length() == 0) {
                return null;
            }
            return line;
        }
        in.clear();
        int len = this.channel.read(in);
        if (len < 0) {
            this.lineBuf = null;
            throw new IOException("Socket closed");
        }
        in.flip();
        String line2 = this.line(in);
        if (line2 != null && line2.length() != 0) {
            return line2;
        }
        return null;
    }

    private String line(ByteBuffer in) throws IOException {
        while (in.remaining() > 0 && this.lineBuf.length() < in.capacity()) {
            char current = (char)in.get();
            if (current == '\n') {
                int length = this.lineBuf.length();
                if (length > 0 && this.lineBuf.charAt(length - 1) == '\r') {
                    String line = this.lineBuf.toString().trim();
                    this.complete = line.length() == 0;
                    this.lineBuf = new StringBuffer();
                    return line;
                }
                this.lineBuf.append(current);
                continue;
            }
            this.lineBuf.append(current);
        }
        if (this.lineBuf.length() >= in.capacity()) {
            this.lineBuf = new StringBuffer();
            throw new IOException("Header too large");
        }
        return null;
    }
}

