/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.graph.impl;

import edu.uci.ics.jung.graph.Edge;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.KPartiteGraph;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.graph.impl.SparseGraph;
import edu.uci.ics.jung.graph.predicates.KPartiteEdgePredicate;
import edu.uci.ics.jung.utils.SubsetManager;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.functors.OnePredicate;

public class KPartiteSparseGraph
extends SparseGraph
implements KPartiteGraph {
    protected Collection partitions;

    public KPartiteSparseGraph(Collection partitions, boolean subsets) {
        if (partitions.size() < 2) {
            throw new IllegalArgumentException("Constructor must specify >= 2 vertex partition predicates");
        }
        this.partitions = partitions;
        this.getVertexConstraints().add(OnePredicate.getInstance((Collection)partitions));
        this.getEdgeConstraints().add(new KPartiteEdgePredicate(partitions));
        if (subsets) {
            SubsetManager sm = SubsetManager.getInstance(this);
            Iterator p_iter = partitions.iterator();
            while (p_iter.hasNext()) {
                sm.addVertexSubset((Predicate)p_iter.next());
            }
        }
    }

    public KPartiteSparseGraph(Graph g, Collection partitions, boolean subsets) {
        this(partitions, subsets);
        this.addAllNotInitializers(this.getEdgeConstraints(), g.getEdgeConstraints());
        this.addAllNotInitializers(this.getVertexConstraints(), g.getVertexConstraints());
        Iterator iter = g.getVertices().iterator();
        while (iter.hasNext()) {
            Vertex av = (Vertex)iter.next();
            av.copy(this);
        }
        iter = g.getEdges().iterator();
        while (iter.hasNext()) {
            Edge ae = (Edge)iter.next();
            ae.copy(this);
        }
        this.importUserData(g);
    }

    public Collection getPartitions() {
        return this.partitions;
    }
}

