/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.importance;

import edu.uci.ics.jung.algorithms.connectivity.BFSDistanceLabeler;
import edu.uci.ics.jung.algorithms.importance.PageRank;
import edu.uci.ics.jung.graph.DirectedGraph;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Vertex;
import edu.uci.ics.jung.utils.Pair;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class PageRankWithPriors
extends PageRank {
    public PageRankWithPriors(DirectedGraph graph, double beta, Set priors, String edgeWeightKeyName) {
        super(graph, beta, edgeWeightKeyName, PageRankWithPriors.computeReachableVertices(graph, priors));
        this.setPriors(priors);
        this.initializePriorWeights();
    }

    protected void initializePriorWeights() {
        Vertex currentVertex;
        Set allVertices = this.getVertices();
        Set priors = this.getPriors();
        double numPriors = priors.size();
        HashSet nonPriors = new HashSet();
        nonPriors.addAll(allVertices);
        nonPriors.removeAll(priors);
        Iterator vIt = nonPriors.iterator();
        while (vIt.hasNext()) {
            currentVertex = (Vertex)vIt.next();
            this.setPriorRankScore(currentVertex, 0.0);
        }
        vIt = this.getPriors().iterator();
        while (vIt.hasNext()) {
            currentVertex = (Vertex)vIt.next();
            this.setPriorRankScore(currentVertex, 1.0 / numPriors);
        }
    }

    private static Pair computeReachableVertices(Graph g, Set priors) {
        BFSDistanceLabeler labeler = new BFSDistanceLabeler("DISTANCE");
        labeler.labelDistances(g, priors);
        labeler.removeDecorations(g);
        Pair p = new Pair(new HashSet(labeler.getVerticesInOrderVisited()), new HashSet(labeler.getUnivistedVertices()));
        return p;
    }

    protected void reinitialize() {
        super.reinitialize();
        this.initializePriorWeights();
    }
}

