/*
 * Decompiled with CFR 0.152.
 */
package de.kapsi.net.daap.chunks;

import de.kapsi.net.daap.chunks.AbstractChunk;
import de.kapsi.net.daap.chunks.Chunk;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ContainerChunk
extends AbstractChunk
implements Iterable<Chunk> {
    protected Collection<Chunk> collection;

    protected ContainerChunk(String type, String name) {
        this(type, name, new ArrayList<Chunk>());
    }

    protected ContainerChunk(String type, String name, Collection<Chunk> collection) {
        super(type, name);
        this.collection = collection;
    }

    public void add(Chunk chunk) {
        if (chunk == null) {
            throw new IllegalArgumentException();
        }
        this.collection.add(chunk);
    }

    @Override
    public Iterator<Chunk> iterator() {
        return Collections.unmodifiableCollection(this.collection).iterator();
    }

    public int size() {
        return this.collection.size();
    }

    @Override
    public int getType() {
        return 12;
    }

    @Override
    public String toString(int indent) {
        StringBuilder buffer = new StringBuilder(ContainerChunk.indent(indent));
        buffer.append(this.name).append("(").append(this.getContentCodeString()).append("; container)\n");
        Iterator<Chunk> it = this.iterator();
        int i = 0;
        while (it.hasNext()) {
            Chunk chunk = it.next();
            buffer.append(ContainerChunk.indent(indent + 4) + chunk.toString());
            if (it.hasNext()) {
                buffer.append("\n");
            }
            ++i;
        }
        return buffer.toString();
    }
}

