/*
 * Decompiled with CFR 0.152.
 */
package com.apple.cocoa.foundation;

import java.awt.Point;

public class NSPoint
implements Cloneable {
    public static final NSPoint ZeroPoint;
    float _x = 0.0f;
    float _y = 0.0f;
    static /* synthetic */ Class class$com$apple$cocoa$foundation$NSPoint;

    public NSPoint() {
    }

    public NSPoint(float f, float f2) {
        if (f != f || f2 != f2) {
            throw new IllegalArgumentException("cannot create NSPoint with NaN x (" + f + ") or y (" + f2 + ")");
        }
        this._x = f;
        this._y = f2;
    }

    public NSPoint(Point point) {
        this(point.x, point.y);
    }

    public NSPoint(NSPoint nSPoint) {
        this(nSPoint.x(), nSPoint.y());
    }

    private static boolean is_float_char(char c) {
        return '0' <= c && c <= '9' || '+' == c || '-' == c || '.' == c;
    }

    public static NSPoint fromString(String string) {
        int n = 0;
        int n2 = string.length();
        char[] cArray = new char[n2];
        string.getChars(0, n2, cArray, 0);
        while (n < n2 && !NSPoint.is_float_char(cArray[n])) {
            ++n;
        }
        int n3 = n;
        while (n3 < n2 && NSPoint.is_float_char(cArray[n3])) {
            ++n3;
        }
        float f = new Float(string.substring(n, n3)).floatValue();
        n = n3;
        while (n < n2 && !NSPoint.is_float_char(cArray[n])) {
            ++n;
        }
        n3 = n;
        while (n3 < n2 && NSPoint.is_float_char(cArray[n3])) {
            ++n3;
        }
        float f2 = new Float(string.substring(n, n3)).floatValue();
        return new NSPoint(f, f2);
    }

    public float x() {
        return this._x;
    }

    public float y() {
        return this._y;
    }

    public float distanceToPoint(NSPoint nSPoint) {
        float f = nSPoint.x() - this.x();
        float f2 = nSPoint.y() - this.y();
        return (float)Math.sqrt(f * f + f2 * f2);
    }

    public boolean isEqualToPoint(NSPoint nSPoint) {
        return this.x() == nSPoint.x() && this.y() == nSPoint.y();
    }

    public boolean equals(Object object) {
        if (object instanceof NSPoint) {
            return this.isEqualToPoint((NSPoint)object);
        }
        return false;
    }

    public int hashCode() {
        return Math.round(this.x() + this.y());
    }

    public String toString() {
        return "{" + this.x() + ", " + this.y() + "}";
    }

    public Point toAWTPoint() {
        return new Point((int)Math.floor(this.x()), (int)Math.floor(this.y()));
    }

    public Object clone() {
        return new NSPoint(this);
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        ClassLoader classLoader = (class$com$apple$cocoa$foundation$NSPoint == null ? (class$com$apple$cocoa$foundation$NSPoint = NSPoint.class$("com.apple.cocoa.foundation.NSPoint")) : class$com$apple$cocoa$foundation$NSPoint).getClassLoader();
        try {
            if (classLoader == null) {
                Class.forName("com.apple.cocoa.foundation.NSRunLoop");
            } else {
                classLoader.loadClass("com.apple.cocoa.foundation.NSRunLoop");
            }
        }
        catch (Exception exception) {
            System.err.println("Failed to load FoundationJava.");
            exception.printStackTrace(System.err);
        }
        ZeroPoint = new NSPoint();
    }
}

