/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.conn;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.ClientConnectionOperator;
import org.apache.http.conn.ClientConnectionRequest;
import org.apache.http.conn.ManagedClientConnection;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.routing.RouteTracker;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.impl.conn.AbstractPoolEntry;
import org.apache.http.impl.conn.AbstractPooledConnAdapter;
import org.apache.http.impl.conn.DefaultClientConnectionOperator;
import org.apache.http.params.HttpParams;

public class SingleClientConnManager
implements ClientConnectionManager {
    private static final Log LOG = LogFactory.getLog(SingleClientConnManager.class);
    public static final String MISUSE_MESSAGE = "Invalid use of SingleClientConnManager: connection still allocated.\nMake sure to release the connection before allocating another one.";
    protected SchemeRegistry schemeRegistry;
    protected ClientConnectionOperator connOperator;
    protected PoolEntry uniquePoolEntry;
    protected ConnAdapter managedConn;
    protected long lastReleaseTime;
    protected boolean alwaysShutDown;
    protected volatile boolean isShutDown;

    public SingleClientConnManager(HttpParams params, SchemeRegistry schreg) {
        if (schreg == null) {
            throw new IllegalArgumentException("Scheme registry must not be null.");
        }
        this.schemeRegistry = schreg;
        this.connOperator = this.createConnectionOperator(schreg);
        this.uniquePoolEntry = new PoolEntry();
        this.managedConn = null;
        this.lastReleaseTime = -1L;
        this.alwaysShutDown = false;
        this.isShutDown = false;
    }

    protected void finalize() throws Throwable {
        this.shutdown();
        super.finalize();
    }

    public SchemeRegistry getSchemeRegistry() {
        return this.schemeRegistry;
    }

    protected ClientConnectionOperator createConnectionOperator(SchemeRegistry schreg) {
        return new DefaultClientConnectionOperator(schreg);
    }

    protected final void assertStillUp() throws IllegalStateException {
        if (this.isShutDown) {
            throw new IllegalStateException("Manager is shut down.");
        }
    }

    public final ClientConnectionRequest requestConnection(final HttpRoute route, final Object state) {
        return new ClientConnectionRequest(){

            public void abortRequest() {
            }

            public ManagedClientConnection getConnection(long timeout, TimeUnit tunit) {
                return SingleClientConnManager.this.getConnection(route, state);
            }
        };
    }

    public ManagedClientConnection getConnection(HttpRoute route, Object state) {
        if (route == null) {
            throw new IllegalArgumentException("Route may not be null.");
        }
        this.assertStillUp();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Get connection for route " + route));
        }
        if (this.managedConn != null) {
            this.revokeConnection();
        }
        boolean recreate = false;
        boolean shutdown = false;
        if (this.uniquePoolEntry.connection.isOpen()) {
            RouteTracker tracker = this.uniquePoolEntry.tracker;
            shutdown = tracker == null || !tracker.toRoute().equals(route);
        } else {
            recreate = true;
        }
        if (shutdown) {
            recreate = true;
            try {
                this.uniquePoolEntry.shutdown();
            }
            catch (IOException iox) {
                LOG.debug((Object)"Problem shutting down connection.", (Throwable)iox);
            }
        }
        if (recreate) {
            this.uniquePoolEntry = new PoolEntry();
        }
        this.managedConn = new ConnAdapter(this.uniquePoolEntry, route);
        return this.managedConn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseConnection(ManagedClientConnection conn) {
        this.assertStillUp();
        if (!(conn instanceof ConnAdapter)) {
            throw new IllegalArgumentException("Connection class mismatch, connection not obtained from this manager.");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Releasing connection " + conn));
        }
        ConnAdapter sca = (ConnAdapter)conn;
        if (sca.poolEntry == null) {
            return;
        }
        ClientConnectionManager manager = sca.getManager();
        if (manager != null && manager != this) {
            throw new IllegalArgumentException("Connection not obtained from this manager.");
        }
        try {
            if (sca.isOpen() && (this.alwaysShutDown || !sca.isMarkedReusable())) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)"Released connection open but not reusable.");
                }
                sca.shutdown();
            }
        }
        catch (IOException iox) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Exception shutting down released connection.", (Throwable)iox);
            }
        }
        finally {
            sca.detach();
            this.managedConn = null;
            this.lastReleaseTime = System.currentTimeMillis();
        }
    }

    public void closeIdleConnections(long idletime, TimeUnit tunit) {
        long cutoff;
        this.assertStillUp();
        if (tunit == null) {
            throw new IllegalArgumentException("Time unit must not be null.");
        }
        if (this.managedConn == null && this.uniquePoolEntry.connection.isOpen() && this.lastReleaseTime <= (cutoff = System.currentTimeMillis() - tunit.toMillis(idletime))) {
            try {
                this.uniquePoolEntry.close();
            }
            catch (IOException iox) {
                LOG.debug((Object)"Problem closing idle connection.", (Throwable)iox);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this.isShutDown = true;
        if (this.managedConn != null) {
            this.managedConn.detach();
        }
        try {
            if (this.uniquePoolEntry != null) {
                this.uniquePoolEntry.shutdown();
            }
        }
        catch (IOException iox) {
            LOG.debug((Object)"Problem while shutting down manager.", (Throwable)iox);
        }
        finally {
            this.uniquePoolEntry = null;
        }
    }

    protected void revokeConnection() {
        if (this.managedConn == null) {
            return;
        }
        LOG.warn((Object)MISUSE_MESSAGE);
        this.managedConn.detach();
        try {
            this.uniquePoolEntry.shutdown();
        }
        catch (IOException iox) {
            LOG.debug((Object)"Problem while shutting down connection.", (Throwable)iox);
        }
    }

    protected class ConnAdapter
    extends AbstractPooledConnAdapter {
        protected ConnAdapter(PoolEntry entry, HttpRoute route) {
            super((ClientConnectionManager)SingleClientConnManager.this, entry);
            this.markReusable();
            entry.route = route;
        }
    }

    protected class PoolEntry
    extends AbstractPoolEntry {
        protected PoolEntry() {
            super(SingleClientConnManager.this.connOperator, null);
        }

        protected void close() throws IOException {
            this.shutdownEntry();
            if (this.connection.isOpen()) {
                this.connection.close();
            }
        }

        protected void shutdown() throws IOException {
            this.shutdownEntry();
            if (this.connection.isOpen()) {
                this.connection.shutdown();
            }
        }
    }
}

