/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.statistics;

public class StatisticalMoments {
    protected double[] moments;

    public StatisticalMoments() {
        this(5);
    }

    public StatisticalMoments(int n) {
        this.moments = new double[n];
        this.reset();
    }

    public void accumulate(double x) {
        double n = this.moments[0];
        double n1 = n + 1.0;
        double n2 = n * n;
        double delta = (this.moments[1] - x) / n1;
        double d2 = delta * delta;
        double d3 = delta * d2;
        double r1 = n / n1;
        this.moments[4] = this.moments[4] + (4.0 * delta * this.moments[3] + 6.0 * d2 * this.moments[2] + (1.0 + n * n2) * d2 * d2);
        this.moments[4] = this.moments[4] * r1;
        this.moments[3] = this.moments[3] + (3.0 * delta * this.moments[2] + (1.0 - n2) * d3);
        this.moments[3] = this.moments[3] * r1;
        this.moments[2] = this.moments[2] + (1.0 + n) * d2;
        this.moments[2] = this.moments[2] * r1;
        this.moments[1] = this.moments[1] - delta;
        this.moments[0] = n1;
    }

    public double average() {
        return this.moments[1];
    }

    public long count() {
        return (long)this.moments[0];
    }

    public double errorOnAverage() {
        return Math.sqrt(this.variance() / this.moments[0]);
    }

    public double kurtosis() throws ArithmeticException {
        if (this.moments[0] < 4.0) {
            return Double.NaN;
        }
        double kFact = (this.moments[0] - 2.0) * (this.moments[0] - 3.0);
        double n1 = this.moments[0] - 1.0;
        double v = this.variance();
        return (this.moments[4] * this.moments[0] * this.moments[0] * (this.moments[0] + 1.0) / (v * v * n1) - n1 * n1 * 3.0) / kFact;
    }

    public void reset() {
        for (int n = 0; n < this.moments.length; ++n) {
            this.moments[n] = 0.0;
        }
    }

    public double skewness() throws ArithmeticException {
        if (this.moments[0] < 3.0) {
            return Double.NaN;
        }
        double v = this.variance();
        return this.moments[3] * this.moments[0] * this.moments[0] / (Math.sqrt(v) * v * (this.moments[0] - 1.0) * (this.moments[0] - 2.0));
    }

    public double standardDeviation() {
        return Math.sqrt(this.variance());
    }

    public double unnormalizedVariance() {
        return this.moments[2] * this.moments[0];
    }

    public double variance() throws ArithmeticException {
        if (this.moments[0] < 2.0) {
            return Double.NaN;
        }
        return this.unnormalizedVariance() / (this.moments[0] - 1.0);
    }
}

