/*
 * Decompiled with CFR 0.152.
 */
package de.vdheide.mp3;

import de.vdheide.mp3.ID3v2Header;
import de.vdheide.mp3.NoMP3FrameException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

public class MP3Properties {
    public static final int MODE_STEREO = 0;
    public static final int MODE_JOINT_STEREO = 1;
    public static final int MODE_DUAL_CHANNEL = 2;
    public static final int MODE_MONO = 3;
    public static final int EMPHASIS_ILLEGAL = 0;
    public static final int EMPHASIS_NONE = 1;
    public static final int EMPHASIS_5015MS = 2;
    public static final int EMPHASIS_CCITT = 3;
    protected File file;
    protected int level;
    protected int layer;
    protected int bitrate;
    protected int samplerate;
    protected int mode;
    protected int emphasis;
    protected boolean protection;
    protected boolean padding;
    protected boolean privat;
    protected boolean original;
    protected boolean copy;
    protected long length;

    public MP3Properties(File file) throws IOException, NoMP3FrameException {
        this.readProperties(file);
    }

    public int getMPEGLevel() {
        return this.level;
    }

    public int getLayer() {
        return this.layer;
    }

    public int getBitrate() {
        return this.bitrate;
    }

    public int getSamplerate() {
        return this.samplerate;
    }

    public int getMode() {
        return this.mode;
    }

    public int getEmphasis() {
        return this.emphasis;
    }

    public boolean getProtection() {
        return this.protection;
    }

    public boolean getPadding() {
        return this.padding;
    }

    public boolean getPrivate() {
        return this.privat;
    }

    public boolean getCopyright() {
        return this.copy;
    }

    public boolean getOriginal() {
        return this.original;
    }

    public long getLength() {
        return this.length;
    }

    protected void readProperties(File file) throws IOException, NoMP3FrameException {
        this.file = file;
        FileInputStream in = new FileInputStream(file);
        in.mark(15);
        int id3v2_tagsize = this.skipID3v2(in);
        if (id3v2_tagsize == 0) {
            in = new FileInputStream(file);
        }
        int second = this.synchronize(in);
        int third = in.read();
        int fourth = in.read();
        this.level = this.convertMPEGLevel(this.getBit(second, 3));
        this.layer = this.convertLayer(this.getBit(second, 2), this.getBit(second, 1));
        this.protection = this.getBit(second, 0) == 0;
        this.bitrate = this.convertBitrate(this.getBit(third, 7), this.getBit(third, 6), this.getBit(third, 5), this.getBit(third, 4));
        this.samplerate = this.convertSamplerate(this.getBit(third, 3), this.getBit(third, 2));
        this.padding = this.getBit(third, 1) == 1;
        this.privat = this.getBit(third, 0) == 1;
        this.mode = this.convertMode(this.getBit(fourth, 7), this.getBit(fourth, 6));
        this.copy = this.getBit(fourth, 3) == 1;
        this.original = this.getBit(fourth, 2) == 1;
        this.emphasis = this.convertEmphasis(this.getBit(fourth, 1), this.getBit(fourth, 0));
        this.length = this.calculateLength(id3v2_tagsize);
    }

    protected int skipID3v2(FileInputStream in) throws IOException {
        ID3v2Header header = null;
        try {
            header = new ID3v2Header(in);
        }
        catch (Exception e) {
            return 0;
        }
        in.skip(header.getTagSize());
        return header.getTagSize();
    }

    protected int synchronize(FileInputStream in) throws IOException, NoMP3FrameException {
        boolean finished = false;
        int store = 0;
        while (!finished) {
            int skip = in.read();
            while (skip != 255 && skip != -1) {
                skip = in.read();
            }
            if (skip == -1) {
                throw new NoMP3FrameException();
            }
            store = in.read();
            if (store >= 224) {
                finished = true;
                continue;
            }
            if (store != -1) continue;
            throw new NoMP3FrameException();
        }
        return store;
    }

    protected int convertMPEGLevel(int in) {
        if (in == 1) {
            return 1;
        }
        return 2;
    }

    protected int convertLayer(int in1, int in2) {
        if (in1 == 0 && in2 == 0) {
            return 0;
        }
        return 4 - ((in1 << 1) + in2);
    }

    protected int convertBitrate(int in1, int in2, int in3, int in4) {
        int[][] convert = new int[][]{{0, 0, 0, 0, 0, 0}, {32, 32, 32, 32, 32, 8}, {64, 48, 40, 64, 48, 16}, {96, 56, 48, 96, 56, 24}, {128, 64, 56, 128, 64, 32}, {160, 80, 64, 160, 80, 64}, {192, 96, 80, 192, 96, 80}, {224, 112, 96, 224, 112, 56}, {256, 128, 112, 256, 128, 64}, {288, 160, 128, 288, 160, 128}, {320, 192, 160, 320, 192, 160}, {352, 224, 192, 352, 224, 112}, {384, 256, 224, 384, 256, 128}, {416, 320, 256, 416, 320, 256}, {448, 384, 320, 448, 384, 320}, {0, 0, 0, 0, 0, 0}};
        int index1 = in1 << 3 | in2 << 2 | in3 << 1 | in4;
        int index2 = (this.level - 1) * 3 + this.layer - 1;
        return convert[index1][index2];
    }

    protected int convertSamplerate(int in1, int in2) {
        int sample = 0;
        switch (in1 << 1 | in2) {
            case 0: {
                sample = 44100;
                break;
            }
            case 1: {
                sample = 48000;
                break;
            }
            case 2: {
                sample = 32000;
                break;
            }
            case 3: {
                sample = 0;
            }
        }
        if (this.level == 1) {
            return sample;
        }
        return sample / 2;
    }

    protected int convertMode(int in1, int in2) {
        int[] convert = new int[]{0, 1, 2, 3};
        return convert[in1 << 1 | in2];
    }

    protected int convertEmphasis(int in1, int in2) {
        int[] convert = new int[]{1, 2, 0, 3};
        return convert[in1 << 1 | in2];
    }

    protected long calculateLength(int id3v2_tagsize) {
        return (long)Math.floor((double)((this.file.length() - (long)id3v2_tagsize) / (long)this.bitrate) * 0.008);
    }

    private int getBit(int input, int bit) {
        if ((input & 1 << bit) > 0) {
            return 1;
        }
        return 0;
    }
}

