/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bcel.classfile;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.bcel.Constants;
import org.apache.bcel.classfile.ConstantPool;
import org.apache.bcel.classfile.ConstantUtf8;
import org.apache.bcel.classfile.ElementValue;
import org.apache.bcel.classfile.ElementValuePair;
import org.apache.bcel.classfile.Node;
import org.apache.bcel.classfile.Visitor;

public class AnnotationEntry
implements Node,
Constants {
    private int type_index;
    private int num_element_value_pairs;
    private List element_value_pairs;
    private ConstantPool constant_pool;
    private boolean isRuntimeVisible;

    public AnnotationEntry(int type_index, ConstantPool constant_pool, boolean isRuntimeVisible) {
        this.type_index = type_index;
        this.constant_pool = constant_pool;
        this.isRuntimeVisible = isRuntimeVisible;
    }

    public static AnnotationEntry read(DataInputStream file, ConstantPool constant_pool, boolean isRuntimeVisible) throws IOException {
        AnnotationEntry annotationEntry = new AnnotationEntry(file.readUnsignedShort(), constant_pool, isRuntimeVisible);
        annotationEntry.num_element_value_pairs = file.readUnsignedShort();
        annotationEntry.element_value_pairs = new ArrayList();
        int i = 0;
        while (i < annotationEntry.num_element_value_pairs) {
            annotationEntry.element_value_pairs.add(new ElementValuePair(file.readUnsignedShort(), ElementValue.readElementValue(file, constant_pool), constant_pool));
            ++i;
        }
        return annotationEntry;
    }

    public void accept(Visitor v) {
    }

    public String getAnnotationType() {
        ConstantUtf8 c = (ConstantUtf8)this.constant_pool.getConstant(this.type_index, (byte)1);
        return c.getBytes();
    }

    public int getAnnotationTypeIndex() {
        return this.type_index;
    }

    public final int getNumElementValuePairs() {
        return this.num_element_value_pairs;
    }

    public ElementValuePair[] getElementValuePairs() {
        return this.element_value_pairs.toArray(new ElementValuePair[this.element_value_pairs.size()]);
    }

    public void dump(DataOutputStream dos) throws IOException {
        dos.writeShort(this.type_index);
        dos.writeShort(this.element_value_pairs.size());
        int i = 0;
        while (i < this.element_value_pairs.size()) {
            ElementValuePair envp = (ElementValuePair)this.element_value_pairs.get(i);
            envp.dump(dos);
            ++i;
        }
    }

    public boolean isRuntimeVisible() {
        return this.isRuntimeVisible;
    }

    public void addElementNameValuePair(ElementValuePair elementNameValuePair) {
        this.element_value_pairs.add(elementNameValuePair);
    }

    public String toShortString() {
        StringBuffer result = new StringBuffer();
        result.append("@");
        result.append(this.getAnnotationType());
        if (this.getElementValuePairs().length > 0) {
            result.append("(");
            int i = 0;
            while (i < this.getElementValuePairs().length) {
                ElementValuePair element = this.getElementValuePairs()[i];
                result.append(element.toShortString());
                ++i;
            }
            result.append(")");
        }
        return result.toString();
    }
}

