/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.swingui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Icon;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JSeparator;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import net.sourceforge.pmd.swingui.AboutPMD;
import net.sourceforge.pmd.swingui.MessageDialog;
import net.sourceforge.pmd.swingui.PMDViewer;

class HelpMenu
extends JMenu {
    protected HelpMenu() {
        super("Help");
        this.setMnemonic('H');
        Icon icon = UIManager.getIcon("help");
        JMenuItem menuItem = new JMenuItem("Online Help", icon);
        menuItem.addActionListener(new HelpActionListener());
        menuItem.setMnemonic('H');
        menuItem.setAccelerator(KeyStroke.getKeyStroke(72, 2));
        this.add(menuItem);
        this.add(new JSeparator());
        menuItem = new JMenuItem("About...");
        menuItem.addActionListener(new AboutActionListener());
        menuItem.setMnemonic('A');
        menuItem.setAccelerator(KeyStroke.getKeyStroke(65, 2));
        this.add(menuItem);
    }

    private class AboutActionListener
    implements ActionListener {
        private AboutActionListener() {
        }

        public void actionPerformed(ActionEvent event) {
            PMDViewer viewer = PMDViewer.getViewer();
            viewer.setEnableViewer(false);
            new AboutPMD(viewer).setVisible(true);
            viewer.setEnableViewer(true);
        }
    }

    private class HelpActionListener
    implements ActionListener {
        private HelpActionListener() {
        }

        public void actionPerformed(ActionEvent event) {
            MessageDialog.show(PMDViewer.getViewer(), "Online Help not available yet.");
        }
    }
}

