/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.rules.design;

import net.sourceforge.pmd.ast.SimpleNode;
import net.sourceforge.pmd.stat.DataPoint;
import net.sourceforge.pmd.stat.StatisticalRule;

public class ExcessiveNodeCountRule
extends StatisticalRule {
    private Class nodeClass;

    public ExcessiveNodeCountRule(Class nodeClass) {
        this.nodeClass = nodeClass;
    }

    public Object visit(SimpleNode node, Object data) {
        int numNodes = 0;
        int i = 0;
        while (i < node.jjtGetNumChildren()) {
            Integer treeSize = (Integer)node.jjtGetChild(i).jjtAccept(this, data);
            numNodes += treeSize.intValue();
            ++i;
        }
        if (this.nodeClass.isInstance(node)) {
            DataPoint point = new DataPoint();
            point.setLineNumber(node.getBeginLine());
            point.setScore(1.0 * (double)numNodes);
            point.setRule(this);
            point.setMessage(this.getMessage());
            this.addDataPoint(point);
        }
        return new Integer(numNodes);
    }
}

