/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.pmd.rules;

import java.text.MessageFormat;
import java.util.Stack;
import net.sourceforge.pmd.AbstractRule;
import net.sourceforge.pmd.RuleContext;
import net.sourceforge.pmd.RuleViolation;
import net.sourceforge.pmd.ast.ASTBlockStatement;
import net.sourceforge.pmd.ast.ASTConstructorDeclaration;
import net.sourceforge.pmd.ast.ASTForStatement;
import net.sourceforge.pmd.ast.ASTIfStatement;
import net.sourceforge.pmd.ast.ASTInterfaceDeclaration;
import net.sourceforge.pmd.ast.ASTMethodDeclaration;
import net.sourceforge.pmd.ast.ASTMethodDeclarator;
import net.sourceforge.pmd.ast.ASTSwitchLabel;
import net.sourceforge.pmd.ast.ASTSwitchStatement;
import net.sourceforge.pmd.ast.ASTUnmodifiedClassDeclaration;
import net.sourceforge.pmd.ast.ASTWhileStatement;
import net.sourceforge.pmd.ast.Node;
import net.sourceforge.pmd.ast.SimpleNode;

public class CyclomaticComplexityRule
extends AbstractRule {
    private Stack m_entryStack = new Stack();

    public Object visit(ASTIfStatement node, Object data) {
        Entry entry = (Entry)this.m_entryStack.peek();
        ++entry.m_decisionPoints;
        super.visit(node, data);
        return data;
    }

    public Object visit(ASTForStatement node, Object data) {
        Entry entry = (Entry)this.m_entryStack.peek();
        ++entry.m_decisionPoints;
        super.visit(node, data);
        return data;
    }

    public Object visit(ASTSwitchStatement node, Object data) {
        Entry entry = (Entry)this.m_entryStack.peek();
        int childCount = node.jjtGetNumChildren();
        int lastIndex = childCount - 1;
        int n = 0;
        while (n < lastIndex) {
            Node childNode = node.jjtGetChild(n);
            if (childNode instanceof ASTSwitchLabel && (childNode = node.jjtGetChild(n + 1)) instanceof ASTBlockStatement) {
                ++entry.m_decisionPoints;
            }
            ++n;
        }
        super.visit(node, data);
        return data;
    }

    public Object visit(ASTWhileStatement node, Object data) {
        Entry entry = (Entry)this.m_entryStack.peek();
        ++entry.m_decisionPoints;
        super.visit(node, data);
        return data;
    }

    public Object visit(ASTUnmodifiedClassDeclaration node, Object data) {
        int complexityAverage;
        this.m_entryStack.push(new Entry(node));
        super.visit(node, data);
        Entry classEntry = (Entry)this.m_entryStack.pop();
        double decisionPoints = classEntry.m_decisionPoints;
        double methodCount = classEntry.m_methodCount;
        int n = complexityAverage = methodCount == 0.0 ? 1 : (int)Math.rint(decisionPoints / methodCount);
        if (complexityAverage >= this.getIntProperty("reportLevel") || classEntry.m_highestDecisionPoints >= this.getIntProperty("reportLevel")) {
            RuleContext ruleContext = (RuleContext)data;
            String template = this.getMessage();
            String className = node.getImage();
            String complexityHighest = String.valueOf(classEntry.m_highestDecisionPoints);
            String complexity = String.valueOf(complexityAverage) + " (Highest = " + complexityHighest + ")";
            Object[] args = new String[]{"class", className, complexity};
            String message = MessageFormat.format(template, args);
            int lineNumber = node.getBeginLine();
            RuleViolation ruleViolation = this.createRuleViolation(ruleContext, lineNumber, message);
            ruleContext.getReport().addRuleViolation(ruleViolation);
        }
        return data;
    }

    public Object visit(ASTMethodDeclaration node, Object data) {
        Node parentNode = node.jjtGetParent();
        while (parentNode != null) {
            if (parentNode instanceof ASTInterfaceDeclaration) {
                return data;
            }
            parentNode = parentNode.jjtGetParent();
        }
        this.m_entryStack.push(new Entry(node));
        super.visit(node, data);
        Entry methodEntry = (Entry)this.m_entryStack.pop();
        int methodDecisionPoints = methodEntry.m_decisionPoints;
        Entry classEntry = (Entry)this.m_entryStack.peek();
        ++classEntry.m_methodCount;
        classEntry.m_decisionPoints += methodDecisionPoints;
        if (methodDecisionPoints > classEntry.m_highestDecisionPoints) {
            classEntry.m_highestDecisionPoints = methodDecisionPoints;
        }
        ASTMethodDeclarator methodDeclarator = null;
        int n = 0;
        while (n < node.jjtGetNumChildren()) {
            Node childNode = node.jjtGetChild(n);
            if (childNode instanceof ASTMethodDeclarator) {
                methodDeclarator = (ASTMethodDeclarator)childNode;
                break;
            }
            ++n;
        }
        if (methodEntry.m_decisionPoints >= this.getIntProperty("reportLevel")) {
            RuleContext ruleContext = (RuleContext)data;
            String template = this.getMessage();
            String methodName = methodDeclarator == null ? "" : methodDeclarator.getImage();
            String complexity = String.valueOf(methodEntry.m_decisionPoints);
            Object[] args = new String[]{"method", methodName, complexity};
            String message = MessageFormat.format(template, args);
            int lineNumber = node.getBeginLine();
            RuleViolation ruleViolation = this.createRuleViolation(ruleContext, lineNumber, message);
            ruleContext.getReport().addRuleViolation(ruleViolation);
        }
        return data;
    }

    public Object visit(ASTConstructorDeclaration node, Object data) {
        this.m_entryStack.push(new Entry(node));
        super.visit(node, data);
        Entry constructorEntry = (Entry)this.m_entryStack.pop();
        int constructorDecisionPointCount = constructorEntry.m_decisionPoints;
        Entry classEntry = (Entry)this.m_entryStack.peek();
        ++classEntry.m_methodCount;
        classEntry.m_decisionPoints += constructorDecisionPointCount;
        if (constructorDecisionPointCount > classEntry.m_highestDecisionPoints) {
            classEntry.m_highestDecisionPoints = constructorDecisionPointCount;
        }
        if (constructorEntry.m_decisionPoints >= this.getIntProperty("reportLevel")) {
            RuleContext ruleContext = (RuleContext)data;
            String template = this.getMessage();
            String constructorName = classEntry.m_node.getImage();
            String complexity = String.valueOf(constructorDecisionPointCount);
            Object[] args = new String[]{"constructor", constructorName, complexity};
            String message = MessageFormat.format(template, args);
            int lineNumber = node.getBeginLine();
            RuleViolation ruleViolation = this.createRuleViolation(ruleContext, lineNumber, message);
            ruleContext.getReport().addRuleViolation(ruleViolation);
        }
        return data;
    }

    private class Entry {
        private SimpleNode m_node;
        public int m_decisionPoints = 1;
        public int m_highestDecisionPoints;
        public int m_methodCount;

        private Entry(SimpleNode node) {
            this.m_node = node;
        }
    }
}

