/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.mp3;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.jaudiotagger.audio.AudioHeader;
import org.jaudiotagger.audio.exceptions.InvalidAudioFrameException;
import org.jaudiotagger.audio.mp3.MPEGFrameHeader;
import org.jaudiotagger.audio.mp3.XingFrame;

public final class MP3AudioHeader
implements AudioHeader {
    private MPEGFrameHeader mp3FrameHeader;
    private XingFrame mp3XingFrame;
    private long fileSize;
    private long startByte;
    private double timePerFrame;
    private double trackLength;
    private long numberOfFrames;
    private long numberOfFramesEstimate;
    private long bitrate;
    private String encoder = "";
    private static final SimpleDateFormat timeInFormat = new SimpleDateFormat("ss");
    private static final SimpleDateFormat timeOutFormat = new SimpleDateFormat("mm:ss");
    private static final char isVbrIdentifier = '~';
    private static final int CONVERT_TO_KILOBITS = 1000;
    private static final String TYPE_MP3 = "mp3";
    private static final int CONVERTS_BYTE_TO_BITS = 8;
    private static final int FILE_BUFFER_SIZE = 5000;
    private static final int MIN_BUFFER_REMAINING_REQUIRED = 196;

    public MP3AudioHeader(File seekFile) throws IOException, InvalidAudioFrameException {
        if (!this.seek(seekFile, 0L)) {
            throw new InvalidAudioFrameException("No audio header found within" + seekFile.getName());
        }
    }

    public MP3AudioHeader(File seekFile, long startByte) throws IOException, InvalidAudioFrameException {
        if (!this.seek(seekFile, startByte)) {
            throw new InvalidAudioFrameException("No audio header found within" + seekFile.getName());
        }
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean seek(File seekFile, long startByte) throws IOException {
        block24: {
            fis = new FileInputStream(seekFile);
            fc = fis.getChannel();
            bb = ByteBuffer.allocateDirect(5000);
            fc.position(startByte);
            filePointerCount = startByte;
            fc.read(bb, startByte);
            bb.flip();
            syncFound = false;
            while (true) {
                block23: {
                    try {
                        if (bb.remaining() <= 196) {
                            bb.clear();
                            fc.position(filePointerCount);
                            fc.read(bb, fc.position());
                            bb.flip();
                            if (bb.limit() <= 196) {
                                if (fc == null) break block23;
                            }
                        }
                        ** GOTO lbl-1000
                    }
                    catch (EOFException ex) {
                        syncFound = false;
                        if (fc != null) {
                            fc.close();
                        }
                        if (fis != null) {
                            fis.close();
                        }
                        break block24;
                    }
                    catch (IOException iox) {
                        try {
                            syncFound = false;
                            throw iox;
                        }
                        catch (Throwable var11_12) {
                            if (fc != null) {
                                fc.close();
                            }
                            if (fis != null) {
                                fis.close();
                            }
                            throw var11_12;
                        }
                    }
                    fc.close();
                }
                if (fis != null) {
                    fis.close();
                }
                return false;
lbl-1000:
                // 1 sources

                {
                    if (MPEGFrameHeader.isMPEGFrame(bb)) {
                        try {
                            this.mp3FrameHeader = MPEGFrameHeader.parseMPEGHeader(bb);
                            syncFound = true;
                            if (XingFrame.isXingFrame(bb, this.mp3FrameHeader)) {
                                try {
                                    this.mp3XingFrame = XingFrame.parseXingFrame();
                                }
                                catch (InvalidAudioFrameException var10_9) {}
                                break;
                            }
                        }
                        catch (InvalidAudioFrameException var10_8) {
                            // empty catch block
                        }
                    }
                    bb.position(bb.position() + 1);
                    ++filePointerCount;
                    if (!syncFound) continue;
                }
                break;
            }
            if (fc != null) {
                fc.close();
            }
            if (fis != null) {
                fis.close();
            }
        }
        this.setFileSize(seekFile.length());
        this.setMp3StartByte(filePointerCount);
        this.setTimePerFrame();
        this.setNumberOfFrames();
        this.setTrackLength();
        this.setBitRate();
        this.setEncoder();
        return syncFound;
    }

    private void setMp3StartByte(long startByte) {
        this.startByte = startByte;
    }

    public long getMp3StartByte() {
        return this.startByte;
    }

    private void setNumberOfFrames() {
        this.numberOfFramesEstimate = (this.fileSize - this.startByte) / (long)this.mp3FrameHeader.getFrameLength();
        this.numberOfFrames = this.mp3XingFrame != null && this.mp3XingFrame.isFrameCountEnabled() ? (long)this.mp3XingFrame.getFrameCount() : this.numberOfFramesEstimate;
    }

    public long getNumberOfFrames() {
        return this.numberOfFrames;
    }

    public long getNumberOfFramesEstimate() {
        return this.numberOfFramesEstimate;
    }

    private void setTimePerFrame() {
        this.timePerFrame = (double)this.mp3FrameHeader.getNoOfSamples() / this.mp3FrameHeader.getSamplingRate().doubleValue();
        if (!(this.mp3FrameHeader.getVersion() != 2 && this.mp3FrameHeader.getVersion() != 0 || this.mp3FrameHeader.getLayer() != 2 && this.mp3FrameHeader.getLayer() != 1)) {
            this.timePerFrame /= 2.0;
        }
    }

    private double getTimePerFrame() {
        return this.timePerFrame;
    }

    private void setTrackLength() {
        this.trackLength = (double)this.numberOfFrames * this.getTimePerFrame();
    }

    public double getPreciseTrackLength() {
        return this.trackLength;
    }

    public int getTrackLength() {
        return (int)this.getPreciseTrackLength();
    }

    public String getTrackLengthAsString() {
        try {
            long lengthInSecs = this.getTrackLength();
            Date timeIn = timeInFormat.parse(String.valueOf(lengthInSecs));
            return timeOutFormat.format(timeIn);
        }
        catch (ParseException pe) {
            return "";
        }
    }

    public String getEncodingType() {
        return TYPE_MP3;
    }

    private void setBitRate() {
        this.bitrate = this.mp3XingFrame != null && this.mp3XingFrame.isVbr() ? (this.mp3XingFrame.isAudioSizeEnabled() && this.mp3XingFrame.getAudioSize() > 0 ? (long)((double)(this.mp3XingFrame.getAudioSize() * 8) / (this.timePerFrame * (double)this.getNumberOfFrames() * 1000.0)) : (long)((double)((this.fileSize - this.startByte) * 8L) / (this.timePerFrame * (double)this.getNumberOfFrames() * 1000.0))) : (long)this.mp3FrameHeader.getBitRate().intValue();
    }

    private void setEncoder() {
        if (this.mp3XingFrame != null && this.mp3XingFrame.getLameFrame() != null) {
            this.encoder = this.mp3XingFrame.getLameFrame().getEncoder();
            return;
        }
    }

    public long getBitRateAsNumber() {
        return this.bitrate;
    }

    public String getBitRate() {
        if (this.mp3XingFrame != null && this.mp3XingFrame.isVbr()) {
            return String.valueOf('~') + String.valueOf(this.bitrate);
        }
        return String.valueOf(this.bitrate);
    }

    public int getSampleRateAsNumber() {
        return this.mp3FrameHeader.getSamplingRate();
    }

    public String getSampleRate() {
        return String.valueOf(this.mp3FrameHeader.getSamplingRate());
    }

    public String getMpegVersion() {
        return this.mp3FrameHeader.getVersionAsString();
    }

    public String getMpegLayer() {
        return this.mp3FrameHeader.getLayerAsString();
    }

    public String getFormat() {
        return String.valueOf(this.mp3FrameHeader.getVersionAsString()) + " " + this.mp3FrameHeader.getLayerAsString();
    }

    public String getChannels() {
        return this.mp3FrameHeader.getChannelModeAsString();
    }

    public String getEmphasis() {
        return this.mp3FrameHeader.getEmphasisAsString();
    }

    public boolean isVariableBitRate() {
        if (this.mp3XingFrame != null) {
            return this.mp3XingFrame.isVbr();
        }
        return this.mp3FrameHeader.isVariableBitRate();
    }

    public boolean isProtected() {
        return this.mp3FrameHeader.isProtected();
    }

    public boolean isPrivate() {
        return this.mp3FrameHeader.isPrivate();
    }

    public boolean isCopyrighted() {
        return this.mp3FrameHeader.isCopyrighted();
    }

    public boolean isOriginal() {
        return this.mp3FrameHeader.isOriginal();
    }

    public boolean isPadding() {
        return this.mp3FrameHeader.isPadding();
    }

    public String getEncoder() {
        return this.encoder;
    }

    private void setFileSize(long fileSize) {
        this.fileSize = fileSize;
    }

    public String toString() {
        String s = "fileSize:" + this.fileSize + " encoder:" + this.encoder + " startByte:" + this.startByte + " numberOfFrames:" + this.numberOfFrames + " numberOfFramesEst:" + this.numberOfFramesEstimate + " timePerFrame:" + this.timePerFrame + " bitrate:" + this.bitrate + " trackLength:" + this.getTrackLengthAsString();
        if (this.mp3FrameHeader != null) {
            s = String.valueOf(s) + this.mp3FrameHeader.toString();
        }
        if (this.mp3XingFrame != null) {
            s = String.valueOf(s) + this.mp3XingFrame.toString();
        }
        return s;
    }
}

