/*
 * Decompiled with CFR 0.152.
 */
package phex.common.address;

public class AddressUtils {
    public static final int[] CIDR2MASK = new int[]{0, Integer.MIN_VALUE, -1073741824, -536870912, -268435456, -134217728, -67108864, -33554432, -16777216, -8388608, -4194304, -2097152, -1048576, -524288, -262144, -131072, -65536, Short.MIN_VALUE, -16384, -8192, -4096, -2048, -1024, -512, -256, -128, -64, -32, -16, -8, -4, -2, -1};

    public static String ip2string(byte[] byArray) {
        if (byArray == null) {
            throw new NullPointerException("Ip is null!");
        }
        assert (byArray.length == 4);
        return (byArray[0] & 0xFF) + "." + (byArray[1] & 0xFF) + "." + (byArray[2] & 0xFF) + "." + (byArray[3] & 0xFF);
    }

    public static String ip2string(int n) {
        return (n >> 24 & 0xFF) + "." + (n >> 16 & 0xFF) + "." + (n >> 8 & 0xFF) + "." + (n & 0xFF);
    }

    public static boolean isIPHostName(String string) {
        int n = string.indexOf(58);
        if (n != -1) {
            string = string.substring(0, n);
        }
        char[] cArray = string.toCharArray();
        int n2 = 0;
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            if (c < '0' || c > '9') {
                return false;
            }
            while (c != '.') {
                if (c < '0' || c > '9') {
                    return false;
                }
                if (++i >= cArray.length) break;
                c = cArray[i];
            }
            ++n2;
        }
        return n2 == 4 && !string.endsWith(".");
    }

    public static byte[] parseIntIP(String string) {
        long l = Long.parseLong(string);
        byte[] byArray = new byte[]{(byte)(l >>> 24 & 0xFFL), (byte)(l >>> 16 & 0xFFL), (byte)(l >>> 8 & 0xFFL), (byte)(l & 0xFFL)};
        return byArray;
    }

    public static int parseNetmaskToInt(String string) {
        if (string.indexOf(46) == -1) {
            try {
                int n = Integer.parseInt(string);
                if (n == 32) {
                    return -1;
                }
                if (n >= 0) {
                    return ~(-1 >>> n);
                }
                throw new IllegalArgumentException("Invalid netmask: " + string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException("Invalid netmask: " + string);
            }
        }
        return AddressUtils.parseDottedIpToInt(string);
    }

    public static byte parseNetmaskToCidr(String string) {
        if (string.indexOf(46) == -1) {
            try {
                byte by = Byte.parseByte(string);
                if (by >= 0) {
                    return by;
                }
                throw new IllegalArgumentException("Invalid netmask: " + string);
            }
            catch (NumberFormatException numberFormatException) {
                throw new IllegalArgumentException("Invalid netmask: " + string);
            }
        }
        return AddressUtils.calculateCidr(AddressUtils.parseDottedIpToInt(string));
    }

    public static int parseDottedIpToInt(String string) {
        int n = string.indexOf(58);
        String string2 = n != -1 ? string.substring(0, n) : string;
        char[] cArray = string2.toCharArray();
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < cArray.length; ++i) {
            char c = cArray[i];
            if (c < '0' || c > '9') {
                throw new IllegalArgumentException("IP contains character: " + string2 + " - org: " + string);
            }
            int n4 = 0;
            while (c != '.') {
                if (c < '0' || c > '9') {
                    throw new IllegalArgumentException("IP contains character: " + string2);
                }
                n4 = n4 * 10 + c - 48;
                if (++i >= cArray.length) break;
                c = cArray[i];
            }
            if (n4 > 255) {
                throw new IllegalArgumentException("Bogus ip value: " + string2);
            }
            n2 = (n2 << 8) + n4;
            ++n3;
        }
        if (n3 != 4 || string2.endsWith(".")) {
            throw new IllegalArgumentException("Bogus ip: " + string2);
        }
        return n2;
    }

    public static byte[] parseIP(String string) {
        try {
            int n = AddressUtils.parseDottedIpToInt(string);
            byte[] byArray = new byte[]{(byte)(n >>> 24 & 0xFF), (byte)(n >>> 16 & 0xFF), (byte)(n >>> 8 & 0xFF), (byte)(n & 0xFF)};
            return byArray;
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return null;
        }
    }

    public static int parsePort(String string) {
        char c;
        int n = string.indexOf(58);
        if (n == -1) {
            return -1;
        }
        String string2 = string.substring(n + 1);
        char[] cArray = string2.toCharArray();
        int n2 = 0;
        for (int i = 0; i < cArray.length && (c = cArray[i]) >= '0' && c <= '9'; ++i) {
            n2 = n2 * 10 + c - 48;
        }
        if (!AddressUtils.isPortInRange(n2)) {
            return -1;
        }
        return n2;
    }

    public static String toIntValueString(byte[] byArray) {
        int n = byArray[3] & 0xFF;
        int n2 = byArray[2] << 8 & 0xFF00;
        int n3 = byArray[1] << 16 & 0xFF0000;
        int n4 = byArray[0] << 24;
        long l = (long)(n4 | n3 | n2 | n) & 0xFFFFFFFFL;
        return String.valueOf(l);
    }

    public static int byteIpToIntIp(byte[] byArray) {
        int n = byArray[3] & 0xFF;
        int n2 = byArray[2] << 8 & 0xFF00;
        int n3 = byArray[1] << 16 & 0xFF0000;
        int n4 = byArray[0] << 24;
        int n5 = (n4 | n3 | n2 | n) & 0xFFFFFFFF;
        return n5;
    }

    public static byte[] intIp2ByteIp(int n) {
        byte[] byArray = new byte[]{(byte)(n >>> 24 & 0xFF), (byte)(n >>> 16 & 0xFF), (byte)(n >>> 8 & 0xFF), (byte)(n & 0xFF)};
        return byArray;
    }

    public static boolean isPortInRange(int n) {
        return (n & 0xFFFF0000) == 0 && n != 0;
    }

    public static byte calculateCidr(int n) {
        byte by = 0;
        by = (byte)(by + AddressUtils.cidrByteToNBits((byte)(n >>> 24 & 0xFF)));
        by = (byte)(by + AddressUtils.cidrByteToNBits((byte)(n >>> 16 & 0xFF)));
        by = (byte)(by + AddressUtils.cidrByteToNBits((byte)(n >>> 8 & 0xFF)));
        by = (byte)(by + AddressUtils.cidrByteToNBits((byte)(n & 0xFF)));
        return by;
    }

    private static byte cidrByteToNBits(byte by) {
        switch (by) {
            case -1: {
                return 8;
            }
            case -2: {
                return 7;
            }
            case -4: {
                return 6;
            }
            case -8: {
                return 5;
            }
            case -16: {
                return 4;
            }
            case -32: {
                return 3;
            }
            case -64: {
                return 2;
            }
            case -128: {
                return 1;
            }
            case 0: {
                return 0;
            }
        }
        throw new IllegalArgumentException("Invalid byte value");
    }

    public static byte calculateCidr(byte[] byArray) {
        int n = AddressUtils.byteIpToIntIp(byArray);
        return AddressUtils.calculateCidr(n);
    }
}

