/*
 * Decompiled with CFR 0.152.
 */
package phex.common;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import phex.common.address.AddressUtils;
import phex.utils.IOUtil;

public class Ip2CountryDB {
    private boolean isLoaded = false;
    private List<IpCountryRange> ipCountryRangeList = new ArrayList<IpCountryRange>();

    private Ip2CountryDB() {
        this.loadIp2CountryDB();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadIp2CountryDB() {
        FileInputStream fileInputStream;
        try {
            fileInputStream = new FileInputStream("ip2language.csv");
        }
        catch (FileNotFoundException fileNotFoundException) {
            return;
        }
        if (fileInputStream == null) {
            return;
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(fileInputStream));
        ArrayList<IpCountryRange> arrayList = new ArrayList<IpCountryRange>(5000);
        try {
            String string = bufferedReader.readLine();
            while (string != null) {
                IpCountryRange ipCountryRange = new IpCountryRange(string);
                arrayList.add(ipCountryRange);
                string = bufferedReader.readLine();
            }
        }
        catch (IOException iOException) {
        }
        finally {
            IOUtil.closeQuietly(bufferedReader);
        }
        arrayList.trimToSize();
        Collections.sort(arrayList);
        this.ipCountryRangeList = Collections.unmodifiableList(arrayList);
        this.isLoaded = true;
    }

    private IpCountryRange binarySearch(byte[] byArray) {
        int n = 0;
        int n2 = this.ipCountryRangeList.size() - 1;
        while (n <= n2) {
            int n3 = n + n2 >> 1;
            IpCountryRange ipCountryRange = this.ipCountryRangeList.get(n3);
            int n4 = ipCountryRange.compareHostAddress(byArray);
            if (n4 < 0) {
                n = n3 + 1;
                continue;
            }
            if (n4 > 0) {
                n2 = n3 - 1;
                continue;
            }
            return ipCountryRange;
        }
        return null;
    }

    public String getIP2Language(String string, String string2) {
        if (string == null || string.equals("")) {
            return string2;
        }
        byte[] byArray = AddressUtils.parseIP(string);
        if (byArray == null) {
            return string2;
        }
        IpCountryRange ipCountryRange = this.binarySearch(byArray);
        return ipCountryRange != null ? ipCountryRange.countryCode : string2;
    }

    public static Ip2CountryDB getInstance() {
        return Holder.manager;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class IpCountryRange
    implements Comparable<IpCountryRange> {
        byte[] from;
        byte[] to;
        String countryCode;

        public IpCountryRange(String string) {
            int n = 0;
            int n2 = string.indexOf(44, n);
            this.from = AddressUtils.parseIntIP(string.substring(n, n2));
            n = n2 + 1;
            n2 = string.indexOf(44, n);
            this.to = AddressUtils.parseIntIP(string.substring(n, n2));
            n = n2 + 1;
            String string2 = string.substring(n);
            this.countryCode = string2.intern();
        }

        public int compareHostAddress(byte[] byArray) {
            long l;
            long l2 = IOUtil.unsignedInt2Long(IOUtil.deserializeInt(byArray, 0));
            long l3 = l2 - (l = IOUtil.unsignedInt2Long(IOUtil.deserializeInt(this.from, 0)));
            if (l3 == 0L) {
                return 0;
            }
            if (l3 < 0L) {
                return 1;
            }
            long l4 = IOUtil.unsignedInt2Long(IOUtil.deserializeInt(this.to, 0));
            l3 = l2 - l4;
            if (l3 == 0L || l3 < 0L) {
                return 0;
            }
            return -1;
        }

        @Override
        public int compareTo(IpCountryRange ipCountryRange) {
            long l;
            if (ipCountryRange == this) {
                return 0;
            }
            byte[] byArray = this.from;
            byte[] byArray2 = ipCountryRange.from;
            long l2 = IOUtil.unsignedInt2Long(IOUtil.deserializeInt(byArray, 0));
            if (l2 < (l = IOUtil.unsignedInt2Long(IOUtil.deserializeInt(byArray2, 0)))) {
                return -1;
            }
            return 1;
        }
    }

    private static class Holder {
        protected static final Ip2CountryDB manager = new Ip2CountryDB();

        private Holder() {
        }
    }
}

