/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.util;

import java.awt.Component;
import java.io.File;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.util.CommonUtils;
import org.limewire.util.OSUtils;

public class SystemUtils {
    private static final Log LOG;
    private static boolean isLoaded;

    private SystemUtils() {
    }

    public static long getIdleTime() {
        if (SystemUtils.supportsIdleTime()) {
            return SystemUtils.idleTime();
        }
        return 0L;
    }

    public static boolean supportsIdleTime() {
        if (isLoaded) {
            if (OSUtils.isGoodWindows()) {
                return true;
            }
            if (OSUtils.isMacOSX()) {
                return true;
            }
        }
        return false;
    }

    public static long setOpenFileLimit(int n) {
        if (isLoaded && OSUtils.isMacOSX()) {
            return SystemUtils.setOpenFileLimit0(n);
        }
        return -1L;
    }

    static void setWriteable(String string) {
        if (isLoaded && (OSUtils.isWindows() || OSUtils.isMacOSX())) {
            SystemUtils.setFileWriteable(string);
        }
    }

    private static final native int setOpenFileLimit0(int var0);

    public static final String getRunningPath() {
        if (OSUtils.isWindows() && isLoaded) {
            String string = SystemUtils.getRunningPathNative();
            if (string.equals("")) {
                return null;
            }
            return string;
        }
        return null;
    }

    public static final String getSpecialPath(SpecialLocations specialLocations) {
        if (OSUtils.isWindows()) {
            if (specialLocations == SpecialLocations.HOME) {
                return CommonUtils.getUserHomeDir().getPath();
            }
            if (isLoaded) {
                try {
                    String string = SystemUtils.getSpecialPathNative(specialLocations.getName());
                    if (!string.equals("")) {
                        return string;
                    }
                    return null;
                }
                catch (UnsatisfiedLinkError unsatisfiedLinkError) {
                    LOG.error((Object)"Unable to use getSpecialPath!", (Throwable)unsatisfiedLinkError);
                    return null;
                }
            }
            return null;
        }
        if (OSUtils.isPOSIX()) {
            if (specialLocations == SpecialLocations.HOME) {
                return CommonUtils.getUserHomeDir().getPath();
            }
            if (specialLocations == SpecialLocations.DOCUMENTS) {
                return new File(CommonUtils.getUserHomeDir(), specialLocations.getName()).getPath();
            }
            if (specialLocations == SpecialLocations.DESKTOP) {
                return new File(CommonUtils.getUserHomeDir(), specialLocations.getName()).getPath();
            }
            return null;
        }
        return null;
    }

    public static final boolean setWindowIcon(Component component, File file) {
        if (OSUtils.isWindows() && isLoaded) {
            String string = SystemUtils.setWindowIconNative(component, System.getProperty("sun.boot.library.path"), file.getPath());
            return string.equals("");
        }
        return false;
    }

    public static final boolean setWindowTopMost(Component component) {
        if (isLoaded && OSUtils.isWindows()) {
            String string = SystemUtils.setWindowTopMostNative(component, System.getProperty("sun.boot.library.path"));
            return string.equals("");
        }
        return false;
    }

    public static final boolean flushIconCache() {
        if (isLoaded && OSUtils.isWindows()) {
            return SystemUtils.flushIconCacheNative();
        }
        return false;
    }

    public static final int registryReadNumber(String string, String string2, String string3) throws IOException {
        if (OSUtils.isWindows() && isLoaded) {
            return SystemUtils.registryReadNumberNative(string, string2, string3);
        }
        throw new IOException(" not supported ");
    }

    public static final String registryReadText(String string, String string2, String string3) throws IOException {
        if (OSUtils.isWindows() && isLoaded) {
            return SystemUtils.registryReadTextNative(string, string2, string3);
        }
        throw new IOException(" not supported ");
    }

    public static final boolean registryWriteNumber(String string, String string2, String string3, int n) {
        if (OSUtils.isWindows() && isLoaded) {
            return SystemUtils.registryWriteNumberNative(string, string2, string3, n);
        }
        return false;
    }

    public static final boolean registryWriteText(String string, String string2, String string3, String string4) {
        if (OSUtils.isWindows() && isLoaded) {
            return SystemUtils.registryWriteTextNative(string, string2, string3, string4);
        }
        return false;
    }

    public static final boolean registryDelete(String string, String string2) {
        if (OSUtils.isWindows() && isLoaded) {
            return SystemUtils.registryDeleteNative(string, string2);
        }
        return false;
    }

    public static final boolean isFirewallPresent() {
        if (OSUtils.isWindows() && isLoaded) {
            return SystemUtils.firewallPresentNative();
        }
        return false;
    }

    public static final boolean isFirewallEnabled() {
        if (OSUtils.isWindows() && isLoaded) {
            return SystemUtils.firewallEnabledNative();
        }
        return false;
    }

    public static final boolean isFirewallExceptionsNotAllowed() {
        if (OSUtils.isWindows() && isLoaded) {
            return SystemUtils.firewallExceptionsNotAllowedNative();
        }
        return false;
    }

    public static final boolean isProgramListedOnFirewall(String string) {
        if (OSUtils.isWindows() && isLoaded) {
            return SystemUtils.firewallIsProgramListedNative(string);
        }
        return false;
    }

    public static final boolean isProgramEnabledOnFirewall(String string) {
        if (OSUtils.isWindows() && isLoaded) {
            return SystemUtils.firewallIsProgramEnabledNative(string);
        }
        return false;
    }

    public static final boolean addProgramToFirewall(String string, String string2) {
        if (OSUtils.isWindows() && isLoaded) {
            return SystemUtils.firewallAddNative(string, string2);
        }
        return false;
    }

    public static final boolean removeProgramFromFirewall(String string) {
        if (OSUtils.isWindows() && isLoaded) {
            return SystemUtils.firewallRemoveNative(string);
        }
        return false;
    }

    public static int openURL(String string) throws IOException {
        if (OSUtils.isWindows() && isLoaded) {
            SystemUtils.openURLNative(string);
            return 0;
        }
        throw new IOException("native code not linked");
    }

    public static int openFile(String string) throws IOException {
        if (OSUtils.isWindows() && isLoaded) {
            SystemUtils.openFileNative(string);
            return 0;
        }
        throw new IOException("native code not linked");
    }

    public static int openFile(String string, String string2) throws IOException {
        if (OSUtils.isWindows() && isLoaded) {
            SystemUtils.openFileParamsNative(string, string2);
            return 0;
        }
        throw new IOException("native code not linked");
    }

    public static boolean recycle(File file) {
        if (OSUtils.isWindows() && isLoaded) {
            String string = null;
            try {
                string = file.getCanonicalPath();
            }
            catch (IOException iOException) {
                LOG.error((Object)"IOException", (Throwable)iOException);
                string = file.getAbsolutePath();
            }
            return SystemUtils.recycleNative(string);
        }
        return false;
    }

    public static String getDefaultExtentionHandler(String string) {
        if (!OSUtils.isWindows() || !isLoaded) {
            return null;
        }
        if (!string.startsWith(".")) {
            string = "." + string;
        }
        try {
            String string2 = SystemUtils.registryReadText("HKEY_CLASSES_ROOT", string, "");
            if ("".equals(string2)) {
                return "";
            }
            return SystemUtils.registryReadText("HKEY_CLASSES_ROOT", string2 + "\\shell\\open\\command", "");
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static String getDefaultMimeHandler(String string) {
        if (!OSUtils.isWindows() || !isLoaded) {
            return null;
        }
        String string2 = "";
        try {
            string2 = SystemUtils.registryReadText("HKEY_CLASSES_ROOT", "MIME\\Database\\Content Type\\" + string, "Extension");
        }
        catch (IOException iOException) {
            return null;
        }
        if ("".equals(string2)) {
            return "";
        }
        return SystemUtils.getDefaultExtentionHandler(string2);
    }

    private static final native String getRunningPathNative();

    private static final native String getSpecialPathNative(String var0);

    private static final native void openURLNative(String var0);

    private static final native void openFileNative(String var0);

    private static final native void openFileParamsNative(String var0, String var1);

    private static final native boolean recycleNative(String var0);

    private static final native int setFileWriteable(String var0);

    private static final native long idleTime();

    private static final native String setWindowIconNative(Component var0, String var1, String var2);

    private static final native String setWindowTopMostNative(Component var0, String var1);

    private static final native boolean flushIconCacheNative();

    private static final native int registryReadNumberNative(String var0, String var1, String var2) throws IOException;

    private static final native String registryReadTextNative(String var0, String var1, String var2) throws IOException;

    private static final native boolean registryWriteNumberNative(String var0, String var1, String var2, int var3);

    private static final native boolean registryWriteTextNative(String var0, String var1, String var2, String var3);

    private static final native boolean registryDeleteNative(String var0, String var1);

    private static final native boolean firewallPresentNative();

    private static final native boolean firewallEnabledNative();

    private static final native boolean firewallExceptionsNotAllowedNative();

    private static final native boolean firewallIsProgramListedNative(String var0);

    private static final native boolean firewallIsProgramEnabledNative(String var0);

    private static final native boolean firewallAddNative(String var0, String var1);

    private static final native boolean firewallRemoveNative(String var0);

    static {
        boolean bl;
        LOG = LogFactory.getLog(SystemUtils.class);
        try {
            if (OSUtils.isWindows()) {
                if (OSUtils.isGoodWindows()) {
                    System.loadLibrary("SystemUtilities");
                } else {
                    System.loadLibrary("SystemUtilitiesA");
                }
            } else if (OSUtils.isMacOSX()) {
                if (OSUtils.isMacOSX105()) {
                    System.loadLibrary("SystemUtilitiesLeopard");
                } else {
                    System.loadLibrary("SystemUtilitiesTiger");
                }
            }
            bl = true;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            bl = false;
        }
        isLoaded = bl;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum SpecialLocations {
        HOME("Home"),
        DOCUMENTS("Documents"),
        APPLICATION_DATA("ApplicationData"),
        DESKTOP("Desktop"),
        START_MENU("StartMenu"),
        START_MENU_PROGRAMS("StartMenuPrograms"),
        START_MENU_STARTUP("StartMenuStartup");

        private final String name;

        private SpecialLocations(String string2) {
            this.name = string2;
        }

        public String getName() {
            return this.name;
        }

        public static SpecialLocations parse(String string) {
            for (SpecialLocations specialLocations : SpecialLocations.values()) {
                if (!specialLocations.getName().equals(string)) continue;
                return specialLocations;
            }
            return null;
        }
    }
}

