/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.util;

public class DebugRunnable
implements Runnable {
    private final Exception creationTime = new Exception("Debug Exception Creation");
    private final Runnable delegate;

    public DebugRunnable(Runnable runnable) {
        this.delegate = runnable;
        StackTraceElement[] stackTraceElementArray = this.creationTime.getStackTrace();
        StackTraceElement[] stackTraceElementArray2 = new StackTraceElement[stackTraceElementArray.length - 1];
        System.arraycopy(stackTraceElementArray, 1, stackTraceElementArray2, 0, stackTraceElementArray2.length);
        this.creationTime.setStackTrace(stackTraceElementArray2);
    }

    public final void run() {
        try {
            this.delegate.run();
        }
        catch (Throwable throwable) {
            if (throwable.getCause() == null) {
                throwable.initCause(this.creationTime);
            } else {
                StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
                StackTraceElement[] stackTraceElementArray2 = this.creationTime.getStackTrace();
                StackTraceElement[] stackTraceElementArray3 = new StackTraceElement[stackTraceElementArray.length + stackTraceElementArray2.length];
                System.arraycopy(stackTraceElementArray, 0, stackTraceElementArray3, 0, stackTraceElementArray.length);
                System.arraycopy(stackTraceElementArray2, 0, stackTraceElementArray3, stackTraceElementArray.length, stackTraceElementArray2.length);
                throwable.setStackTrace(stackTraceElementArray3);
            }
            if (throwable instanceof Error) {
                throw (Error)throwable;
            }
            if (throwable instanceof RuntimeException) {
                throw (RuntimeException)throwable;
            }
            throw new RuntimeException(throwable);
        }
    }
}

