/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.util;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;

public class BufferUtils {
    private static final ByteBuffer EMPTY_BUFFER = ByteBuffer.allocate(0);

    public static ByteBuffer getEmptyBuffer() {
        return EMPTY_BUFFER;
    }

    public static long delete(ByteBuffer byteBuffer, long l) {
        if ((long)byteBuffer.position() <= l) {
            l -= (long)byteBuffer.position();
            byteBuffer.clear();
        } else {
            byteBuffer.flip();
            byteBuffer.position((int)l);
            byteBuffer.compact();
            l = 0L;
        }
        return l;
    }

    public static int readAll(ByteBuffer byteBuffer, ReadableByteChannel readableByteChannel, ByteBuffer byteBuffer2) throws IOException {
        BufferUtils.transfer(byteBuffer, byteBuffer2, true);
        int n = 0;
        while (byteBuffer2.hasRemaining() && (n = readableByteChannel.read(byteBuffer2)) > 0) {
        }
        return n;
    }

    public static int transfer(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) {
        return BufferUtils.transfer(byteBuffer, byteBuffer2, true);
    }

    public static int transfer(ByteBuffer byteBuffer, ByteBuffer byteBuffer2, boolean bl) {
        int n = 0;
        if (byteBuffer != null) {
            if (bl) {
                if (byteBuffer.position() > 0) {
                    byteBuffer.flip();
                    n = BufferUtils.doTransfer(byteBuffer, byteBuffer2);
                    if (byteBuffer.hasRemaining()) {
                        byteBuffer.compact();
                    } else {
                        byteBuffer.clear();
                    }
                }
            } else if (byteBuffer.hasRemaining()) {
                n = BufferUtils.doTransfer(byteBuffer, byteBuffer2);
            }
        }
        return n;
    }

    public static long transfer(ByteBuffer byteBuffer, ByteBuffer[] byteBufferArray, int n, int n2, boolean bl) {
        long l = 0L;
        for (int i = n; i < n + n2; ++i) {
            l += (long)BufferUtils.transfer(byteBuffer, byteBufferArray[i], bl);
        }
        return l;
    }

    private static int doTransfer(ByteBuffer byteBuffer, ByteBuffer byteBuffer2) {
        int n = 0;
        int n2 = byteBuffer.remaining();
        int n3 = byteBuffer2.remaining();
        if (n3 >= n2) {
            byteBuffer2.put(byteBuffer);
            n += n2;
        } else {
            int n4 = byteBuffer.limit();
            int n5 = byteBuffer.position();
            byteBuffer.limit(n5 + n3);
            byteBuffer2.put(byteBuffer);
            n += n3;
            byteBuffer.limit(n4);
        }
        return n;
    }

    public static boolean readLine(ByteBuffer byteBuffer, StringBuilder stringBuilder) {
        int n = -1;
        block4: while (byteBuffer.hasRemaining()) {
            n = byteBuffer.get();
            switch (n) {
                case 10: {
                    return true;
                }
                case 13: {
                    continue block4;
                }
            }
            stringBuilder.append((char)n);
        }
        return false;
    }

    public static int transfer(ByteBuffer byteBuffer, StringBuilder stringBuilder) {
        int n = 0;
        while (byteBuffer.hasRemaining()) {
            stringBuilder.append((char)byteBuffer.get());
            ++n;
        }
        return n;
    }
}

