/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.statistic;

import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StatsUtils {
    private StatsUtils() {
    }

    public static DoubleStats quickStatsDouble(List<Double> list) {
        DoubleStats doubleStats = new DoubleStats();
        doubleStats.number = list.size();
        if (doubleStats.number < 2) {
            return doubleStats;
        }
        Collections.sort(list);
        doubleStats.min = list.get(0);
        doubleStats.max = list.get(list.size() - 1);
        doubleStats.med = StatsUtils.getQuartile(Quartile.MED, list);
        if (doubleStats.number > 6) {
            doubleStats.q1 = StatsUtils.getQuartile(Quartile.Q1, list);
            doubleStats.q3 = StatsUtils.getQuartile(Quartile.Q3, list);
        }
        double d = list.get(0);
        double d2 = list.get(0);
        int n = 0;
        int n2 = 0;
        for (int i = 1; i < list.size(); ++i) {
            if (list.get(i) == d2) {
                ++n2;
            } else {
                d2 = list.get(i);
                n2 = 0;
            }
            if (n2 <= n) continue;
            n = n2;
            d = d2;
        }
        doubleStats.mode = d;
        double d3 = 0.0;
        for (double d4 : list) {
            d3 += d4;
        }
        doubleStats.avg = d3 / (double)list.size();
        d3 = 0.0;
        double d5 = 0.0;
        double d6 = 0.0;
        for (double d7 : list) {
            if (d7 > doubleStats.avg) {
                doubleStats.st += 1.0;
            }
            double d8 = d7 - doubleStats.avg;
            double d9 = d8 * d8;
            double d10 = d9 * d8;
            d3 += d9;
            d5 += d10;
            d6 += d9 * d9;
        }
        int n3 = list.size() - 1;
        doubleStats.m2 = d3 / (double)n3;
        doubleStats.m3 = d5 / (double)n3;
        doubleStats.m4 = d6 / (double)n3;
        double[] dArray = StatsUtils.swilk(list);
        if (dArray != null) {
            doubleStats.swilkW = dArray[0];
            doubleStats.swilkPW = dArray[1];
        }
        return doubleStats;
    }

    private static double getQuartile(Quartile quartile, List<Double> list) {
        int n;
        double d = (double)(list.size() + 1) * ((double)quartile.getType() / 4.0);
        if (d - (double)(n = (int)d) == 0.0) {
            return list.get(n - 1);
        }
        double d2 = list.get(n - 1);
        double d3 = list.get(n);
        d3 -= d2;
        d3 = d3 * (double)quartile.getType() / 4.0;
        return d2 + d3;
    }

    public static List<Integer> getHistogram(List<Double> list, int n) {
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(0);
        }
        double d = Collections.min(list);
        double d2 = Collections.max(list) - d + 1.0;
        double d3 = d2 / (double)n;
        for (double d4 : list) {
            int n2 = Math.min((int)((d4 - d) / d3), n - 1);
            arrayList.set(n2, (Integer)arrayList.get(n2) + 1);
        }
        return arrayList;
    }

    public static List<Integer> getHistogramBigInt(List<BigInteger> list, int n) {
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Integer> arrayList = new ArrayList<Integer>(n);
        for (int i = 0; i < n; ++i) {
            arrayList.add(0);
        }
        BigInteger bigInteger = Collections.min(list);
        BigInteger bigInteger2 = Collections.max(list);
        BigInteger bigInteger3 = bigInteger2.subtract(bigInteger).add(BigInteger.valueOf(1L));
        BigInteger bigInteger4 = bigInteger3.divide(BigInteger.valueOf(n));
        if (bigInteger4.equals(BigInteger.ZERO)) {
            return Collections.emptyList();
        }
        for (BigInteger bigInteger5 : list) {
            int n2 = bigInteger5.subtract(bigInteger).divide(bigInteger4).intValue();
            n2 = Math.min(n2, n - 1);
            arrayList.set(n2, (Integer)arrayList.get(n2) + 1);
        }
        return arrayList;
    }

    public static List<Double> rank(List<Double> list) {
        if (list.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<Double> arrayList = new ArrayList<Double>(list.size());
        if (list.size() == 1) {
            arrayList.add(1.0);
            return arrayList;
        }
        Collections.sort(list);
        int n = 0;
        while (n < list.size()) {
            double d = list.get(n);
            double d2 = 0.0;
            int n2 = n;
            while (n2 < list.size() && list.get(n2) == d) {
                d2 += (double)(++n2);
            }
            if (n2 == n + 1) {
                arrayList.add(Double.valueOf(++n));
                continue;
            }
            d2 /= (double)(n2 - n);
            do {
                arrayList.add(d2);
            } while (++n < n2);
        }
        return arrayList;
    }

    public static double[] swilk(List<Double> list) {
        if (list.size() < 3) {
            return null;
        }
        Collections.sort(list);
        double[] dArray = new double[list.size() + 1];
        for (int i = 1; i < dArray.length; ++i) {
            dArray[i] = list.get(i - 1);
        }
        boolean[] blArray = new boolean[1];
        double[] dArray2 = new double[list.size() + 1];
        double[] dArray3 = new double[1];
        double[] dArray4 = new double[1];
        int[] nArray = new int[]{-1};
        SWilk.swilk(blArray, dArray, list.size(), list.size(), list.size() / 2, dArray2, dArray3, dArray4, nArray);
        if (nArray[0] != 0 && nArray[0] != 2) {
            return null;
        }
        return new double[]{dArray3[0], dArray4[0]};
    }

    private static class SWilk {
        private static final double[] C1 = new double[]{Double.NaN, 0.0, 0.221157, -0.147981, -2.07119, 4.434685, -2.706056};
        private static final double[] C2 = new double[]{Double.NaN, 0.0, 0.042981, -0.293762, -1.752461, 5.682633, -3.582633};
        private static final double[] C3 = new double[]{Double.NaN, 0.544, -0.39978, 0.025054, -6.714E-4};
        private static final double[] C4 = new double[]{Double.NaN, 1.3822, -0.77857, 0.062767, -0.0020322};
        private static final double[] C5 = new double[]{Double.NaN, -1.5861, -0.31082, -0.083751, 0.0038915};
        private static final double[] C6 = new double[]{Double.NaN, -0.4803, -0.082676, 0.0030302};
        private static final double[] C7 = new double[]{Double.NaN, 0.164, 0.533};
        private static final double[] C8 = new double[]{Double.NaN, 0.1736, 0.315};
        private static final double[] C9 = new double[]{Double.NaN, 0.256, -0.00635};
        private static final double[] G = new double[]{Double.NaN, -2.273, 0.459};
        private static final double Z90 = 1.2816;
        private static final double Z95 = 1.6449;
        private static final double Z99 = 2.3263;
        private static final double ZM = 1.7509;
        private static final double ZSS = 0.56268;
        private static final double BF1 = 0.8378;
        private static final double XX90 = 0.556;
        private static final double XX95 = 0.622;
        private static final double SQRTH = 0.70711;
        private static final double TH = 0.375;
        private static final double SMALL = 1.0E-19;
        private static final double PI6 = 1.909859;
        private static final double STQR = 1.047198;
        private static final boolean UPPER = true;
        private static final double A0_p = 3.3871327179;
        private static final double A1_p = 50.434271938;
        private static final double A2_p = 159.29113202;
        private static final double A3_p = 59.10937472;
        private static final double B1_p = 17.895169469;
        private static final double B2_p = 78.757757664;
        private static final double B3_p = 67.1875636;
        private static final double C0_p = 1.4234372777;
        private static final double C1_p = 2.75681539;
        private static final double C2_p = 1.3067284816;
        private static final double C3_p = 0.17023821103;
        private static final double D1_p = 0.7370016425;
        private static final double D2_p = 0.12021132975;
        private static final double E0_p = 6.657905115;
        private static final double E1_p = 3.081226386;
        private static final double E2_p = 0.42868294337;
        private static final double E3_p = 0.017337203997;
        private static final double F1_p = 0.24197894225;
        private static final double F2_p = 0.012258202635;
        private static final double SPLIT1 = 0.425;
        private static final double SPLIT2 = 5.0;
        private static final double CONST1 = 0.180625;
        private static final double CONST2 = 1.6;
        private static final double CON_a = 1.28;
        private static final double LTONE_a = 7.0;
        private static final double UTZERO_a = 18.66;
        private static final double P_a = 0.398942280444;
        private static final double Q_a = 0.39990348504;
        private static final double R_a = 0.398942280385;
        private static final double A1_a = 5.75885480458;
        private static final double A2_a = 2.62433121679;
        private static final double A3_a = 5.92885724438;
        private static final double B1_a = -29.8213557807;
        private static final double B2_a = 48.6959930692;
        private static final double C1_a = -3.8052E-8;
        private static final double C2_a = 3.98064794E-4;
        private static final double C3_a = -0.151679116635;
        private static final double C4_a = 4.8385912808;
        private static final double C5_a = 0.742380924027;
        private static final double C6_a = 3.99019417011;
        private static final double D1_a = 1.00000615302;
        private static final double D2_a = 1.98615381364;
        private static final double D3_a = 5.29330324926;
        private static final double D4_a = -15.1508972451;
        private static final double D5_a = 30.789933034;

        private SWilk() {
        }

        private static void swilk(boolean[] blArray, double[] dArray, int n, int n2, int n3, double[] dArray2, double[] dArray3, double[] dArray4, int[] nArray) {
            double d;
            double d2;
            double d3;
            double d4;
            double d5;
            double d6;
            int n4;
            double d7;
            dArray4[0] = 1.0;
            if (dArray3[0] >= 0.0) {
                dArray3[0] = 1.0;
            }
            double d8 = n;
            nArray[0] = 3;
            int n5 = n / 2;
            if (n3 < n5) {
                return;
            }
            nArray[0] = 1;
            if (n < 3) {
                return;
            }
            if (!blArray[0]) {
                if (n == 3) {
                    dArray2[1] = 0.70711;
                } else {
                    int n6;
                    double d9 = d8 + 0.25;
                    double d10 = 0.0;
                    for (int i = 1; i <= n3; ++i) {
                        dArray2[i] = SWilk.ppnd(((double)i - 0.375) / d9);
                        d10 += dArray2[i] * dArray2[i];
                    }
                    double d11 = Math.sqrt(d10 *= 2.0);
                    double d12 = 1.0 / Math.sqrt(d8);
                    double d13 = SWilk.poly(C1, 6, d12) - dArray2[1] / d11;
                    if (n > 5) {
                        n6 = 3;
                        double d14 = -dArray2[2] / d11 + SWilk.poly(C2, 6, d12);
                        d7 = Math.sqrt((d10 - 2.0 * dArray2[1] * dArray2[1] - 2.0 * dArray2[2] * dArray2[2]) / (1.0 - 2.0 * d13 * d13 - 2.0 * d14 * d14));
                        dArray2[1] = d13;
                        dArray2[2] = d14;
                    } else {
                        n6 = 2;
                        d7 = Math.sqrt((d10 - 2.0 * dArray2[1] * dArray2[1]) / (1.0 - 2.0 * d13 * d13));
                        dArray2[1] = d13;
                    }
                    for (n4 = n6; n4 <= n5; ++n4) {
                        dArray2[n4] = -dArray2[n4] / d7;
                    }
                }
                blArray[0] = true;
            }
            if (n2 < 3) {
                return;
            }
            int n7 = n - n2;
            nArray[0] = 4;
            if (n7 < 0 || n7 > 0 && n < 20) {
                return;
            }
            nArray[0] = 5;
            double d15 = (double)n7 / d8;
            if (d15 > 0.8) {
                return;
            }
            if (dArray3[0] < 0.0) {
                d6 = 1.0 + dArray3[0];
                nArray[0] = 0;
            } else {
                nArray[0] = 6;
                d5 = dArray[n2] - dArray[1];
                if (d5 < 1.0E-19) {
                    return;
                }
                nArray[0] = 7;
                d3 = d4 = dArray[1] / d5;
                d7 = -dArray2[1];
                n4 = n - 1;
                for (int i = 2; i <= n2; ++i) {
                    d2 = dArray[i] / d5;
                    d3 += d2;
                    if (i != n4) {
                        d7 += (double)SWilk.sign(1, i - n4) * dArray2[Math.min(i, n4)];
                    }
                    d4 = d2;
                    --n4;
                }
                nArray[0] = 0;
                if (n > 5000) {
                    nArray[0] = 2;
                }
                d7 /= (double)n2;
                d3 /= (double)n2;
                double d16 = 0.0;
                double d17 = 0.0;
                double d18 = 0.0;
                n4 = n;
                for (int i = 1; i <= n2; ++i) {
                    double d19 = i != n4 ? (double)SWilk.sign(1, i - n4) * dArray2[Math.min(i, n4)] - d7 : -d7;
                    d = dArray[i] / d5 - d3;
                    d16 += d19 * d19;
                    d17 += d * d;
                    d18 += d19 * d;
                    --n4;
                }
                double d20 = Math.sqrt(d16 * d17);
                d6 = (d20 - d18) * (d20 + d18) / (d16 * d17);
            }
            dArray3[0] = 1.0 - d6;
            if (n == 3) {
                dArray4[0] = 1.909859 * (Math.asin(Math.sqrt(dArray3[0])) - 1.047198);
                return;
            }
            d5 = Math.log(d6);
            d4 = Math.log(d8);
            d3 = 0.0;
            d7 = 1.0;
            if (n <= 11) {
                double d21 = SWilk.poly(G, 2, d8);
                if (d5 >= d21) {
                    dArray4[0] = 1.0E-19;
                    return;
                }
                d5 = -Math.log(d21 - d5);
                d3 = SWilk.poly(C3, 4, d8);
                d7 = Math.exp(SWilk.poly(C4, 4, d8));
            } else {
                d3 = SWilk.poly(C5, 4, d4);
                d7 = Math.exp(SWilk.poly(C6, 3, d4));
            }
            if (n7 > 0) {
                double d22 = -Math.log(d15);
                d2 = 1.0 + d4 * 0.8378;
                double d23 = 1.2816 + d2 * Math.pow(SWilk.poly(C7, 2, Math.pow(0.556, d4)), d22);
                double d24 = 1.6449 + d2 * Math.pow(SWilk.poly(C8, 2, Math.pow(0.622, d4)), d22);
                double d25 = 2.3263 + d2 * Math.pow(SWilk.poly(C9, 2, d4), d22);
                d = (d23 + d24 + d25) / 3.0;
                double d26 = (1.2816 * (d23 - d) + 1.6449 * (d24 - d) + 2.3263 * (d25 - d)) / 0.56268;
                double d27 = d - d26 * 1.7509;
                d3 += d27 * d7;
                d7 *= d26;
            }
            dArray4[0] = SWilk.alnorm((d5 - d3) / d7, true);
        }

        private static int sign(int n, int n2) {
            int n3 = Math.abs(n);
            if ((double)n2 < 0.0) {
                n3 = -n3;
            }
            return n3;
        }

        private static double ppnd(double d) {
            double d2 = d - 0.5;
            if (Math.abs(d2) <= 0.425) {
                double d3 = 0.180625 - d2 * d2;
                return d2 * (((59.10937472 * d3 + 159.29113202) * d3 + 50.434271938) * d3 + 3.3871327179) / (((67.1875636 * d3 + 78.757757664) * d3 + 17.895169469) * d3 + 1.0);
            }
            double d4 = d2 < 0.0 ? d : 1.0 - d;
            if (d4 <= 0.0) {
                return 0.0;
            }
            double d5 = (d4 = Math.sqrt(-Math.log(d4))) <= 5.0 ? (((0.17023821103 * (d4 -= 1.6) + 1.3067284816) * d4 + 2.75681539) * d4 + 1.4234372777) / ((0.12021132975 * d4 + 0.7370016425) * d4 + 1.0) : (((0.017337203997 * (d4 -= 5.0) + 0.42868294337) * d4 + 3.081226386) * d4 + 6.657905115) / ((0.012258202635 * d4 + 0.24197894225) * d4 + 1.0);
            if (d2 < 0.0) {
                d5 = -d5;
            }
            return d5;
        }

        private static double poly(double[] dArray, int n, double d) {
            double d2 = dArray[1];
            if (n == 1) {
                return d2;
            }
            double d3 = d * dArray[n];
            if (n != 2) {
                int n2 = n - 2;
                int n3 = n2 + 1;
                for (int i = 1; i <= n2; ++i) {
                    d3 = (d3 + dArray[n3]) * d;
                    --n3;
                }
            }
            return d2 += d3;
        }

        private static double alnorm(double d, boolean bl) {
            double d2;
            boolean bl2 = bl;
            double d3 = d;
            if (d3 < 0.0) {
                bl2 = !bl2;
                d3 = -d3;
            }
            if (d3 > 7.0 && (!bl2 || d3 > 18.66)) {
                d2 = 0.0;
            } else {
                double d4 = 0.5 * d3 * d3;
                d2 = d3 <= 1.28 ? 0.5 - d3 * (0.398942280444 - 0.39990348504 * d4 / (d4 + 5.75885480458 + -29.8213557807 / (d4 + 2.62433121679 + 48.6959930692 / (d4 + 5.92885724438)))) : 0.398942280385 * Math.exp(-d4) / (d3 + -3.8052E-8 + 1.00000615302 / (d3 + 3.98064794E-4 + 1.98615381364 / (d3 + -0.151679116635 + 5.29330324926 / (d3 + 4.8385912808 + -15.1508972451 / (d3 + 0.742380924027 + 30.789933034 / (d3 + 3.99019417011))))));
            }
            if (!bl2) {
                d2 = 1.0 - d2;
            }
            return d2;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DoubleStats
    extends Stats {
        public double min;
        public double max;
        public double med;
        public double q1;
        public double q3;
        public double avg;
        public double m2;
        public double m3;
        public double m4;
        public double mode;
        public double st;
        public double swilkW;
        public double swilkPW;

        DoubleStats() {
        }

        @Override
        protected void addAnySpecifics(Map<String, Object> map) {
            map.put("swilkW", this.doubleToBytes(this.swilkW));
            map.put("swilkPW", this.doubleToBytes(this.swilkPW));
        }

        @Override
        public Object getMin() {
            return this.doubleToBytes(this.min);
        }

        @Override
        public Object getMax() {
            return this.doubleToBytes(this.max);
        }

        @Override
        public Object getMed() {
            return this.doubleToBytes(this.med);
        }

        @Override
        public Object getQ1() {
            return this.doubleToBytes(this.q1);
        }

        @Override
        public Object getQ3() {
            return this.doubleToBytes(this.q3);
        }

        @Override
        public Object getAvg() {
            return this.doubleToBytes(this.avg);
        }

        @Override
        public Object getM2() {
            return this.doubleToBytes(this.m2);
        }

        @Override
        public Object getM3() {
            return this.doubleToBytes(this.m3);
        }

        @Override
        public Object getM4() {
            return this.doubleToBytes(this.m4);
        }

        @Override
        public Object getMode() {
            return this.doubleToBytes(this.mode);
        }

        @Override
        public Object getST() {
            return this.doubleToBytes(this.st);
        }

        private byte[] doubleToBytes(double d) {
            byte[] byArray = new byte[4];
            int n = Float.floatToIntBits((float)d);
            byArray[0] = (byte)(n >>> 24);
            byArray[1] = (byte)(n >>> 16);
            byArray[2] = (byte)(n >>> 8);
            byArray[3] = (byte)(n >>> 0);
            return byArray;
        }

        public static double bytesToDouble(byte[] byArray) {
            if (byArray == null) {
                return Double.NaN;
            }
            DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream(byArray));
            try {
                if (byArray.length == 4) {
                    return dataInputStream.readFloat();
                }
                return dataInputStream.readDouble();
            }
            catch (IOException iOException) {
                return Double.NaN;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class Stats {
        private static final int VERSION = 1;
        int number;

        public final Map<String, Object> getMap() {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("ver", 1);
            hashMap.put("num", this.number);
            if (this.number < 2) {
                return hashMap;
            }
            hashMap.put("min", this.getMin());
            hashMap.put("max", this.getMax());
            hashMap.put("med", this.getMed());
            hashMap.put("avg", this.getAvg());
            hashMap.put("M2", this.getM2());
            hashMap.put("M3", this.getM3());
            hashMap.put("M4", this.getM4());
            hashMap.put("mode", this.getMode());
            hashMap.put("st", this.getST());
            if (this.number > 6) {
                hashMap.put("Q1", this.getQ1());
                hashMap.put("Q3", this.getQ3());
            }
            this.addAnySpecifics(hashMap);
            return hashMap;
        }

        protected void addAnySpecifics(Map<String, Object> map) {
        }

        public final Map<String, Object> getTTestMap() {
            HashMap<String, Object> hashMap = new HashMap<String, Object>();
            hashMap.put("ver", 1);
            hashMap.put("num", this.number);
            if (this.number < 2) {
                return hashMap;
            }
            hashMap.put("avg", this.getAvg());
            hashMap.put("M2", this.getM2());
            return hashMap;
        }

        public final int getNumber() {
            return this.number;
        }

        public abstract Object getMin();

        public abstract Object getMax();

        public abstract Object getMed();

        public abstract Object getAvg();

        public abstract Object getQ1();

        public abstract Object getQ3();

        public abstract Object getM2();

        public abstract Object getM3();

        public abstract Object getM4();

        public abstract Object getMode();

        public abstract Object getST();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum Quartile {
        Q1(1),
        MED(2),
        Q3(3);

        private final int type;

        private Quartile(int n2) {
            this.type = n2;
        }

        public int getType() {
            return this.type;
        }
    }
}

