/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.statistic;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.limewire.lifecycle.Service;
import org.limewire.statistic.Statistic;
import org.limewire.statistic.StatisticAccumulator;

@Singleton
final class StatisticsAccumulatorImpl
implements StatisticAccumulator,
Service {
    private final ScheduledExecutorService backgroundExecutor;
    private volatile ScheduledFuture<?> scheduledFuture;
    private final List<Statistic> basicStatistics = new CopyOnWriteArrayList<Statistic>();

    @Inject
    StatisticsAccumulatorImpl(@Named(value="backgroundExecutor") ScheduledExecutorService scheduledExecutorService) {
        this.backgroundExecutor = scheduledExecutorService;
    }

    public void initialize() {
    }

    public void start() {
        if (this.scheduledFuture != null) {
            throw new IllegalStateException("already started!");
        }
        this.scheduledFuture = this.backgroundExecutor.scheduleWithFixedDelay(new Runner(), 0L, 1000L, TimeUnit.MILLISECONDS);
    }

    public void stop() {
        ScheduledFuture<?> scheduledFuture = this.scheduledFuture;
        if (scheduledFuture != null) {
            scheduledFuture.cancel(false);
            this.scheduledFuture = null;
        }
    }

    public void addBasicStatistic(Statistic statistic) {
        this.basicStatistics.add(statistic);
    }

    private class Runner
    implements Runnable {
        private Runner() {
        }

        public void run() {
            for (Statistic statistic : StatisticsAccumulatorImpl.this.basicStatistics) {
                statistic.storeCurrentStat();
            }
        }
    }
}

