/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.setting;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.Executor;
import org.limewire.concurrent.ExecutorsHelper;
import org.limewire.setting.SettingsGroup;
import org.limewire.setting.evt.SettingsGroupManagerEvent;
import org.limewire.setting.evt.SettingsGroupManagerListener;

public final class SettingsGroupManager {
    private static final SettingsGroupManager INSTANCE = new SettingsGroupManager();
    private final Collection<SettingsGroup> PROPS = Collections.synchronizedList(new ArrayList());
    private Collection<SettingsGroupManagerListener> listeners;
    private volatile Executor executor = ExecutorsHelper.newFixedSizeThreadPool(1, "SettingsHandlerEventDispatcher");

    public static SettingsGroupManager instance() {
        return INSTANCE;
    }

    private SettingsGroupManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addSettingsHandlerListener(SettingsGroupManagerListener settingsGroupManagerListener) {
        if (settingsGroupManagerListener == null) {
            throw new NullPointerException("SettingsGroupManagerListener is null");
        }
        SettingsGroupManager settingsGroupManager = this;
        synchronized (settingsGroupManager) {
            if (this.listeners == null) {
                this.listeners = new ArrayList<SettingsGroupManagerListener>();
            }
            this.listeners.add(settingsGroupManagerListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeSettingsHandlerListener(SettingsGroupManagerListener settingsGroupManagerListener) {
        if (settingsGroupManagerListener == null) {
            throw new NullPointerException("SettingsGroupManagerListener is null");
        }
        SettingsGroupManager settingsGroupManager = this;
        synchronized (settingsGroupManager) {
            if (this.listeners != null) {
                this.listeners.remove(settingsGroupManagerListener);
                if (this.listeners.isEmpty()) {
                    this.listeners = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SettingsGroupManagerListener[] getSettingsHandlerListeners() {
        SettingsGroupManager settingsGroupManager = this;
        synchronized (settingsGroupManager) {
            if (this.listeners == null) {
                return null;
            }
            return this.listeners.toArray(new SettingsGroupManagerListener[0]);
        }
    }

    public void addSettingsGroup(SettingsGroup settingsGroup) {
        this.PROPS.add(settingsGroup);
        this.fireSettingsHandlerEvent(SettingsGroupManagerEvent.EventType.SETTINGS_GROUP_ADDED, settingsGroup);
    }

    public void removeSettingsGroup(SettingsGroup settingsGroup) {
        if (this.PROPS.remove(settingsGroup)) {
            this.fireSettingsHandlerEvent(SettingsGroupManagerEvent.EventType.SETTINGS_GROUP_REMOVED, settingsGroup);
        }
    }

    public SettingsGroup[] getSettingsGroups() {
        return this.PROPS.toArray(new SettingsGroup[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reload() {
        Collection<SettingsGroup> collection = this.PROPS;
        synchronized (collection) {
            for (SettingsGroup settingsGroup : this.PROPS) {
                settingsGroup.reload();
            }
        }
        this.fireSettingsHandlerEvent(SettingsGroupManagerEvent.EventType.RELOAD, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean save() {
        boolean bl = false;
        Collection<SettingsGroup> collection = this.PROPS;
        synchronized (collection) {
            for (SettingsGroup settingsGroup : this.PROPS) {
                bl |= settingsGroup.save();
            }
        }
        if (bl) {
            this.fireSettingsHandlerEvent(SettingsGroupManagerEvent.EventType.SAVE, null);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean revertToDefault() {
        boolean bl = false;
        Collection<SettingsGroup> collection = this.PROPS;
        synchronized (collection) {
            for (SettingsGroup settingsGroup : this.PROPS) {
                bl |= settingsGroup.revertToDefault();
            }
        }
        if (bl) {
            this.fireSettingsHandlerEvent(SettingsGroupManagerEvent.EventType.REVERT_TO_DEFAULT, null);
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setShouldSave(boolean bl) {
        Collection<SettingsGroup> collection = this.PROPS;
        synchronized (collection) {
            for (SettingsGroup settingsGroup : this.PROPS) {
                settingsGroup.setShouldSave(bl);
            }
        }
        this.fireSettingsHandlerEvent(SettingsGroupManagerEvent.EventType.SHOULD_SAVE, null);
    }

    protected void fireSettingsHandlerEvent(SettingsGroupManagerEvent.EventType eventType, SettingsGroup settingsGroup) {
        this.fireSettingsHandlerEvent(new SettingsGroupManagerEvent(eventType, this, settingsGroup));
    }

    protected void fireSettingsHandlerEvent(final SettingsGroupManagerEvent settingsGroupManagerEvent) {
        if (settingsGroupManagerEvent == null) {
            throw new NullPointerException("SettingsHandlerEvent is null");
        }
        final SettingsGroupManagerListener[] settingsGroupManagerListenerArray = this.getSettingsHandlerListeners();
        if (settingsGroupManagerListenerArray != null) {
            Runnable runnable = new Runnable(){

                public void run() {
                    for (SettingsGroupManagerListener settingsGroupManagerListener : settingsGroupManagerListenerArray) {
                        settingsGroupManagerListener.handleGroupManagerEvent(settingsGroupManagerEvent);
                    }
                }
            };
            this.execute(runnable);
        }
    }

    protected void execute(Runnable runnable) {
        this.executor.execute(runnable);
    }

    public void setExecutor(Executor executor) {
        if (executor == null) {
            throw new NullPointerException("Executor is null");
        }
        this.executor = executor;
    }
}

