/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.setting;

import java.util.BitSet;
import java.util.Properties;
import org.limewire.setting.AbstractSetting;
import org.limewire.util.StringUtils;

public class PBooleanArraySetting
extends AbstractSetting {
    private volatile BitSet values = new BitSet();
    private volatile int size;

    public PBooleanArraySetting(Properties properties, Properties properties2, String string, String[] stringArray) {
        super(properties, properties2, string, PBooleanArraySetting.decode(stringArray));
    }

    protected void loadValue(String string) {
        String[] stringArray = PBooleanArraySetting.encode(string);
        float[] fArray = new float[stringArray.length];
        try {
            for (int i = 0; i < stringArray.length; ++i) {
                fArray[i] = Float.parseFloat(stringArray[i]);
            }
        }
        catch (NumberFormatException numberFormatException) {
            return;
        }
        BitSet bitSet = new BitSet(stringArray.length);
        for (int i = 0; i < fArray.length; ++i) {
            if (!(Math.random() <= (double)fArray[i])) continue;
            bitSet.set(i);
        }
        this.size = fArray.length;
        this.values = bitSet;
    }

    public void setValue(String ... stringArray) {
        this.setValueInternal(PBooleanArraySetting.decode(stringArray));
    }

    public int length() {
        return this.size;
    }

    public boolean get(int n) {
        return this.values.get(n);
    }

    private static final String[] encode(String string) {
        if (string == null || string.length() == 0) {
            return new String[0];
        }
        return StringUtils.split(string, ";");
    }

    private static final String decode(String[] stringArray) {
        if (stringArray == null || stringArray.length == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : stringArray) {
            stringBuilder.append(string).append(';');
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.setLength(stringBuilder.length() - 1);
        }
        return stringBuilder.toString();
    }
}

