/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.setting;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Properties;
import java.util.StringTokenizer;
import org.limewire.setting.AbstractSetting;
import org.limewire.util.FileUtils;

public class FileArraySetting
extends AbstractSetting {
    private File[] value;

    FileArraySetting(Properties properties, Properties properties2, String string, File[] fileArray) {
        super(properties, properties2, string, FileArraySetting.decode(fileArray));
        this.setPrivate(true);
    }

    public File[] getValue() {
        return this.value;
    }

    public synchronized void setValue(File[] fileArray) {
        this.setValueInternal(FileArraySetting.decode(fileArray));
    }

    public synchronized void add(File file) {
        if (file == null) {
            return;
        }
        File[] fileArray = new File[this.value.length + 1];
        System.arraycopy(this.value, 0, fileArray, 0, this.value.length);
        fileArray[this.value.length] = file;
        this.setValue(fileArray);
    }

    public synchronized boolean remove(File file) {
        if (file == null) {
            return false;
        }
        int n = this.indexOf(file);
        if (n == -1) {
            return false;
        }
        File[] fileArray = new File[this.value.length - 1];
        System.arraycopy(this.value, 0, fileArray, 0, n);
        System.arraycopy(this.value, n + 1, fileArray, n, this.value.length - n - 1);
        this.setValue(fileArray);
        return true;
    }

    public synchronized boolean contains(File file) {
        return this.indexOf(file) >= 0;
    }

    public synchronized int indexOf(File file) {
        if (file == null) {
            return -1;
        }
        for (int i = 0; i < this.value.length; ++i) {
            try {
                if (!FileUtils.getCanonicalFile(this.value[i]).equals(FileUtils.getCanonicalFile(file))) continue;
                return i;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return -1;
    }

    public synchronized int length() {
        return this.value.length;
    }

    protected synchronized void loadValue(String string) {
        this.value = FileArraySetting.encode(string);
    }

    private static final File[] encode(String string) {
        if (string == null || string.length() == 0) {
            return new File[0];
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        File[] fileArray = new File[stringTokenizer.countTokens()];
        for (int i = 0; i < fileArray.length; ++i) {
            fileArray[i] = new File(stringTokenizer.nextToken());
        }
        return fileArray;
    }

    private static final String decode(File[] fileArray) {
        if (fileArray == null || fileArray.length == 0) {
            return "";
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (File file : fileArray) {
            stringBuilder.append(file.getAbsolutePath()).append(';');
        }
        if (stringBuilder.length() > 0) {
            stringBuilder.setLength(stringBuilder.length() - 1);
        }
        return stringBuilder.toString();
    }

    public synchronized void clean() {
        ArrayList<File> arrayList = new ArrayList<File>(this.value.length);
        File file = null;
        for (int i = 0; i < this.value.length; ++i) {
            file = this.value[i];
            if (file == null || !file.exists()) continue;
            arrayList.add(file);
        }
        this.setValue(arrayList.toArray(new File[arrayList.size()]));
    }
}

