/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.service;

import java.io.PrintStream;
import org.limewire.service.ErrorCallback;

public final class ErrorService {
    private static volatile ErrorCallback _errorCallback = new PrintStreamErrorCallback(System.out);

    private ErrorService() {
    }

    public static void setErrorCallback(ErrorCallback errorCallback) {
        _errorCallback = errorCallback;
    }

    public static ErrorCallback getErrorCallback() {
        return _errorCallback;
    }

    public static void error(Throwable throwable) {
        _errorCallback.error(throwable);
    }

    public static void error(Throwable throwable, String string) {
        _errorCallback.error(throwable, string);
    }

    private static class PrintStreamErrorCallback
    implements ErrorCallback {
        private final PrintStream out;

        public PrintStreamErrorCallback(PrintStream printStream) {
            this.out = printStream;
        }

        public void error(Throwable throwable) {
            throwable.printStackTrace(this.out);
            throw new RuntimeException(throwable.getMessage());
        }

        public void error(Throwable throwable, String string) {
            throwable.printStackTrace(this.out);
            this.out.println(string);
            throw new RuntimeException(throwable.getMessage());
        }
    }
}

