/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.security.certificate;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import org.limewire.security.certificate.CertificateProps;
import org.limewire.security.certificate.CertificateTools;
import org.limewire.security.certificate.HashCalculator;
import org.limewire.security.certificate.HashLookupProvider;
import org.limewire.security.certificate.KeyStoreProvider;
import org.limewire.security.certificate.RootCAProvider;

@Singleton
public class RootCAProviderImpl
implements RootCAProvider {
    KeyStoreProvider keyStoreProvider;
    HashCalculator hashCalculator;
    HashLookupProvider hashLookupProvider;

    @Inject
    public RootCAProviderImpl(KeyStoreProvider keyStoreProvider, HashCalculator hashCalculator, HashLookupProvider hashLookupProvider) {
        this.keyStoreProvider = keyStoreProvider;
        this.hashCalculator = hashCalculator;
        this.hashLookupProvider = hashLookupProvider;
    }

    public X509Certificate getCertificate() throws CertificateException {
        try {
            return this.getCertificateNoRetry();
        }
        catch (CertificateException certificateException) {
            this.keyStoreProvider.invalidateKeyStore();
            return this.getCertificateNoRetry();
        }
    }

    private X509Certificate getCertificateNoRetry() throws CertificateException {
        String string = CertificateProps.getCACertAlias();
        try {
            String string2;
            KeyStore keyStore = this.keyStoreProvider.getKeyStore();
            X509Certificate x509Certificate = (X509Certificate)keyStore.getCertificate(string);
            String string3 = this.hashLookupProvider.lookup(CertificateProps.getCAHashLookupKey());
            if (string3 != null && !string3.equalsIgnoreCase(string2 = CertificateTools.getCertificateHash(x509Certificate, this.hashCalculator))) {
                throw new CertificateException("CA-hash does not match expected. actual->'" + string2 + "'!='" + string3 + "'");
            }
            return x509Certificate;
        }
        catch (IOException iOException) {
            throw new CertificateException("IOException getting certificate", iOException);
        }
        catch (KeyStoreException keyStoreException) {
            throw new CertificateException("KeyStoreException getting certificate", keyStoreException);
        }
    }
}

