/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.security.certificate;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.limewire.http.httpclient.LimeHttpClient;
import org.limewire.io.IOUtils;
import org.limewire.security.certificate.CertificateTools;
import org.limewire.security.certificate.KeyStoreProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
class KeyStoreProviderImpl
implements KeyStoreProvider {
    private volatile KeyStore keyStore = null;
    private final Provider<LimeHttpClient> httpClient;
    private volatile File keyStoreLocation;
    private volatile char[] keyStorePassword;
    private final Log LOG = LogFactory.getLog(KeyStoreProviderImpl.class);

    @Inject
    KeyStoreProviderImpl(Provider<LimeHttpClient> provider) {
        this.httpClient = provider;
        this.keyStoreLocation = CertificateTools.getKeyStoreLocation();
        this.keyStorePassword = CertificateTools.getKeyStorePassword();
    }

    void setKeyStoreLocation(File file) {
        this.keyStoreLocation = file;
    }

    void setKeyStorePassword(char[] cArray) {
        this.keyStorePassword = cArray;
    }

    @Override
    public KeyStore getKeyStore() throws IOException {
        if (this.isValid(this.keyStore)) {
            return this.keyStore;
        }
        try {
            this.keyStore = this.getKeyStoreFromDisk();
            return this.keyStore;
        }
        catch (IOException iOException) {
            this.LOG.debug((Object)"IOException trying to load keystore from disk.", (Throwable)iOException);
            OutputStream outputStream = null;
            try {
                this.keyStore = this.getKeyStoreFromNetwork();
                this.keyStoreLocation.getParentFile().mkdirs();
                outputStream = new FileOutputStream(this.keyStoreLocation);
                this.keyStore.store(outputStream, this.keyStorePassword);
                KeyStore keyStore = this.keyStore;
                return keyStore;
            }
            catch (KeyStoreException keyStoreException) {
                throw IOUtils.getIOException("KeyStoreException while saving keystore: ", keyStoreException);
            }
            catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                throw IOUtils.getIOException("NoSuchAlgorithmException while saving keystore: ", noSuchAlgorithmException);
            }
            catch (CertificateException certificateException) {
                throw IOUtils.getIOException("CertificateException while saving keystore: ", certificateException);
            }
            finally {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
        }
    }

    KeyStore getKeyStoreFromNetwork() throws IOException {
        KeyStore keyStore;
        LimeHttpClient limeHttpClient = (LimeHttpClient)this.httpClient.get();
        HttpGet httpGet = new HttpGet(CertificateTools.getKeyStoreURI());
        try {
            keyStore = KeyStore.getInstance("jks");
        }
        catch (KeyStoreException keyStoreException) {
            throw new IOException("KeyStoreException instantiating keystore: " + keyStoreException.getMessage());
        }
        HttpResponse httpResponse = null;
        try {
            try {
                httpResponse = limeHttpClient.execute((HttpUriRequest)httpGet);
            }
            catch (HttpException httpException) {
                throw (IOException)new IOException().initCause(httpException);
            }
            if (httpResponse.getStatusLine().getStatusCode() == 200) {
                try {
                    keyStore.load(httpResponse.getEntity().getContent(), this.keyStorePassword);
                }
                catch (NoSuchAlgorithmException noSuchAlgorithmException) {
                    throw IOUtils.getIOException("NoSuchAlgorithmException while parsing keystore: ", noSuchAlgorithmException);
                }
                catch (CertificateException certificateException) {
                    throw IOUtils.getIOException("CertificateException while parsing keystore: ", certificateException);
                }
                KeyStore keyStore2 = keyStore;
                return keyStore2;
            }
            throw new IOException("Failed to download new keystore (" + CertificateTools.getKeyStoreURI().toString() + "): " + httpResponse.getStatusLine());
        }
        finally {
            limeHttpClient.releaseConnection(httpResponse);
        }
    }

    KeyStore getKeyStoreFromDisk() throws IOException {
        InputStream inputStream = null;
        try {
            KeyStore keyStore = KeyStore.getInstance("jks");
            inputStream = new BufferedInputStream(new FileInputStream(this.keyStoreLocation));
            keyStore.load(inputStream, this.keyStorePassword);
            KeyStore keyStore2 = keyStore;
            return keyStore2;
        }
        catch (KeyStoreException keyStoreException) {
            throw IOUtils.getIOException("KeyStoreException while creating keystore in memory: ", keyStoreException);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw IOUtils.getIOException("NoSuchAlgorithmException while parsing keystore: ", noSuchAlgorithmException);
        }
        catch (CertificateException certificateException) {
            throw IOUtils.getIOException("CertificateException while parsing keystore: ", certificateException);
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
    }

    @Override
    public void invalidateKeyStore() {
        this.keyStore = null;
        this.keyStoreLocation.delete();
    }

    private boolean isValid(KeyStore keyStore) {
        if (keyStore == null) {
            return false;
        }
        try {
            if (keyStore.size() > 0) {
                return true;
            }
        }
        catch (KeyStoreException keyStoreException) {
            // empty catch block
        }
        return false;
    }

    @Override
    public boolean isCached() {
        if (this.isValid(this.keyStore)) {
            return true;
        }
        if (this.keyStoreLocation.exists()) {
            try {
                if (this.isValid(this.getKeyStoreFromDisk())) {
                    return true;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return false;
    }
}

