/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.security.certificate;

import com.google.inject.Singleton;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.security.certificate.HashLookupProvider;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.Record;

@Singleton
public class HashLookupProviderDNSTXTImpl
implements HashLookupProvider {
    private static final Log LOG = LogFactory.getLog(HashLookupProviderDNSTXTImpl.class);

    public String lookup(String string) {
        try {
            Lookup lookup = new Lookup(string, 16);
            lookup.run();
            int n = lookup.getResult();
            if (n != 0) {
                throw new IOException("Error during lookup: " + lookup.getErrorString());
            }
            Record[] recordArray = lookup.getAnswers();
            if (recordArray == null || recordArray.length != 1) {
                throw new IOException("Incorrect number of answers, expected 1.");
            }
            return this.stripLeadingTrailingQuotes(recordArray[0].rdataToString());
        }
        catch (IOException iOException) {
            LOG.error((Object)("Failed lookup for key '" + string + "'"), (Throwable)iOException);
            return null;
        }
    }

    String stripLeadingTrailingQuotes(String string) {
        if (string == null || string.length() == 0) {
            return string;
        }
        boolean bl = string.charAt(0) == '\"';
        boolean bl2 = string.charAt(string.length() - 1) == '\"';
        return string.substring(bl ? 1 : 0, string.length() - (bl2 ? 1 : 0));
    }
}

