/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.security.certificate;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.limewire.io.IOUtils;
import org.limewire.security.certificate.HashCalculator;

public class HashCalculatorSHA1Impl
implements HashCalculator {
    public byte[] calculate(byte[] byArray) {
        try {
            return this.calculate(new ByteArrayInputStream(byArray));
        }
        catch (IOException iOException) {
            throw new RuntimeException("Impossible IOException caught: ", iOException);
        }
    }

    public byte[] calculate(InputStream inputStream) throws IOException {
        try {
            int n;
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-1");
            byte[] byArray = new byte[65536];
            while ((n = inputStream.read(byArray)) >= 0) {
                messageDigest.update(byArray, 0, n);
            }
            return messageDigest.digest();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw IOUtils.getIOException("NoSuchAlgorithmException during computation: ", noSuchAlgorithmException);
        }
    }
}

