/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.security.certificate;

import com.google.inject.Singleton;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.CipherOutputStream;
import org.limewire.io.IOUtils;
import org.limewire.security.certificate.CipherProvider;

@Singleton
public class CipherProviderImpl
implements CipherProvider {
    public byte[] decrypt(byte[] byArray, Key key, CipherProvider.CipherType cipherType) throws IOException {
        int n;
        Object object;
        Cipher cipher;
        try {
            cipher = Cipher.getInstance(cipherType.getDescription());
            object = cipher.getParameters();
            cipher.init(2, key, (AlgorithmParameters)object);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw IOUtils.getIOException("Security exception while initializing: ", generalSecurityException);
        }
        object = new ByteArrayInputStream(byArray);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        CipherInputStream cipherInputStream = new CipherInputStream((InputStream)object, cipher);
        byte[] byArray2 = new byte[8];
        while ((n = cipherInputStream.read(byArray2)) != -1) {
            byteArrayOutputStream.write(byArray2, 0, n);
        }
        ((InputStream)object).close();
        cipherInputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    public byte[] encrypt(byte[] byArray, Key key, CipherProvider.CipherType cipherType) throws IOException {
        int n;
        Cipher cipher;
        try {
            cipher = Cipher.getInstance(cipherType.getDescription());
            cipher.init(1, key);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw IOUtils.getIOException("Security exception while initializing: ", generalSecurityException);
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        CipherOutputStream cipherOutputStream = new CipherOutputStream(byteArrayOutputStream, cipher);
        byte[] byArray2 = new byte[8];
        while ((n = byteArrayInputStream.read(byArray2)) != -1) {
            cipherOutputStream.write(byArray2, 0, n);
        }
        ((InputStream)byteArrayInputStream).close();
        cipherOutputStream.close();
        return byteArrayOutputStream.toByteArray();
    }

    public byte[] sign(byte[] byArray, PrivateKey privateKey, CipherProvider.SignatureType signatureType) throws IOException {
        try {
            Signature signature = Signature.getInstance(signatureType.getDescription());
            signature.initSign(privateKey);
            signature.update(byArray);
            return signature.sign();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw IOUtils.getIOException("NoSuchAlgorithmException during signing: ", noSuchAlgorithmException);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw IOUtils.getIOException("InvalidKeyException during signing: ", invalidKeyException);
        }
        catch (SignatureException signatureException) {
            throw IOUtils.getIOException("SignatureException during signing: ", signatureException);
        }
    }

    public boolean verify(byte[] byArray, byte[] byArray2, PublicKey publicKey, CipherProvider.SignatureType signatureType) throws IOException {
        try {
            Signature signature = Signature.getInstance(signatureType.getDescription());
            signature.initVerify(publicKey);
            signature.update(byArray);
            return signature.verify(byArray2);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw IOUtils.getIOException("NoSuchAlgorithmException during signing: ", noSuchAlgorithmException);
        }
        catch (InvalidKeyException invalidKeyException) {
            throw IOUtils.getIOException("InvalidKeyException during signing: ", invalidKeyException);
        }
        catch (SignatureException signatureException) {
            throw IOUtils.getIOException("SignatureException during signing: ", signatureException);
        }
    }
}

