/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.security.certificate;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.CertPath;
import java.security.cert.CertPathValidator;
import java.security.cert.CertPathValidatorException;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.security.certificate.CertificateVerifier;
import org.limewire.security.certificate.KeyStoreProvider;
import org.limewire.security.certificate.RootCAProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Singleton
public class CertificateVerifierImpl
implements CertificateVerifier {
    private static final Log LOG = LogFactory.getLog(CertificateVerifierImpl.class);
    private KeyStoreProvider keyStoreProvider;
    private RootCAProvider rootCAProvider;

    @Inject
    public CertificateVerifierImpl(KeyStoreProvider keyStoreProvider, RootCAProvider rootCAProvider) {
        this.keyStoreProvider = keyStoreProvider;
        this.rootCAProvider = rootCAProvider;
    }

    @Override
    public boolean isValid(Certificate certificate) {
        KeyStore keyStore;
        try {
            keyStore = this.keyStoreProvider.getKeyStore();
        }
        catch (IOException iOException) {
            LOG.error((Object)"IOException getting keyStore", (Throwable)iOException);
            return false;
        }
        try {
            CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
            CertPathValidator certPathValidator = CertPathValidator.getInstance("PKIX");
            ArrayList<Certificate> arrayList = new ArrayList<Certificate>();
            arrayList.add(certificate);
            this.populateCertList(keyStore, certificate, arrayList);
            CertPath certPath = certificateFactory.generateCertPath(arrayList);
            TrustAnchor trustAnchor = new TrustAnchor(this.rootCAProvider.getCertificate(), null);
            PKIXParameters pKIXParameters = new PKIXParameters(Collections.singleton(trustAnchor));
            pKIXParameters.setRevocationEnabled(false);
            try {
                certPathValidator.validate(certPath, pKIXParameters);
            }
            catch (CertPathValidatorException certPathValidatorException) {
                LOG.error((Object)("Validation failure, cert[" + certPathValidatorException.getIndex() + "] :"), (Throwable)certPathValidatorException);
                return false;
            }
        }
        catch (GeneralSecurityException generalSecurityException) {
            LOG.error((Object)"CertificateException caught.", (Throwable)generalSecurityException);
            return false;
        }
        return true;
    }

    private void populateCertList(KeyStore keyStore, Certificate certificate, List<Certificate> list) {
        if (certificate instanceof X509Certificate) {
            X509Certificate x509Certificate = (X509Certificate)certificate;
            String string = x509Certificate.getIssuerDN().getName();
            String string2 = "";
            for (String string3 : string.split(",")) {
                if (!string3.trim().startsWith("CN=")) continue;
                string2 = string3.trim().substring(3);
                break;
            }
            if (x509Certificate.getIssuerDN().getName().equals(x509Certificate.getSubjectDN().getName())) {
                return;
            }
            try {
                Certificate keyStoreException = keyStore.getCertificate(string2);
                if (keyStoreException == null) {
                    LOG.error((Object)("Could not find certificate alias '" + string2 + "'"));
                    return;
                }
                list.add(keyStoreException);
                this.populateCertList(keyStore, keyStoreException, list);
            }
            catch (KeyStoreException keyStoreException) {
                LOG.error((Object)"KeyStoreException caught while walking chain.", (Throwable)keyStoreException);
                return;
            }
        }
    }
}

