/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.security.certificate;

import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import org.limewire.security.certificate.CertificateProps;
import org.limewire.security.certificate.HashCalculator;
import org.limewire.util.CommonUtils;

public class CertificateTools {
    private static final char[] HEX_CHARS = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static String encodeBytesToString(byte[] byArray) {
        StringBuilder stringBuilder = new StringBuilder(byArray.length * 2);
        for (int i = 0; i < byArray.length; ++i) {
            stringBuilder.append(HEX_CHARS[(byArray[i] & 0xF0) >>> 4]);
            stringBuilder.append(HEX_CHARS[byArray[i] & 0xF]);
        }
        return stringBuilder.toString();
    }

    public static String getCertificateHash(Certificate certificate, HashCalculator hashCalculator) throws CertificateEncodingException {
        return CertificateTools.encodeBytesToString(hashCalculator.calculate(certificate.getEncoded()));
    }

    public static File getKeyStoreLocation() {
        return new File(CertificateTools.getCertificateSettingsDirectory(), "limewire.keystore");
    }

    public static File getCertificateSettingsDirectory() {
        return new File(CommonUtils.getUserSettingsDir(), "certificate/");
    }

    public static URI getKeyStoreURI() {
        try {
            return new URI(CertificateProps.getKeyStoreURLString());
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new RuntimeException("MalformedURL '" + CertificateProps.getKeyStoreURLString() + "'", uRISyntaxException);
        }
    }

    public static char[] getKeyStorePassword() {
        return "".toCharArray();
    }
}

