/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.security.certificate;

import com.google.inject.Inject;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import org.limewire.security.certificate.CertificateProvider;
import org.limewire.security.certificate.CertificateVerifier;
import org.limewire.security.certificate.KeyStoreProvider;

public class CertificateProviderImpl
implements CertificateProvider {
    private KeyStoreProvider keyStoreProvider;
    private CertificateVerifier certificateVerifier;

    @Inject
    public CertificateProviderImpl(KeyStoreProvider keyStoreProvider, CertificateVerifier certificateVerifier) {
        this.keyStoreProvider = keyStoreProvider;
        this.certificateVerifier = certificateVerifier;
    }

    public Certificate getCertificate(String string) throws CertificateException {
        try {
            KeyStore keyStore = this.keyStoreProvider.getKeyStore();
            Certificate certificate = keyStore.getCertificate(string);
            if (certificate == null) {
                throw new CertificateException("Unable to locate certificate '" + string + "'");
            }
            if (this.certificateVerifier.isValid(certificate)) {
                return certificate;
            }
            throw new CertificateException("Certificate failed validation.");
        }
        catch (KeyStoreException keyStoreException) {
            throw new CertificateException("KeyStoreException getting certificate.", keyStoreException);
        }
        catch (IOException iOException) {
            throw new CertificateException("IOException while getting certificate.", iOException);
        }
    }
}

