/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.security;

import java.security.SecureRandom;
import org.limewire.security.MACCalculator;
import org.limewire.security.SecurityToken;
import org.limewire.security.SecurityUtils;
import org.limewire.util.ByteUtils;

class TEAMACCalculator
implements MACCalculator {
    protected final int ST_LENGTH = 4;
    protected final int PRE_ROTATE;
    protected final int POST_ROTATE;
    protected final int LK0;
    protected final int LK1;
    protected final int RK0;
    protected final int RK1;
    protected final long PRE_WHITEN_KEY;
    protected final long POST_WHITEN_KEY;

    TEAMACCalculator() {
        SecureRandom secureRandom = SecurityUtils.createSecureRandomNoBlock();
        this.PRE_WHITEN_KEY = secureRandom.nextLong();
        this.POST_WHITEN_KEY = secureRandom.nextLong();
        this.LK0 = secureRandom.nextInt();
        this.LK1 = secureRandom.nextInt();
        this.RK0 = secureRandom.nextInt();
        this.RK1 = secureRandom.nextInt();
        int n = secureRandom.nextInt();
        this.PRE_ROTATE = n & 0x3F;
        this.POST_ROTATE = n >>> 26;
    }

    TEAMACCalculator(int n, int n2, int n3, int n4, int n5, int n6) {
        this.PRE_ROTATE = n5 & 0x3F;
        this.POST_ROTATE = n6 & 0x3F;
        this.POST_WHITEN_KEY = 0L;
        this.PRE_WHITEN_KEY = 0L;
        this.LK0 = n;
        this.LK1 = n2;
        this.RK0 = n3;
        this.RK1 = n4;
    }

    public byte[] getMACBytes(SecurityToken.TokenData tokenData) {
        byte[] byArray = tokenData.getData();
        long l = this.encryptCBCCMAC(byArray);
        byte[] byArray2 = new byte[4];
        int n = 3;
        int n2 = (int)(l >> 32);
        int n3 = (int)l;
        while (n >= 0) {
            int n4;
            if (n2 == 0) {
                n2 = n3;
                n3 ^= 0xFFFFFFFF;
            }
            if ((n4 = n2 & 0xFF) != 0 && n4 != 28) {
                byArray2[n] = (byte)n4;
                --n;
            }
            n2 >>>= 8;
        }
        return byArray2;
    }

    final long encryptCBCCMAC(byte[] byArray) {
        long l = 0L;
        for (int i = 0; i < byArray.length; i += 8) {
            l = this.encrypt(l ^ ByteUtils.leb2long(byArray, i, Math.min(8, byArray.length - i)));
        }
        return l;
    }

    final long encrypt(long l) {
        l = l << this.PRE_ROTATE | l >>> 64 - this.PRE_ROTATE;
        int n = (int)((l ^= this.PRE_WHITEN_KEY) >> 32);
        int n2 = (int)l;
        int n3 = 0;
        for (int i = 32; i > 0; --i) {
            n2 += ((n += (n2 << 4) + this.LK0 ^ n2 + (n3 -= 1640531527) ^ (n2 >>> 5) + this.LK1) << 4) + this.RK0 ^ n + n3 ^ (n >>> 5) + this.RK1;
        }
        l = (long)n << 32 | (long)n2 & 0xFFFFFFFFL;
        return (l ^= this.POST_WHITEN_KEY) << this.POST_ROTATE | l >>> 64 - this.POST_ROTATE;
    }
}

