/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.security;

import java.io.File;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.X509EncodedKeySpec;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.util.Base32;
import org.limewire.util.FileUtils;

public class SignatureVerifier {
    private static final Log LOG = LogFactory.getLog(SignatureVerifier.class);
    private final byte[] plainText;
    private final byte[] signature;
    private final PublicKey publicKey;
    private final String algorithm;
    private final String digAlg;

    public SignatureVerifier(byte[] byArray, byte[] byArray2, PublicKey publicKey, String string) {
        this(byArray, byArray2, publicKey, string, null);
    }

    public SignatureVerifier(byte[] byArray, byte[] byArray2, PublicKey publicKey, String string, String string2) {
        this.plainText = byArray;
        this.signature = byArray2;
        this.publicKey = publicKey;
        this.algorithm = string;
        this.digAlg = string2;
    }

    public String toString() {
        return "text: " + new String(this.plainText) + ", sig: " + new String(this.signature) + ", key: " + this.publicKey + ", alg: " + this.algorithm + ", digAlg: " + this.digAlg;
    }

    public boolean verifySignature() {
        String string = this.digAlg == null ? this.algorithm : this.digAlg + "with" + this.algorithm;
        try {
            Signature signature = Signature.getInstance(string);
            signature.initVerify(this.publicKey);
            signature.update(this.plainText, 0, this.plainText.length);
            return signature.verify(this.signature);
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            LOG.error((Object)("No alg." + this), (Throwable)noSuchAlgorithmException);
            return false;
        }
        catch (InvalidKeyException invalidKeyException) {
            LOG.error((Object)("Invalid key. " + this), (Throwable)invalidKeyException);
            return false;
        }
        catch (SignatureException signatureException) {
            LOG.error((Object)("Bad sig." + this), (Throwable)signatureException);
            return false;
        }
        catch (ClassCastException classCastException) {
            LOG.error((Object)("bad cast." + this), (Throwable)classCastException);
            return false;
        }
    }

    public static String getVerifiedData(byte[] byArray, String string, String string2, String string3) {
        PublicKey publicKey = SignatureVerifier.readKey(string, string2);
        byte[][] byArray2 = SignatureVerifier.parseData(byArray);
        if (publicKey == null || byArray2 == null) {
            LOG.warn((Object)"No key or data to verify.");
            return null;
        }
        SignatureVerifier signatureVerifier = new SignatureVerifier(byArray2[1], byArray2[0], publicKey, string2, string3);
        if (signatureVerifier.verifySignature()) {
            try {
                return new String(byArray2[1], "UTF-8");
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                return new String(byArray2[1]);
            }
        }
        return null;
    }

    public static PublicKey readKey(File file, String string) {
        byte[] byArray = FileUtils.readFileFully(file);
        if (byArray == null) {
            return null;
        }
        return SignatureVerifier.readKey(new String(byArray), string);
    }

    public static PublicKey readKey(String string, String string2) {
        try {
            X509EncodedKeySpec x509EncodedKeySpec = new X509EncodedKeySpec(Base32.decode(string));
            KeyFactory keyFactory = KeyFactory.getInstance(string2);
            PublicKey publicKey = keyFactory.generatePublic(x509EncodedKeySpec);
            return publicKey;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            LOG.error((Object)("Invalid algorithm: " + string2), (Throwable)noSuchAlgorithmException);
            return null;
        }
        catch (InvalidKeySpecException invalidKeySpecException) {
            LOG.error((Object)("Invalid keyspec: " + string), (Throwable)invalidKeySpecException);
            return null;
        }
    }

    private static byte[][] parseData(byte[] byArray) {
        if (byArray == null) {
            LOG.warn((Object)"No data to parse.");
            return null;
        }
        int n = SignatureVerifier.findPipes(byArray);
        if (n == -1 || n >= byArray.length - 3) {
            LOG.warn((Object)"Couldn't find pipes.");
            return null;
        }
        byte[] byArray2 = new byte[n];
        byte[] byArray3 = new byte[byArray.length - n - 2];
        System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
        System.arraycopy(byArray, n + 2, byArray3, 0, byArray3.length);
        return new byte[][]{Base32.decode(new String(byArray2)), byArray3};
    }

    private static int findPipes(byte[] byArray) {
        for (int i = 0; i < byArray.length - 1; ++i) {
            if (byArray[i] != 124 || byArray[i + 1] != 124) continue;
            return i;
        }
        return -1;
    }
}

