/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.security;

import com.google.inject.Singleton;
import java.io.File;
import java.security.PublicKey;
import java.util.concurrent.ExecutorService;
import org.limewire.concurrent.ExecutorsHelper;
import org.limewire.security.SecureMessage;
import org.limewire.security.SecureMessageCallback;
import org.limewire.security.SecureMessageVerifier;
import org.limewire.security.SignatureVerifier;
import org.limewire.security.Verifier;

@Singleton
public class SecureMessageVerifierImpl
implements SecureMessageVerifier {
    private final ExecutorService QUEUE;
    private PublicKey pubKey;
    private final File keyFile;
    private final String keyBase32;

    public SecureMessageVerifierImpl() {
        this(null, null, null, null);
    }

    public SecureMessageVerifierImpl(String string) {
        this(null, null, null, string);
    }

    public SecureMessageVerifierImpl(File file) {
        this(file, null, null, null);
    }

    public SecureMessageVerifierImpl(String string, String string2) {
        this(null, string, null, string2);
    }

    public SecureMessageVerifierImpl(File file, String string) {
        this(file, null, null, string);
    }

    public SecureMessageVerifierImpl(PublicKey publicKey, String string) {
        this(null, null, publicKey, string);
    }

    private SecureMessageVerifierImpl(File file, String string, PublicKey publicKey, String string2) {
        this.QUEUE = string2 == null ? ExecutorsHelper.newProcessingQueue("SecureMessageVerifier") : ExecutorsHelper.newProcessingQueue(string2 + "-SecureMessageVerifier");
        if (publicKey == null && file == null == (string == null)) {
            throw new IllegalArgumentException("must have only one source of key");
        }
        this.pubKey = publicKey;
        this.keyFile = file;
        this.keyBase32 = string;
    }

    public void verify(SecureMessage secureMessage, SecureMessageCallback secureMessageCallback) {
        this.QUEUE.execute(new VerifierImpl(this.pubKey, "SHA1withDSA", secureMessage, secureMessageCallback));
    }

    public void verify(PublicKey publicKey, String string, SecureMessage secureMessage, SecureMessageCallback secureMessageCallback) {
        if (publicKey == null) {
            throw new IllegalArgumentException("PublicKey is null");
        }
        this.QUEUE.execute(new VerifierImpl(publicKey, string, secureMessage, secureMessageCallback));
    }

    public void verify(Verifier verifier) {
        this.QUEUE.execute(verifier);
    }

    private void initializePublicKey() {
        if (this.pubKey == null) {
            this.pubKey = this.createPublicKey();
        }
    }

    protected PublicKey createPublicKey() {
        if (this.getKeyFile() == null && this.keyBase32 == null) {
            throw new NullPointerException("no key source!!");
        }
        if (this.keyBase32 != null) {
            return SignatureVerifier.readKey(this.keyBase32, "DSA");
        }
        return SignatureVerifier.readKey(this.getKeyFile(), "DSA");
    }

    protected File getKeyFile() {
        return this.keyFile;
    }

    private class VerifierImpl
    extends Verifier {
        private PublicKey pubKey;
        private String algorithm;

        VerifierImpl(PublicKey publicKey, String string, SecureMessage secureMessage, SecureMessageCallback secureMessageCallback) {
            super(secureMessage, secureMessageCallback);
            this.pubKey = publicKey;
            this.algorithm = string;
        }

        public String getAlgorithm() {
            return this.algorithm;
        }

        public PublicKey getPublicKey() {
            if (this.pubKey == null) {
                SecureMessageVerifierImpl.this.initializePublicKey();
                this.pubKey = SecureMessageVerifierImpl.this.pubKey;
            }
            return this.pubKey;
        }
    }
}

