/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.rudp.messages.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.limewire.rudp.messages.MessageFormatException;
import org.limewire.rudp.messages.RUDPMessage;
import org.limewire.util.BufferUtils;
import org.limewire.util.ByteUtils;

public abstract class RUDPMessageImpl
implements RUDPMessage {
    protected static final int MAX_DATA1_SIZE = 12;
    protected static byte[] emptyByteArray = new byte[16];
    protected final byte _connectionID;
    protected final RUDPMessage.OpCode _opcode;
    protected long _sequenceNumber;
    protected final ByteBuffer _data1;
    protected final ByteBuffer _data2;

    protected RUDPMessageImpl(byte by, RUDPMessage.OpCode opCode, long l, short s, short s2) {
        this._connectionID = by;
        this._opcode = opCode;
        this._sequenceNumber = l;
        this._data1 = ByteBuffer.allocate(4);
        this._data1.order(ByteOrder.BIG_ENDIAN);
        this._data1.putShort(s);
        this._data1.putShort(s2);
        this._data1.flip();
        this._data2 = BufferUtils.getEmptyBuffer();
    }

    protected RUDPMessageImpl(byte by, RUDPMessage.OpCode opCode, long l, byte by2) {
        this._connectionID = by;
        this._opcode = opCode;
        this._sequenceNumber = l;
        this._data1 = ByteBuffer.allocate(1);
        this._data1.put(by2);
        this._data1.flip();
        this._data2 = BufferUtils.getEmptyBuffer();
    }

    protected RUDPMessageImpl(byte by, RUDPMessage.OpCode opCode, long l, byte by2, short s) {
        this._connectionID = by;
        this._opcode = opCode;
        this._sequenceNumber = l;
        this._data1 = ByteBuffer.allocate(3);
        this._data1.order(ByteOrder.BIG_ENDIAN);
        this._data1.put(by2);
        this._data1.putShort(s);
        this._data1.flip();
        this._data2 = BufferUtils.getEmptyBuffer();
    }

    protected RUDPMessageImpl(byte by, RUDPMessage.OpCode opCode, long l, byte[] byArray, int n) {
        this._connectionID = by;
        this._opcode = opCode;
        this._sequenceNumber = l;
        this._data1 = n > 0 ? ByteBuffer.wrap(byArray, 0, Math.min(n, 12)) : BufferUtils.getEmptyBuffer();
        int n2 = Math.max(0, n - 12);
        this._data2 = n2 > 0 ? ByteBuffer.wrap(byArray, 12, n2) : BufferUtils.getEmptyBuffer();
    }

    protected RUDPMessageImpl(RUDPMessage.OpCode opCode, byte by, long l, ByteBuffer byteBuffer, ByteBuffer byteBuffer2) throws MessageFormatException {
        this._opcode = opCode;
        this._connectionID = by;
        this._sequenceNumber = l;
        this._data1 = byteBuffer;
        this._data2 = byteBuffer2;
    }

    public byte getConnectionID() {
        return this._connectionID;
    }

    public long getSequenceNumber() {
        return this._sequenceNumber;
    }

    public void extendSequenceNumber(long l) {
        this._sequenceNumber = l;
    }

    public int getDataLength() {
        return this._data1.limit() + this._data2.limit();
    }

    public int getLength() {
        return 23 + this._data2.limit();
    }

    public RUDPMessage.OpCode getOpCode() {
        return this._opcode;
    }

    protected int getData1Length() {
        return 0;
    }

    public void write(OutputStream outputStream) throws IOException {
        outputStream.write(this._connectionID);
        outputStream.write((this._opcode.toByte() & 0xF) << 4 | (byte)this.getData1Length() & 0xF);
        outputStream.write((byte)((this._sequenceNumber & 0xFF00L) >> 8));
        outputStream.write((byte)(this._sequenceNumber & 0xFFL));
        if (this._data1.hasRemaining()) {
            outputStream.write(this._data1.array(), this._data1.arrayOffset() + this._data1.position(), this._data1.remaining());
        }
        if (this._data1.remaining() < 12) {
            outputStream.write(emptyByteArray, 0, 12 - this._data1.remaining());
        }
        outputStream.write(65);
        outputStream.write(1);
        outputStream.write(0);
        ByteUtils.int2leb(this._data2.remaining(), outputStream);
        if (this._data2.hasRemaining()) {
            outputStream.write(this._data2.array(), this._data2.arrayOffset() + this._data2.position(), this._data2.remaining());
        }
    }
}

