/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.rudp.messages.impl;

import java.nio.ByteBuffer;
import org.limewire.rudp.messages.DataMessage;
import org.limewire.rudp.messages.MessageFormatException;
import org.limewire.rudp.messages.RUDPMessage;
import org.limewire.rudp.messages.impl.RUDPMessageImpl;

class DataMessageImpl
extends RUDPMessageImpl
implements DataMessage {
    private final ByteBuffer chunk;

    DataMessageImpl(byte by, long l, ByteBuffer byteBuffer) {
        super(by, RUDPMessage.OpCode.OP_DATA, l, byteBuffer.array(), byteBuffer.remaining());
        this.chunk = byteBuffer;
    }

    DataMessageImpl(byte by, long l, byte[] byArray, int n) {
        super(by, RUDPMessage.OpCode.OP_DATA, l, byArray, n);
        this.chunk = null;
    }

    public ByteBuffer getChunk() {
        return this.chunk;
    }

    DataMessageImpl(byte by, long l, ByteBuffer byteBuffer, ByteBuffer byteBuffer2) throws MessageFormatException {
        super(RUDPMessage.OpCode.OP_DATA, by, l, byteBuffer, byteBuffer2);
        this.chunk = null;
    }

    public ByteBuffer getData1Chunk() {
        return this._data1;
    }

    public ByteBuffer getData2Chunk() {
        return this._data2;
    }

    public byte getDataAt(int n) {
        if (n < 12) {
            return this._data1.get(n + this._data1.position());
        }
        return this._data2.get(n - 12 + this._data2.position());
    }

    public String toString() {
        return "DataMessage DestID:" + this.getConnectionID() + " len:" + this.getDataLength() + " seq:" + this.getSequenceNumber();
    }

    protected int getData1Length() {
        return this._data1.limit();
    }
}

