/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.rudp;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.spi.SelectorProvider;
import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.nio.AbstractNBSocket;
import org.limewire.nio.NIODispatcher;
import org.limewire.nio.channel.InterestReadableByteChannel;
import org.limewire.nio.channel.InterestWritableByteChannel;
import org.limewire.nio.observer.WriteObserver;
import org.limewire.rudp.AbstractNBSocketChannel;
import org.limewire.rudp.ChunkReleaser;
import org.limewire.rudp.DataRecord;
import org.limewire.rudp.DataWindow;
import org.limewire.rudp.DefaultRUDPContext;
import org.limewire.rudp.RUDPContext;
import org.limewire.rudp.UDPConnection;
import org.limewire.rudp.UDPConnectionProcessor;
import org.limewire.rudp.messages.DataMessage;
import org.limewire.util.BufferUtils;

class UDPSocketChannel
extends AbstractNBSocketChannel
implements InterestReadableByteChannel,
InterestWritableByteChannel,
ChunkReleaser {
    private static final Log LOG = LogFactory.getLog(UDPSocketChannel.class);
    private final UDPConnectionProcessor processor;
    private final RUDPContext context;
    private final AbstractNBSocket socket;
    private final DataWindow readData;
    private volatile WriteObserver writer;
    private final ArrayList<ByteBuffer> chunks;
    private ByteBuffer activeChunk;
    private boolean writeHandled = false;
    private final Object writeLock = new Object();
    private boolean shutdown = false;
    long last = 0L;

    UDPSocketChannel(SelectorProvider selectorProvider, RUDPContext rUDPContext) {
        super(selectorProvider);
        this.context = rUDPContext;
        this.processor = new UDPConnectionProcessor(this, rUDPContext);
        this.readData = this.processor.getReadWindow();
        this.chunks = new ArrayList(5);
        this.socket = new UDPConnection(rUDPContext, this);
        this.allocateNewChunk();
        try {
            this.configureBlocking(false);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    UDPSocketChannel(UDPConnectionProcessor uDPConnectionProcessor) {
        super(null);
        this.context = new DefaultRUDPContext();
        this.processor = uDPConnectionProcessor;
        this.readData = uDPConnectionProcessor.getReadWindow();
        this.chunks = new ArrayList(5);
        this.socket = new UDPConnection(this.context, this);
        this.allocateNewChunk();
        try {
            this.configureBlocking(false);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    UDPConnectionProcessor getProcessor() {
        return this.processor;
    }

    public void interestRead(boolean bl) {
        NIODispatcher.instance().interestRead(this, bl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int read(ByteBuffer byteBuffer) throws IOException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
        UDPConnectionProcessor uDPConnectionProcessor = this.processor;
        synchronized (uDPConnectionProcessor) {
            int n;
            int n2 = this.readData.getWindowSpace();
            int n3 = 0;
            DataRecord dataRecord = this.readData.getReadableBlock();
            while (dataRecord != null) {
                n3 += this.transfer(dataRecord, byteBuffer);
                if (!byteBuffer.hasRemaining()) break;
                dataRecord = this.readData.getReadableBlock();
            }
            if ((n = this.readData.clearEarlyReadBlocks()) > 0 && n2 == 0) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Sending aritifial keep alive: cleared=" + n + ", priorSpace=" + n2 + ", read=" + n3 + ", windowSpace=" + this.readData.getWindowSpace() + ", windowStart=" + this.readData.getWindowStart()));
                }
                this.processor.sendKeepAlive();
            }
            if (n3 == 0 && this.processor.isClosed()) {
                return -1;
            }
            return n3;
        }
    }

    private int transfer(DataRecord dataRecord, ByteBuffer byteBuffer) {
        DataMessage dataMessage = dataRecord.msg;
        int n = 0;
        ByteBuffer byteBuffer2 = dataMessage.getData1Chunk();
        if (byteBuffer2.hasRemaining()) {
            n += BufferUtils.transfer(byteBuffer2, byteBuffer, false);
        }
        if (byteBuffer2.hasRemaining()) {
            return n;
        }
        byteBuffer2 = dataMessage.getData2Chunk();
        n += BufferUtils.transfer(byteBuffer2, byteBuffer, false);
        if (!byteBuffer2.hasRemaining()) {
            dataRecord.read = true;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int write(ByteBuffer byteBuffer) throws IOException {
        if (!this.isOpen() || this.processor.isClosed()) {
            throw new ClosedChannelException();
        }
        Object object = this.writeLock;
        synchronized (object) {
            if (this.getNumberOfPendingChunks() == 0) {
                this.processor.wakeupWriteEvent(!this.writeHandled);
            }
            this.writeHandled = true;
            int n = 0;
            while (byteBuffer.hasRemaining()) {
                if (this.activeChunk.hasRemaining()) {
                    n += BufferUtils.transfer(byteBuffer, this.activeChunk, false);
                    continue;
                }
                if (this.chunks.size() < this.processor.getChunkLimit()) {
                    this.chunks.add(this.activeChunk);
                    this.allocateNewChunk();
                    continue;
                }
                return n;
            }
            return n;
        }
    }

    private void allocateNewChunk() {
        this.activeChunk = NIODispatcher.instance().getBufferCache().getHeap(512);
    }

    public void releaseChunk(ByteBuffer byteBuffer) {
        NIODispatcher.instance().getBufferCache().release(byteBuffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ByteBuffer getNextChunk() {
        Object object = this.writeLock;
        synchronized (object) {
            ByteBuffer byteBuffer;
            if (this.chunks.size() > 0) {
                byteBuffer = this.chunks.remove(0);
                byteBuffer.flip();
            } else if (this.activeChunk.position() > 0) {
                byteBuffer = this.activeChunk;
                byteBuffer.flip();
                this.allocateNewChunk();
            } else {
                byteBuffer = null;
            }
            return byteBuffer;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int getNumberOfPendingChunks() {
        Object object = this.writeLock;
        synchronized (object) {
            int n = this.chunks.size();
            if (this.activeChunk.position() > 0) {
                ++n;
            }
            return n;
        }
    }

    Object writeLock() {
        return this.writeLock;
    }

    protected void implCloseSelectableChannel() throws IOException {
        this.processor.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        WriteObserver writeObserver = this;
        synchronized (writeObserver) {
            if (this.shutdown) {
                return;
            }
            this.shutdown = true;
        }
        writeObserver = this.writer;
        if (writeObserver != null) {
            writeObserver.shutdown();
        }
        this.writer = null;
    }

    public void interestWrite(WriteObserver writeObserver, boolean bl) {
        if (this.isOpen()) {
            this.writer = writeObserver;
            NIODispatcher.instance().interestWrite(this, bl);
        }
    }

    public boolean handleWrite() throws IOException {
        WriteObserver writeObserver = this.writer;
        if (writeObserver != null) {
            return writeObserver.handleWrite();
        }
        return false;
    }

    public void handleIOException(IOException iOException) {
        throw new UnsupportedOperationException();
    }

    public InetSocketAddress getRemoteSocketAddress() {
        return this.processor.getSocketAddress();
    }

    public boolean connect(SocketAddress socketAddress) throws IOException {
        this.processor.connect((InetSocketAddress)socketAddress);
        return false;
    }

    public boolean finishConnect() throws IOException {
        return this.processor.prepareOpenConnection();
    }

    public boolean isConnected() {
        return this.processor.isConnected();
    }

    public boolean isConnectionPending() {
        return this.processor.isConnecting();
    }

    public AbstractNBSocket socket() {
        return this.socket;
    }

    public long read(ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
        throw new IOException("unsupported");
    }

    public long write(ByteBuffer[] byteBufferArray, int n, int n2) throws IOException {
        throw new IOException("unsupported");
    }

    protected void implConfigureBlocking(boolean bl) throws IOException {
    }

    void eventPending() {
        this.context.getTransportListener().eventPending();
    }

    public boolean hasBufferedOutput() {
        return this.getNumberOfPendingChunks() > 0;
    }
}

